/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class RavenEntity
extends ShoulderRidingEntity
implements FlyingAnimal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42697_, Items.f_42733_});
    public int featherTime;

    public RavenEntity(EntityType<RavenEntity> type, Level worldIn) {
        super(type, worldIn);
        this.featherTime = this.f_19796_.m_188503_(12000) + 12000;
        this.m_8099_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LandOnOwnersShoulderGoal((ShoulderRidingEntity)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22280_, (double)0.4f).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22284_, 0.0).m_22265_();
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 motion = this.m_20184_();
        if (!this.m_20096_() && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && --this.featherTime <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Registry.RAVEN_FEATHER.get());
            this.featherTime = this.f_19796_.m_188503_(12000) + 12000;
        }
    }

    public int m_5639_(float distance, float damageMultiplier) {
        return 0;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42733_;
    }

    public AgeableMob m_142606_(@NotNull ServerLevel world, @NotNull AgeableMob entity) {
        return (AgeableMob)((EntityType)EidolonEntities.RAVEN.get()).m_20615_((Level)world);
    }

    public boolean m_29895_(ServerPlayer player) {
        if (player.m_36331_().m_128441_("UUID") && player.m_36331_().m_128342_("UUID").equals(this.m_20148_())) {
            return false;
        }
        if (player.m_36332_().m_128441_("UUID") && player.m_36332_().m_128342_("UUID").equals(this.m_20148_())) {
            return false;
        }
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("id", this.m_20078_());
        this.m_20240_(compoundnbt);
        if (player.m_36360_(compoundnbt)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42733_) {
            if (!this.m_21824_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        if (this.m_20096_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!this.f_19853_.f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected void m_7324_(@NotNull Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }
}

