/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.gui.ClearPanelGUI;
import com.dannyandson.tinyredstone.gui.PanelCrashGUI;
import com.dannyandson.tinyredstone.gui.TinyBlockGUI;
import com.dannyandson.tinyredstone.setup.Registration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PanelBlock
extends BaseEntityBlock {
    private static final Map<Direction, VoxelShape> BASE = new HashMap<Direction, VoxelShape>();
    private static final Map<Item, Class<? extends IPanelCell>> itemPanelCellMap;
    private static final Map<Class<? extends IPanelCell>, Item> panelCellItemMap;
    private static final Map<Item, Class<? extends IPanelCover>> itemPanelCoverMap;
    private static final Map<Class<? extends IPanelCover>, Item> panelCoverItemMap;

    public PanelBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60978_(2.0f));
    }

    public Class<? extends IPanelCell> getIPanelCellByItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public static Item getItemByIPanelCell(Class<? extends IPanelCell> panelCell) {
        return panelCellItemMap.get(panelCell);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PanelTile(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)t;
                panelTile.tick();
            }
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
        builder.m_61104_(new Property[]{Registration.HAS_PANEL_BASE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        CompoundTag itemTag;
        Boolean hasBase = context.m_43722_().m_41720_() == Registration.REDSTONE_PANEL_ITEM.get();
        if (context.m_43722_().m_41782_() && (itemTag = context.m_43722_().m_41783_().m_128469_("BlockEntityTag")).m_128441_("hasBase") && !itemTag.m_128471_("hasBase")) {
            hasBase = false;
        }
        if (hasBase.booleanValue()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)Registration.HAS_PANEL_BASE, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN)).m_61124_((Property)Registration.HAS_PANEL_BASE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = source.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            VoxelShape cellShape;
            PanelTile panelTile = (PanelTile)blockEntity;
            if (panelTile.panelCellHovering != null && (cellShape = panelTile.getCellVoxelShape(panelTile.panelCellHovering)) != null) {
                if (panelTile.hasBase()) {
                    return Shapes.m_83110_((VoxelShape)BASE.get(state.m_61143_((Property)BlockStateProperties.f_61372_)), (VoxelShape)cellShape);
                }
                return cellShape;
            }
        }
        return this.m_5939_(state, source, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter source, BlockPos pos) {
        BlockEntity te = source.m_7702_(pos);
        if (te instanceof PanelTile) {
            return ((PanelTile)te).getVoxelShape();
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext context) {
        BlockEntity te = source.m_7702_(pos);
        if (te instanceof PanelTile) {
            return ((PanelTile)te).getVoxelShape();
        }
        if (state.m_61138_((Property)Registration.HAS_PANEL_BASE) && ((Boolean)state.m_61143_((Property)Registration.HAS_PANEL_BASE)).booleanValue()) {
            return BASE.get(state.m_61143_((Property)BlockStateProperties.f_61372_));
        }
        if (context == CollisionContext.m_82749_()) {
            return Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        }
        return Shapes.m_83040_();
    }

    public boolean m_7899_(BlockState iBlockState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            if (direction != null) {
                Direction facing = direction.m_122424_();
                return panelTile.hasCellsOnFace(facing);
            }
        }
        return super.canConnectRedstone(state, world, pos, direction);
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter world, BlockPos pos, Direction directionFromNeighborToThis) {
        return false;
    }

    public int m_6378_(BlockState state, BlockGetter blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        BlockEntity tileentity = blockReader.m_7702_(pos);
        if (tileentity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)tileentity;
            Integer power = panelTile.weakPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.m_122424_()));
            return power == null ? 0 : power;
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter blockReader, BlockPos pos, Direction directionFromNeighborToThis) {
        BlockEntity blockEntity = blockReader.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            Integer power = panelTile.strongPowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.m_122424_()));
            if ((power == null || power < 15) && Blocks.f_50088_.m_7899_(state) && PanelTile.getCheckWireSignals()) {
                Integer power2 = panelTile.wirePowerToNeighbors.get((Object)panelTile.getSideFromDirection(directionFromNeighborToThis.m_122424_()));
                power = power == null || power2 != null && power2 > power ? power2 : power;
            }
            return power == null ? 0 : power;
        }
        return 0;
    }

    public void m_6861_(BlockState currentState, Level world, BlockPos pos, Block blockIn, BlockPos neighborPos, boolean isMoving) {
        Direction direction;
        if (pos.m_122029_().equals((Object)neighborPos)) {
            direction = Direction.EAST;
        } else if (pos.m_122019_().equals((Object)neighborPos)) {
            direction = Direction.SOUTH;
        } else if (pos.m_122024_().equals((Object)neighborPos)) {
            direction = Direction.WEST;
        } else if (pos.m_122012_().equals((Object)neighborPos)) {
            direction = Direction.NORTH;
        } else if (pos.m_7494_().equals((Object)neighborPos)) {
            direction = Direction.UP;
        } else if (pos.m_7495_().equals((Object)neighborPos)) {
            direction = Direction.DOWN;
        } else {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            boolean change = false;
            try {
                Side side = panelTile.getSideFromDirection(direction);
                if (side != null) {
                    if (panelTile.pingOutwardObservers(direction)) {
                        change = true;
                    }
                    panelTile.updateSide(direction);
                    if (panelTile.isFlagOutputUpdate()) {
                        panelTile.updateOutputs();
                    }
                }
                if (panelTile.updateSideConnections() || change) {
                    panelTile.flagSync();
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return true;
    }

    private ItemStack getItemWithNBT(BlockGetter worldIn, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)blockEntity;
            ItemStack itemstack = this.m_7397_(worldIn, pos, state);
            CompoundTag compoundNBT = panelTile.saveToNbt(new CompoundTag());
            compoundNBT.m_128379_("hasBase", panelTile.hasBase());
            if (!compoundNBT.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundNBT);
            }
            return itemstack;
        }
        return null;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        PanelTile panelTile = null;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof PanelTile) {
            PanelTile pt;
            panelTile = pt = (PanelTile)blockEntity;
            panelTile.onBlockDestroy();
        }
        if (!player.m_7500_() && (panelTile == null || panelTile.hasBase() || panelTile.getCellCount() > 0)) {
            ItemStack itemstack;
            ItemStack itemStack = itemstack = panelTile.getCellCount() > 0 || panelTile.Color != RenderHelper.getTextureDiffusedColor(DyeColor.GRAY) || panelTile.panelCover != null ? this.getItemWithNBT((BlockGetter)worldIn, pos, state) : new ItemStack((ItemLike)this);
            if (itemstack != null) {
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                worldIn.m_7967_((Entity)itementity);
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        PanelCellPos panelCellPos;
        IPanelCell cell;
        PanelTile panelTile;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PanelTile && !(panelTile = (PanelTile)te).isCovered() && (cell = panelTile.getIPanelCell(panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), panelTile.getPlayerCollisionHitResult(player)))) != null) {
            ItemStack itemStack = panelCellItemMap.get(cell.getClass()).m_7968_();
            CompoundTag itemTag = cell.getItemTag();
            if (itemTag != null) {
                for (String key : itemTag.m_128431_()) {
                    itemStack.m_41700_(key, itemTag.m_128423_(key));
                }
            }
            return itemStack;
        }
        ItemStack itemStack = this.getItemWithNBT(world, pos, state);
        if (itemStack == null) {
            return super.getCloneItemStack(state, target, world, pos, player);
        }
        return itemStack;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        boolean handled;
        block50: {
            handled = false;
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)te;
                if (hand == InteractionHand.MAIN_HAND) {
                    try {
                        blockHitResult = panelTile.getPlayerCollisionHitResult(player);
                        PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, blockHitResult);
                        Item heldItem = player.m_21120_(hand).m_41720_();
                        if (!(posInPanelCell != null && posInPanelCell.getIPanelCell() != null || !heldItem.m_7968_().m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench"))) || player.m_6047_() || panelTile.isCovered())) {
                            panelTile.rotate(Rotation.CLOCKWISE_90);
                            handled = true;
                            state.m_60701_((LevelAccessor)world, pos, 3);
                        }
                        if (posInPanelCell == null) break block50;
                        if (panelTile.isCrashed() || panelTile.isOverflown()) {
                            if (world.f_46443_) {
                                PanelCrashGUI.open(panelTile);
                            }
                            handled = true;
                        } else if (heldItem.m_7968_().m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench"))) && player.m_6047_()) {
                            this.m_5707_(world, pos, state, player);
                            if (!world.f_46443_) {
                                world.m_46961_(pos, true);
                            }
                            handled = true;
                        } else if (heldItem == Registration.TINY_COLOR_SELECTOR.get() && posInPanelCell.getIPanelCell() instanceof IColorablePanelCell) {
                            if (world.f_46443_) {
                                TinyBlockGUI.open(panelTile, posInPanelCell.getIndex(), (IColorablePanelCell)((Object)posInPanelCell.getIPanelCell()));
                            }
                            handled = true;
                        } else if (heldItem instanceof DyeItem && posInPanelCell.getIPanelCell() == null) {
                            int color = RenderHelper.getTextureDiffusedColor(((DyeItem)heldItem).m_41089_());
                            if (color != panelTile.Color) {
                                panelTile.Color = color;
                                if (!player.m_7500_()) {
                                    player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                }
                            }
                            handled = true;
                        } else {
                            if (heldItem.equals(Items.f_42127_) && player.m_6302_().equals("Dev")) {
                                throw new Exception("Test Exception");
                            }
                            if (itemPanelCoverMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                try {
                                    Object panelCoverObject = itemPanelCoverMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                    if (panelCoverObject instanceof IPanelCover) {
                                        panelTile.panelCover = (IPanelCover)panelCoverObject;
                                        ((IPanelCover)panelCoverObject).onPlace(panelTile, player);
                                        panelTile.flagLightUpdate = true;
                                        panelTile.flagVoxelShapeUpdate();
                                        if (!world.f_46443_) {
                                            world.m_7260_(pos, state, state, 2);
                                        }
                                        if (!player.m_7500_()) {
                                            player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                        }
                                        handled = true;
                                    }
                                }
                                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                    TinyRedstone.LOGGER.error("Exception thrown while" + e.getMessage());
                                }
                            } else if (posInPanelCell.getIPanelCell() != null && !panelTile.isCovered() && posInPanelCell.getIPanelCell().hasActivation(player) && !player.m_6047_()) {
                                if (posInPanelCell.getIPanelCell().onBlockActivated(posInPanelCell, posInPanelCell.getSegment(), player)) {
                                    panelTile.updateCell(posInPanelCell);
                                    panelTile.updateNeighborCells(posInPanelCell);
                                    if (posInPanelCell.getIPanelCell() instanceof RedstoneDust) {
                                        PanelCellPos above = posInPanelCell.offset(Side.TOP);
                                        PanelCellPos below = posInPanelCell.offset(Side.BOTTOM);
                                        if (above != null) {
                                            panelTile.updateNeighborCells(above);
                                        }
                                        if (below != null) {
                                            panelTile.updateNeighborCells(below);
                                        }
                                    }
                                }
                                handled = true;
                            } else if (itemPanelCellMap.containsKey(heldItem) && !panelTile.isCovered()) {
                                PanelCellPos placementPos = posInPanelCell;
                                if (placementPos.getIPanelCell() != null) {
                                    placementPos = posInPanelCell.offset(panelTile.getSideFromDirection(blockHitResult.m_82434_()));
                                }
                                if (placementPos != null && placementPos.getIPanelCell() == null && !panelTile.checkCellForPistonExtension(placementPos)) {
                                    try {
                                        Object panelCell = itemPanelCellMap.get(heldItem).getConstructors()[0].newInstance(new Object[0]);
                                        if (panelCell instanceof IPanelCell) {
                                            Side cellFacing;
                                            IPanelCell cell = (IPanelCell)panelCell;
                                            boolean placementOK = true;
                                            Side rotationLock = RotationLock.getServerRotationLock(player);
                                            Side side = cellFacing = rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing(player, cell.canPlaceVertical())) : rotationLock;
                                            if (cell.needsSolidBase()) {
                                                Side attachingSideRel;
                                                Side attachingSideDir = panelTile.getSideFromDirection(blockHitResult.m_82434_()).getOpposite();
                                                Side side2 = attachingSideRel = attachingSideDir == Side.TOP || attachingSideDir == Side.BOTTOM ? attachingSideDir : Side.FRONT;
                                                if (!(cell.canAttachToBaseOnSide(attachingSideRel) && (posInPanelCell.equals(placementPos) || posInPanelCell.getIPanelCell() != null && posInPanelCell.getIPanelCell().isPushable()))) {
                                                    placementOK = false;
                                                } else {
                                                    cell.setBaseSide(attachingSideRel);
                                                    if (attachingSideRel == Side.FRONT) {
                                                        cellFacing = attachingSideDir;
                                                    }
                                                }
                                            }
                                            if (placementOK) {
                                                placementPos.getPanelTile().addCell(placementPos, cell, cellFacing, player);
                                                if (!player.m_7500_()) {
                                                    player.m_21120_(hand).m_41764_(player.m_21120_(hand).m_41613_() - 1);
                                                }
                                                state.m_60701_((LevelAccessor)world, pos, 3);
                                            }
                                            handled = true;
                                        }
                                    }
                                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                                        TinyRedstone.LOGGER.error((Object)e);
                                    }
                                }
                            } else if (panelTile.isOverflown()) {
                                if (world.f_46443_) {
                                    PanelCrashGUI.open(panelTile);
                                }
                                handled = true;
                            }
                        }
                        panelTile.flagSync();
                        if (!world.f_46443_) {
                            panelTile.m_6596_();
                        }
                        if (panelTile.isFlagOutputUpdate()) {
                            panelTile.updateOutputs();
                        }
                    }
                    catch (Exception e) {
                        panelTile.handleCrash(e);
                    }
                }
            }
        }
        if (handled) {
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, blockHitResult);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        int ll = 0;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            ll = panelTile.getLightOutput();
        }
        return Math.min(ll, world.m_7469_());
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity te;
        Item heldItem = player.m_21205_().m_41720_();
        if ((heldItem.m_7968_().m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench"))) || itemPanelCellMap.containsKey(heldItem) || itemPanelCoverMap.containsKey(heldItem)) && (te = world.m_7702_(pos)) instanceof PanelTile) {
            PanelTile panelTile = (PanelTile)te;
            try {
                if (panelTile.isCovered()) {
                    this.removeCover(panelTile, player);
                    panelTile.flagLightUpdate = true;
                } else if (heldItem.m_7968_().m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/wrench"))) && player.m_6047_()) {
                    if (world.m_5776_()) {
                        ClearPanelGUI.open(panelTile);
                    }
                } else {
                    BlockHitResult result = panelTile.getPlayerCollisionHitResult(player);
                    PanelCellPos panelCellPos = PanelCellPos.fromHitVec(panelTile, (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_), result);
                    if (panelCellPos != null && panelCellPos.getIPanelCell() != null) {
                        this.removeCell(panelCellPos, player);
                    }
                }
            }
            catch (Exception e) {
                panelTile.handleCrash(e);
            }
        }
    }

    protected void removeCell(PanelCellPos cellPos, @Nullable Player player) {
        if (cellPos.getIPanelCell() != null) {
            PanelTile panelTile = cellPos.getPanelTile();
            Level world = panelTile.m_58904_();
            BlockPos pos = panelTile.m_58899_();
            if (player == null || !player.m_7500_()) {
                Item item = panelCellItemMap.get(cellPos.getIPanelCell().getClass());
                ItemStack itemStack = new ItemStack((ItemLike)item);
                CompoundTag itemTag = cellPos.getIPanelCell().getItemTag();
                if (itemTag != null) {
                    for (String key : itemTag.m_128431_()) {
                        itemStack.m_41700_(key, itemTag.m_128423_(key));
                    }
                }
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), itemStack);
                world.m_7967_((Entity)itemEntity);
                if (player != null) {
                    itemEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                }
            }
            panelTile.removeCell(cellPos);
            panelTile.m_58900_().m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    private void removeCover(PanelTile panelTile, Player player) {
        if (panelTile.isCovered()) {
            Level world = panelTile.m_58904_();
            BlockPos pos = panelTile.m_58899_();
            if (!player.m_7500_()) {
                Item item = panelCoverItemMap.get(panelTile.panelCover.getClass());
                ItemStack itemStack = new ItemStack((ItemLike)item);
                CompoundTag coverTag = panelTile.panelCover.getItemTag();
                if (coverTag != null) {
                    for (String key : coverTag.m_128431_()) {
                        itemStack.m_41700_(key, coverTag.m_128423_(key));
                    }
                }
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), itemStack);
                world.m_7967_((Entity)itemEntity);
                itemEntity.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
            panelTile.panelCover = null;
            panelTile.flagVoxelShapeUpdate();
            panelTile.flagSync();
        }
    }

    public static void registerPanelCell(Class<? extends IPanelCell> iPanelCellClass, Item correspondingItem) {
        itemPanelCellMap.put(correspondingItem, iPanelCellClass);
        panelCellItemMap.put(iPanelCellClass, correspondingItem);
    }

    public static void registerPanelCover(Class<? extends IPanelCover> iPanelCellCover, Item correspondingItem) {
        itemPanelCoverMap.put(correspondingItem, iPanelCellCover);
        panelCoverItemMap.put(iPanelCellCover, correspondingItem);
    }

    public static Item getPanelCellItemFromClass(Class<? extends IPanelCell> iPanelCellClass) {
        return panelCellItemMap.get(iPanelCellClass);
    }

    public static Class<? extends IPanelCell> getPanelCellClassFromItem(Item item) {
        return itemPanelCellMap.get(item);
    }

    public static boolean isPanelCellItem(Item item) {
        return itemPanelCellMap.containsKey(item);
    }

    static {
        BASE.put(Direction.UP, Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.DOWN, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        BASE.put(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));
        BASE.put(Direction.EAST, Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0));
        BASE.put(Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0));
        itemPanelCellMap = new HashMap<Item, Class<? extends IPanelCell>>();
        panelCellItemMap = new HashMap<Class<? extends IPanelCell>, Item>();
        itemPanelCoverMap = new HashMap<Item, Class<? extends IPanelCover>>();
        panelCoverItemMap = new HashMap<Class<? extends IPanelCover>, Item>();
    }
}

