/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.IrisReloadManager;
import mc.euphoria_patches.shadow.org.apache.commons.io.FileUtils;

public class ErrorShaderGenerator {
    private static final String ERROR_SHADER_FOLDER = "_0EuphoriaPatches Error Shader";
    private static final String ERROR_TEXTS_FILE = "shaders/errorTexts.glsl";
    private static final int MAX_LINE_LENGTH = 90;
    private static final Map<Character, String> CHAR_TO_GLSL = new HashMap<Character, String>();

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ErrorShaderGenerator] " + message);
    }

    public static void generateErrorShader(List<String> errorMessages) {
        try {
            ErrorShaderGenerator.debugLog("Generating error shader with " + errorMessages.size() + " messages");
            Path targetDir = EuphoriaPatcher.shaderpacks.resolve(ERROR_SHADER_FOLDER);
            boolean isErrorShaderActive = ErrorShaderGenerator.isErrorShaderActive();
            ErrorShaderGenerator.debugLog("Error shader is " + (isErrorShaderActive ? "active" : "not active"));
            if (Files.exists(targetDir, new LinkOption[0])) {
                ErrorShaderGenerator.debugLog("Error shader directory already exists, updating files");
            } else {
                ErrorShaderGenerator.debugLog("Creating new error shader directory");
                Files.createDirectories(targetDir, new FileAttribute[0]);
                boolean copySuccess = ErrorShaderGenerator.copyErrorShaderFolder(targetDir);
                if (!copySuccess) {
                    EuphoriaPatcher.log(2, "Failed to copy error shader folder");
                    return;
                }
            }
            String glslErrorText = ErrorShaderGenerator.generateGLSLErrorText(errorMessages);
            Path errorTextsPath = targetDir.resolve(ERROR_TEXTS_FILE);
            if (Files.exists(errorTextsPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(errorTextsPath.getParent(), new FileAttribute[0]);
            }
            Files.write(errorTextsPath, glslErrorText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            ErrorShaderGenerator.debugLog("Successfully updated errorTexts.glsl");
            if (isErrorShaderActive) {
                ErrorShaderGenerator.debugLog("Scheduling shader reload since error shader is active");
                ErrorShaderGenerator.scheduleShaderReload();
            }
        }
        catch (IOException e) {
            ErrorShaderGenerator.debugLog("Exception generating error shader: " + e.getMessage());
            EuphoriaPatcher.log(3, "Error generating error shader: " + e.getMessage());
        }
    }

    private static boolean isErrorShaderActive() {
        Path currentShaderPath = UpdateShaderLoaderConfig.getCurrentShaderpackPath();
        if (currentShaderPath == null) {
            return false;
        }
        String shaderName = currentShaderPath.getFileName().toString();
        return shaderName.contains("EuphoriaPatches Error Shader");
    }

    private static void scheduleShaderReload() {
        ErrorShaderGenerator.debugLog("Scheduling shader reload for error shader updates");
        IrisReloadManager.findAndScheduleReload();
    }

    private static boolean copyErrorShaderFolder(Path targetDir) {
        try {
            String[] filesToCopy;
            String resourcePath = ERROR_SHADER_FOLDER;
            Path sourcePath = Paths.get("src/main/resources/" + resourcePath, new String[0]);
            if (Files.exists(sourcePath, new LinkOption[0])) {
                FileUtils.copyDirectory(sourcePath.toFile(), targetDir.toFile());
                return true;
            }
            ClassLoader classLoader = ErrorShaderGenerator.class.getClassLoader();
            for (String file : filesToCopy = new String[]{"shaders/composite.fsh", "shaders/composite.vsh", "shaders/dh_terrain.fsh", "shaders/dh_terrain.vsh", "shaders/dh_water.fsh", "shaders/dh_water.vsh", ERROR_TEXTS_FILE, "shaders/euphoria_patches.png", "shaders/euphoria_patches.png.mcmeta", "shaders/gbuffers_armor_glint.fsh", "shaders/gbuffers_armor_glint.vsh", "shaders/gbuffers_basic.fsh", "shaders/gbuffers_basic.vsh", "shaders/gbuffers_beaconbeam.fsh", "shaders/gbuffers_beaconbeam.vsh", "shaders/gbuffers_clouds.fsh", "shaders/gbuffers_clouds.vsh", "shaders/gbuffers_entities.fsh", "shaders/gbuffers_entities.vsh", "shaders/gbuffers_hand.fsh", "shaders/gbuffers_hand.vsh", "shaders/gbuffers_skybasic.fsh", "shaders/gbuffers_skybasic.vsh", "shaders/gbuffers_skytextured.fsh", "shaders/gbuffers_skytextured.vsh", "shaders/gbuffers_terrain.fsh", "shaders/gbuffers_terrain.vsh", "shaders/gbuffers_textured.fsh", "shaders/gbuffers_textured.vsh", "shaders/gbuffers_weather.fsh", "shaders/gbuffers_weather.vsh", "shaders/pack.json", "shaders/shaders.properties", "shaders/textRenderer.glsl", "shaders/warning.png"}) {
                InputStream is = classLoader.getResourceAsStream(resourcePath + "/" + file);
                if (is != null) {
                    Path targetFile = targetDir.resolve(file);
                    Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                    Files.copy(is, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    is.close();
                    continue;
                }
                ErrorShaderGenerator.debugLog("Could not find resource: " + resourcePath + "/" + file);
            }
            return true;
        }
        catch (IOException e) {
            ErrorShaderGenerator.debugLog("Error copying error shader folder: " + e.getMessage());
            EuphoriaPatcher.log(2, "Error copying error shader folder: " + e.getMessage());
            return false;
        }
    }

    private static String generateGLSLErrorText(List<String> messages) {
        StringBuilder glsl = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            String message = messages.get(i);
            if (message.startsWith("EuphoriaPatcher: ")) {
                message = message.substring("EuphoriaPatcher: ".length());
            }
            List<String> lines = ErrorShaderGenerator.splitTextIntoLines(message);
            glsl.append("beginTextError(3, offset);\n");
            for (int j = 0; j < lines.size(); ++j) {
                String line = lines.get(j);
                CharSequence[] chars = ErrorShaderGenerator.convertTextToGLSLChars(line);
                glsl.append("    printString((").append(String.join((CharSequence)", ", chars)).append("));\n");
                if (j >= lines.size() - 1) continue;
                glsl.append("    printLine();\n");
            }
            glsl.append("endText(textColor);\n\n");
            if (i >= messages.size() - 1) continue;
            glsl.append("offset.y += ").append(lines.size()).append(";\n\n");
        }
        return glsl.toString();
    }

    private static List<String> splitTextIntoLines(String text) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text.length() <= 90) {
            lines.add(text);
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > 90) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private static String[] convertTextToGLSLChars(String text) {
        ArrayList<String> result = new ArrayList<String>();
        for (char c : text.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                result.add("_" + c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                result.add("_" + c);
                continue;
            }
            if (!CHAR_TO_GLSL.containsKey(Character.valueOf(c))) continue;
            result.add(CHAR_TO_GLSL.get(Character.valueOf(c)));
        }
        return result.toArray(new String[0]);
    }

    static {
        CHAR_TO_GLSL.put(Character.valueOf(' '), "_space");
        CHAR_TO_GLSL.put(Character.valueOf('_'), "_under");
        CHAR_TO_GLSL.put(Character.valueOf('\"'), "_quote");
        CHAR_TO_GLSL.put(Character.valueOf('!'), "_exclm");
        CHAR_TO_GLSL.put(Character.valueOf('>'), "_gt");
        CHAR_TO_GLSL.put(Character.valueOf('<'), "_lt");
        CHAR_TO_GLSL.put(Character.valueOf('['), "_opsqr");
        CHAR_TO_GLSL.put(Character.valueOf(']'), "_clsqr");
        CHAR_TO_GLSL.put(Character.valueOf('('), "_opprn");
        CHAR_TO_GLSL.put(Character.valueOf(')'), "_clprn");
        CHAR_TO_GLSL.put(Character.valueOf('\u2588'), "_block");
        CHAR_TO_GLSL.put(Character.valueOf('\u00a9'), "_copyr");
        CHAR_TO_GLSL.put(Character.valueOf('='), "_equal");
        CHAR_TO_GLSL.put(Character.valueOf('+'), "_plus");
        CHAR_TO_GLSL.put(Character.valueOf('.'), "_dot");
        CHAR_TO_GLSL.put(Character.valueOf('-'), "_minus");
        CHAR_TO_GLSL.put(Character.valueOf(','), "_comma");
        CHAR_TO_GLSL.put(Character.valueOf(':'), "_colon");
        CHAR_TO_GLSL.put(Character.valueOf('/'), "_slash");
    }
}

