/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.gui.widget.ioconfig;

import com.enderio.EnderIO;
import com.enderio.api.io.IOMode;
import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.machines.client.gui.widget.ioconfig.IOConfigButton;
import com.enderio.machines.client.gui.widget.ioconfig.IOModeMap;
import com.enderio.machines.client.rendering.model.ModelRenderUtil;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class IOConfigWidget<U extends EIOScreen<?>>
extends AbstractWidget {
    private static final Quaternionf ROT_180_Z = Axis.f_252403_.m_252961_((float)Math.PI);
    private static final Vec3 RAY_ORIGIN = new Vec3(1.5, 1.5, 1.5);
    private static final Vec3 RAY_START = new Vec3(1.5, 1.5, -1.0);
    private static final Vec3 RAY_END = new Vec3(1.5, 1.5, 3.0);
    private static final BlockPos POS = new BlockPos(1, 1, 1);
    private static final int Z_OFFSET = 100;
    private static final ResourceLocation SELECTED_ICON = EnderIO.loc("block/overlay/selected_face");
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static MultiBufferSource.BufferSource ghostBuffers;
    private final U addedOn;
    private final Vector3f worldOrigin;
    private final Vector3f multiblockSize;
    private final List<BlockPos> configurable = new ArrayList<BlockPos>();
    private final List<BlockPos> neighbours = new ArrayList<BlockPos>();
    private final Font screenFont;
    private float SCALE = 20.0f;
    private float pitch;
    private float yaw;
    private boolean neighbourVisible = true;
    private Optional<SelectedFace> selection = Optional.empty();

    public IOConfigWidget(U addedOn, int x, int y, int width, int height, BlockPos configurable, Font font) {
        this(addedOn, x, y, width, height, List.of(configurable), font);
    }

    public IOConfigWidget(U addedOn, int x, int y, int width, int height, List<BlockPos> _configurable, Font font) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.addedOn = addedOn;
        this.configurable.addAll(_configurable);
        this.screenFont = font;
        if (this.configurable.size() == 1) {
            BlockPos bc = this.configurable.get(0);
            this.worldOrigin = new Vector3f((float)bc.m_123341_() + 0.5f, (float)bc.m_123342_() + 0.5f, (float)bc.m_123343_() + 0.5f);
            this.multiblockSize = new Vector3f(1.0f, 1.0f, 1.0f);
        } else {
            Vector3f min = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            Vector3f max = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            for (BlockPos bc : this.configurable) {
                min.set(Math.min((float)bc.m_123341_(), min.x()), Math.min((float)bc.m_123342_(), min.y()), Math.min((float)bc.m_123343_(), min.z()));
                max.set(Math.max((float)bc.m_123341_(), max.x()), Math.max((float)bc.m_123342_(), max.y()), Math.max((float)bc.m_123343_(), max.z()));
            }
            this.multiblockSize = max;
            this.multiblockSize.sub((Vector3fc)min);
            this.multiblockSize.mul(0.5f);
            this.worldOrigin = new Vector3f(min.x() + this.multiblockSize.x(), min.y() + this.multiblockSize.y(), min.z() + this.multiblockSize.z());
            this.multiblockSize.mul(2.0f);
        }
        float radius = Math.max(Math.max(this.multiblockSize.x(), this.multiblockSize.y()), this.multiblockSize.z());
        this.SCALE -= (radius - 1.0f) * 3.0f;
        this.SCALE = Math.min(40.0f, Math.max(10.0f, this.SCALE));
        this.configurable.forEach(pos -> {
            for (Direction dir : Direction.values()) {
                BlockPos loc = pos.m_121945_(dir);
                if (this.configurable.contains(loc) || this.neighbours.contains(loc)) continue;
                this.neighbours.add(loc);
            }
        });
        this.pitch = IOConfigWidget.MINECRAFT.f_91074_.m_146909_();
        this.yaw = IOConfigWidget.MINECRAFT.f_91074_.m_146908_();
        ghostBuffers = IOConfigWidget.initBuffers(MINECRAFT.m_91269_().m_110104_());
    }

    private static Vec3 transform(Vec3 vec, Matrix4f transform) {
        Vector4f vec4 = new Vector4f((float)(vec.f_82479_ - IOConfigWidget.RAY_ORIGIN.f_82479_), (float)(vec.f_82480_ - IOConfigWidget.RAY_ORIGIN.f_82480_), (float)(vec.f_82481_ - IOConfigWidget.RAY_ORIGIN.f_82481_), 1.0f);
        vec4.mul((Matrix4fc)transform);
        return new Vec3((double)vec4.x() + IOConfigWidget.RAY_ORIGIN.f_82479_, (double)vec4.y() + IOConfigWidget.RAY_ORIGIN.f_82480_, (double)vec4.z() + IOConfigWidget.RAY_ORIGIN.f_82481_);
    }

    @Nullable
    private BlockHitResult raycast(BlockPos pos, BlockState state, float diffX, float diffY, Matrix4f transform) {
        Vec3 start = RAY_START.m_82520_((double)diffX, (double)diffY, 0.0);
        Vec3 end = RAY_END.m_82520_((double)diffX, (double)diffY, 0.0);
        start = IOConfigWidget.transform(start, transform);
        end = IOConfigWidget.transform(end, transform);
        VoxelShape shape = state.m_60808_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
        Vector3f centerPos = new Vector3f((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f).sub((Vector3fc)this.worldOrigin);
        shape = shape.m_83216_((double)centerPos.x(), (double)centerPos.y(), (double)centerPos.z());
        return shape.m_83220_(start, end, POS);
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        BufferBuilder fallback = original.f_109904_;
        Map layerBuffers = original.f_109905_;
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry e : layerBuffers.entrySet()) {
            remapped.put(GhostRenderLayer.remap((RenderType)e.getKey()), (BufferBuilder)e.getValue());
        }
        return new GhostBuffers(fallback, (Map<RenderType, BufferBuilder>)remapped);
    }

    public void toggleNeighbourVisibility() {
        this.neighbourVisible = !this.neighbourVisible;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.f_93623_ && this.f_93624_ && pButton == 1 && this.selection.isPresent()) {
            SelectedFace selectedFace = this.selection.get();
            BlockEntity entity = IOConfigWidget.MINECRAFT.f_91073_.m_7702_(selectedFace.blockPos);
            if (entity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)entity;
                machine.getIOConfig().cycleMode(selectedFace.side);
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
        }
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.f_93624_ && this.m_7972_(pButton) && this.m_5953_(pMouseX, pMouseY)) {
            double dx = pDragX / (double)((EIOScreen)this.addedOn).f_96543_;
            double dy = pDragY / (double)((EIOScreen)this.addedOn).f_96544_;
            this.yaw = (float)((double)this.yaw + 4.0 * dx * 180.0);
            this.pitch = (float)((double)this.pitch + 2.0 * dy * 180.0);
            this.pitch = Math.min(80.0f, Math.max(-80.0f, this.pitch));
        }
        return false;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.f_93624_) {
            this.SCALE = (float)((double)this.SCALE - pDelta);
            this.SCALE = Math.min(40.0f, Math.max(10.0f, this.SCALE));
            return true;
        }
        return false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.addedOn.m_7522_((GuiEventListener)this);
            }
            guiGraphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
            int centerX = this.m_252754_() + this.f_93618_ / 2;
            int centerY = this.m_252907_() + this.f_93619_ / 2;
            float diffX = (float)(mouseX - centerX) / this.SCALE;
            float diffY = (float)(mouseY - centerY) / this.SCALE;
            Quaternionf rotPitch = Axis.f_252495_.m_252977_(this.pitch);
            Quaternionf rotYaw = Axis.f_252436_.m_252977_(this.yaw);
            Quaternionf blockTransform = new Quaternionf((Quaternionfc)ROT_180_Z);
            blockTransform.mul((Quaternionfc)rotPitch);
            blockTransform.mul((Quaternionfc)rotYaw);
            this.renderWorld(guiGraphics, centerX, centerY, blockTransform, partialTick);
            Matrix4f rayTransform = new Matrix4f();
            rayTransform.set((Quaternionfc)ROT_180_Z);
            rayTransform.rotate((Quaternionfc)rotYaw);
            rayTransform.rotate((Quaternionfc)rotPitch);
            HashMap hits = new HashMap();
            this.configurable.forEach(blockPos -> {
                BlockState state = IOConfigWidget.MINECRAFT.f_91073_.m_8055_(blockPos);
                BlockHitResult hit = this.raycast((BlockPos)blockPos, state, diffX, diffY, rayTransform);
                if (hit != null && hit.m_6662_() != HitResult.Type.MISS) {
                    hits.put(hit, blockPos);
                }
            });
            Vec3 eyePosition = IOConfigWidget.transform(RAY_START, rayTransform).m_82520_((double)this.worldOrigin.x, (double)this.worldOrigin.y, (double)this.worldOrigin.z);
            this.selection = hits.entrySet().stream().min(Comparator.comparingDouble(entry -> ((BlockPos)entry.getValue()).m_203193_((Position)eyePosition))).map(closest -> new SelectedFace((BlockPos)closest.getValue(), ((BlockHitResult)closest.getKey()).m_82434_()));
            this.renderSelection(guiGraphics, centerX, centerY, blockTransform);
            this.renderOverlay(guiGraphics);
            guiGraphics.m_280618_();
        }
    }

    private void renderWorld(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform, float partialTick) {
        Lighting.m_84930_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY, 100.0f);
        guiGraphics.m_280168_().m_85841_(this.SCALE, this.SCALE, -this.SCALE);
        guiGraphics.m_280168_().m_252781_(transform);
        if (this.neighbourVisible) {
            for (BlockPos neighbour : this.neighbours) {
                Vector3f pos = new Vector3f((float)neighbour.m_123341_() - this.worldOrigin.x(), (float)neighbour.m_123342_() - this.worldOrigin.y(), (float)neighbour.m_123343_() - this.worldOrigin.z());
                this.renderBlock(guiGraphics, neighbour, pos, ghostBuffers, partialTick);
            }
        }
        ghostBuffers.m_109911_();
        MultiBufferSource.BufferSource normalBuffers = MINECRAFT.m_91269_().m_110104_();
        for (BlockPos configurable : this.configurable) {
            Vector3f pos = new Vector3f((float)configurable.m_123341_() - this.worldOrigin.x(), (float)configurable.m_123342_() - this.worldOrigin.y(), (float)configurable.m_123343_() - this.worldOrigin.z());
            this.renderBlock(guiGraphics, configurable, pos, normalBuffers, partialTick);
        }
        normalBuffers.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderBlock(GuiGraphics guiGraphics, BlockPos blockPos, Vector3f renderPos, MultiBufferSource.BufferSource buffers, float partialTick) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(renderPos.x(), renderPos.y(), renderPos.z());
        ModelData modelData = Optional.ofNullable(IOConfigWidget.MINECRAFT.f_91073_.getModelDataManager().getAt(blockPos)).orElse(ModelData.EMPTY);
        BlockState blockState = IOConfigWidget.MINECRAFT.f_91073_.m_8055_(blockPos);
        RenderShape rendershape = blockState.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            BlockEntityRenderer beRenderer;
            BlockRenderDispatcher renderer = MINECRAFT.m_91289_();
            BakedModel bakedmodel = renderer.m_110910_(blockState);
            modelData = bakedmodel.getModelData((BlockAndTintGetter)IOConfigWidget.MINECRAFT.f_91073_, blockPos, blockState, modelData);
            int blockColor = MINECRAFT.m_91298_().m_92577_(blockState, (BlockAndTintGetter)IOConfigWidget.MINECRAFT.f_91073_, blockPos, 0);
            float r = (float)FastColor.ARGB32.m_13665_((int)blockColor) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)blockColor) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)blockColor) / 255.0f;
            for (RenderType renderType : bakedmodel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                renderer.m_110937_().renderModel(guiGraphics.m_280168_().m_85850_(), buffers.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false)), blockState, bakedmodel, r, g, b, 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
            }
            BlockEntity blockEntity = IOConfigWidget.MINECRAFT.f_91073_.m_7702_(blockPos);
            if (blockEntity != null && (beRenderer = MINECRAFT.m_167982_().m_112265_(blockEntity)) != null) {
                beRenderer.m_6922_(blockEntity, partialTick, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderSelection(GuiGraphics guiGraphics, int centerX, int centerY, Quaternionf transform) {
        if (this.selection.isEmpty()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY, 100.0f);
        guiGraphics.m_280168_().m_85841_(this.SCALE, this.SCALE, -this.SCALE);
        guiGraphics.m_280168_().m_252781_(transform);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172814_);
        TextureAtlasSprite tex = (TextureAtlasSprite)MINECRAFT.m_91258_(InventoryMenu.f_39692_).apply(SELECTED_ICON);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex.m_247685_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        SelectedFace selectedFace = this.selection.get();
        BlockPos blockPos = selectedFace.blockPos;
        guiGraphics.m_280168_().m_252880_((float)blockPos.m_123341_() - this.worldOrigin.x(), (float)blockPos.m_123342_() - this.worldOrigin.y(), (float)blockPos.m_123343_() - this.worldOrigin.z());
        Vector3f[] vec = (Vector3f[])Arrays.stream(ModelRenderUtil.createQuadVerts(selectedFace.side, 0.0, 1.0, 1.0)).map(Vec3::m_252839_).toArray(Vector3f[]::new);
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        bufferbuilder.m_252986_(matrix4f, vec[0].x(), vec[0].y(), vec[0].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118409_(), tex.m_118411_()).m_5752_();
        bufferbuilder.m_252986_(matrix4f, vec[1].x(), vec[1].y(), vec[1].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118409_(), tex.m_118412_()).m_5752_();
        bufferbuilder.m_252986_(matrix4f, vec[2].x(), vec[2].y(), vec[2].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118410_(), tex.m_118412_()).m_5752_();
        bufferbuilder.m_252986_(matrix4f, vec[3].x(), vec[3].y(), vec[3].z()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(tex.m_118410_(), tex.m_118411_()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderOverlay(GuiGraphics guiGraphics) {
        if (this.selection.isPresent()) {
            SelectedFace selectedFace = this.selection.get();
            BlockEntity entity = IOConfigWidget.MINECRAFT.f_91073_.m_7702_(selectedFace.blockPos);
            if (entity instanceof MachineBlockEntity) {
                MachineBlockEntity machine = (MachineBlockEntity)entity;
                IOMode ioMode = machine.getIOConfig().getMode(selectedFace.side);
                IOModeMap map = IOModeMap.getMapFromMode(ioMode);
                Rect2i iconBounds = map.getRect();
                int n = this.m_252754_() + 4;
                int n2 = this.m_252907_() + this.f_93619_ - 4;
                Objects.requireNonNull(this.screenFont);
                guiGraphics.m_280163_(IOConfigButton.IOCONFIG, n, n2 - 9 - iconBounds.m_110091_(), (float)iconBounds.m_110085_(), (float)iconBounds.m_110086_(), iconBounds.m_110090_(), iconBounds.m_110091_(), 48, 32);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
                Component component = map.getComponent();
                int n3 = this.m_252754_() + 4;
                int n4 = this.m_252907_() + this.f_93619_ - 2;
                Objects.requireNonNull(this.screenFont);
                guiGraphics.m_280430_(this.screenFont, component, n3, n4 - 9, -1);
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    private static class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> REMAPPED_TYPES = new IdentityHashMap<RenderType, RenderType>();

        private GhostRenderLayer(RenderType original) {
            super(String.format("%s_%s_ghost", original.toString(), "enderio"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((Double)MachinesConfig.CLIENT.IO_CONFIG_NEIGHBOUR_TRANSPARENCY.get()).floatValue());
            }, () -> {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.enableDepthTest();
                original.m_110188_();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return REMAPPED_TYPES.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static class GhostBuffers
    extends MultiBufferSource.BufferSource {
        private GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> layerBuffers) {
            super(fallback, layerBuffers);
        }

        public VertexConsumer m_6299_(RenderType type) {
            return super.m_6299_(GhostRenderLayer.remap(type));
        }
    }

    private record SelectedFace(BlockPos blockPos, Direction side) {
    }
}

