/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.conduit.block;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.SlotType;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.client.particle.ConduitBreakParticle;
import com.enderio.conduits.common.ConduitShape;
import com.enderio.conduits.common.conduit.ConduitBundle;
import com.enderio.conduits.common.conduit.ConduitBundleNetworkDataSlot;
import com.enderio.conduits.common.conduit.ConduitGraphObject;
import com.enderio.conduits.common.conduit.RightClickAction;
import com.enderio.conduits.common.conduit.SlotData;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.conduit.connection.StaticConnectionStates;
import com.enderio.conduits.common.init.ConduitCapabilities;
import com.enderio.conduits.common.menu.ConduitMenu;
import com.enderio.conduits.common.network.ConduitSavedData;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConduitBlockEntity
extends EnderBlockEntity {
    public static final ModelProperty<ConduitBundle> BUNDLE_MODEL_PROPERTY = new ModelProperty();
    public static final ModelProperty<BlockPos> POS = new ModelProperty();
    private final ConduitShape shape = new ConduitShape();
    private final ConduitBundle bundle;
    @UseOnly(value=LogicalSide.CLIENT)
    private ConduitBundle clientBundle;
    private UpdateState checkConnection = UpdateState.NONE;
    private final Map<ConduitType<?>, ConduitGraphObject<?>> lazyNodes = new HashMap();
    private ListTag lazyNodeNBT = new ListTag();

    public ConduitBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.bundle = new ConduitBundle(this::scheduleTick, worldPosition);
        this.clientBundle = this.bundle.deepCopy();
        this.addDataSlot(new ConduitBundleNetworkDataSlot(this::getBundle));
        this.addAfterSyncRunnable(this::updateClient);
    }

    public void updateClient() {
        this.clientBundle = this.bundle.deepCopy();
        this.updateShape();
        this.requestModelDataUpdate();
        this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void handleConnectionStateUpdate(Direction direction, ConduitType<?> conduitType, DynamicConnectionState connectionState) {
        if (this.bundle.getConnectionState(direction, conduitType) instanceof DynamicConnectionState) {
            this.bundle.setConnectionState(direction, conduitType, connectionState);
            ConduitBlockEntity.pushIOState(direction, this.bundle.getNodeFor(conduitType), connectionState);
        }
        this.updateClient();
        this.updateConnectionToData(conduitType);
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void handleExtendedDataUpdate(ConduitType<?> conduitType, CompoundTag compoundTag) {
        ConduitGraphObject<?> node = this.getBundle().getNodeFor(conduitType);
        node.getConduitData().deserializeNBT((Tag)compoundTag);
    }

    private void scheduleTick() {
        this.m_6596_();
    }

    public void onLoad() {
        this.updateShape();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.sync();
            this.bundle.onLoad(this.f_58857_, this.m_58899_());
            for (Map.Entry entry : this.lazyNodes.entrySet()) {
                ConduitGraphObject node = (ConduitGraphObject)entry.getValue();
                for (Direction dir : Direction.values()) {
                    this.tryConnectTo(dir, (ConduitType)entry.getKey(), false, false, false).ifPresent(otherNode -> Graph.connect((GraphObject)node, (GraphObject)otherNode));
                }
                for (GraphObject object : node.getGraph().getObjects()) {
                    if (!(object instanceof ConduitGraphObject)) continue;
                    ConduitGraphObject otherNode2 = (ConduitGraphObject)object;
                    node.getConduitData().onConnectTo(otherNode2.getConduitData().cast());
                }
                ConduitSavedData.addPotentialGraph((ConduitType)entry.getKey(), Objects.requireNonNull(node.getGraph()), serverLevel);
            }
        }
    }

    public boolean stillValid(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.canReach(this.f_58858_, 1.5);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ConduitSavedData savedData = ConduitSavedData.get(serverLevel);
            this.bundle.getTypes().forEach(type -> this.onChunkUnloaded(savedData, (ConduitType)type));
        }
    }

    private <T extends ConduitData<T>> void onChunkUnloaded(ConduitSavedData savedData, ConduitType<T> conduitType) {
        ConduitGraphObject<T> node = this.bundle.getNodeFor(conduitType);
        node.getConduitData().onRemoved(conduitType, this.f_58857_, this.m_58899_());
        savedData.putUnloadedNodeIdentifier(conduitType, this.f_58858_, node);
    }

    public void everyTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.serverTick();
            this.checkConnection = this.checkConnection.next();
            if (this.checkConnection.isInitialized()) {
                this.updateConnections(this.f_58857_, this.f_58858_, null, false);
            }
        }
    }

    public void updateConnections(Level level, BlockPos pos, @Nullable BlockPos fromPos, boolean shouldActivate) {
        for (Direction direction : Direction.values()) {
            if (fromPos != null && level.m_7702_(fromPos) instanceof ConduitBlockEntity) continue;
            for (ConduitType<?> type : this.bundle.getTypes()) {
                ConnectionState connectionState;
                if (shouldActivate && type.getTicker().hasConnectionDelay()) {
                    this.checkConnection = this.checkConnection.activate();
                }
                if ((connectionState = this.bundle.getConnectionState(direction, type)) instanceof DynamicConnectionState) {
                    DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                    if (type.getTicker().canForceConnect(level, pos, direction)) continue;
                    this.bundle.getNodeFor(type).clearState(direction);
                    this.dropConnection(dyn);
                    this.bundle.setConnectionState(direction, type, StaticConnectionStates.DISCONNECTED);
                    this.updateShape();
                    this.updateConnectionToData(type);
                    continue;
                }
                if (connectionState != StaticConnectionStates.DISCONNECTED) continue;
                this.tryConnectTo(direction, type, true, true, false);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ConduitBundle", (Tag)this.bundle.serializeNBT());
        ListTag listTag = new ListTag();
        for (ConduitType<?> type : this.bundle.getTypes()) {
            Object data = this.bundle.getNodeFor(type).getConduitData();
            listTag.add((Object)data.serializeNBT());
        }
        tag.m_128365_("ConduitExtraData", (Tag)listTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bundle.deserializeNBT(tag.m_128469_("ConduitBundle"));
        this.lazyNodeNBT = tag.m_128437_("ConduitExtraData", 10);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (!this.f_58857_.m_5776_()) {
            this.loadFromSavedData();
        }
    }

    public ModelData getModelData() {
        return ModelData.builder().with(BUNDLE_MODEL_PROPERTY, (Object)this.clientBundle).with(POS, (Object)this.f_58858_).build();
    }

    public boolean hasType(ConduitType<?> type) {
        return this.bundle.hasType(type);
    }

    public RightClickAction addType(ConduitType<?> type, Player player) {
        RightClickAction action = this.bundle.addType(this.f_58857_, type, player);
        if (action.hasChanged()) {
            RightClickAction.Upgrade upgrade;
            ArrayList nodes = new ArrayList();
            for (Direction dir : Direction.values()) {
                this.tryConnectTo(dir, type, false, false, false).ifPresent(nodes::add);
            }
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ConduitGraphObject<?> thisNode = Objects.requireNonNull(this.bundle.getNodeForTypeExact(type), "no node found in conduit");
                Graph.integrate(thisNode, nodes);
                for (GraphObject object : thisNode.getGraph().getObjects()) {
                    if (!(object instanceof ConduitGraphObject)) continue;
                    ConduitGraphObject node = (ConduitGraphObject)object;
                    thisNode.getConduitData().onConnectTo(node.getConduitData().cast());
                }
                ConduitSavedData.addPotentialGraph(type, Objects.requireNonNull(thisNode.getGraph()), serverLevel);
            }
            if (action instanceof RightClickAction.Upgrade && !(upgrade = (RightClickAction.Upgrade)action).getNotInConduit().getTicker().canConnectTo(upgrade.getNotInConduit(), type)) {
                this.removeNeighborConnections(upgrade.notInConduit());
            }
            this.updateShape();
        }
        return action;
    }

    public <T extends ConduitData<T>> Optional<GraphObject<Mergeable.Dummy>> tryConnectTo(Direction dir, ConduitType<T> type, boolean forceMerge, boolean shouldMergeGraph, boolean forceConnection) {
        ConduitBlockEntity conduit;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (blockEntity instanceof ConduitBlockEntity && (conduit = (ConduitBlockEntity)blockEntity).connectTo(dir.m_122424_(), type, (ConduitData<T>)this.bundle.getNodeFor(type).getConduitData(), forceMerge)) {
            this.connect(dir, type);
            this.updateConnectionToData(type);
            conduit.updateConnectionToData(type);
            ConduitGraphObject<T> firstNode = conduit.getBundle().getNodeFor(type);
            ConduitGraphObject<T> secondNode = this.bundle.getNodeFor(type);
            firstNode.getConduitData().onConnectTo(secondNode.getConduitData());
            if (firstNode.getParentGraph() != null) {
                for (ConduitNode<T> node : firstNode.getParentGraph().getNodes()) {
                    if (node == firstNode) continue;
                    firstNode.getConduitData().onConnectTo(node.getConduitData());
                }
            }
            if (secondNode.getParentGraph() != null && firstNode.getParentGraph() != secondNode.getParentGraph()) {
                for (ConduitNode<T> node : secondNode.getParentGraph().getNodes()) {
                    if (node == secondNode) continue;
                    secondNode.getConduitData().onConnectTo(node.getConduitData());
                }
            }
            if (shouldMergeGraph) {
                Graph.connect(this.bundle.getNodeFor(type), conduit.bundle.getNodeFor(type));
            }
            return Optional.of(conduit.bundle.getNodeFor(type));
        }
        if (type.getTicker().canConnectTo(this.f_58857_, this.m_58899_(), dir) || forceConnection && type.getTicker().canForceConnect(this.f_58857_, this.m_58899_(), dir)) {
            DynamicConnectionState dyn;
            ConnectionState connectionState = this.bundle.getConnectionState(dir, type);
            if (connectionState instanceof DynamicConnectionState && (dyn = (DynamicConnectionState)connectionState).isConnection()) {
                this.updateConnectionToData(type);
                return Optional.empty();
            }
            this.connectEnd(dir, type);
            this.updateConnectionToData(type);
        } else {
            this.disconnect(dir, type);
        }
        return Optional.empty();
    }

    public void updateConnectionToData(ConduitType<?> type) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.getBundle().getNodeFor(type).getConduitData().updateConnection(Arrays.stream(Direction.values()).filter(streamDir -> this.bundle.getConnectionState((Direction)streamDir, type) != StaticConnectionStates.DISABLED).collect(Collectors.toSet()));
        }
    }

    public void removeTypeAndDelete(Player player, ConduitType<?> type) {
        if (this.removeType(type, !player.m_150110_().f_35937_)) {
            this.f_58857_.m_7731_(this.m_58899_(), this.m_58900_().m_60819_().m_76188_(), this.f_58857_.f_46443_ ? 11 : 3);
        }
    }

    public boolean removeType(ConduitType<?> type, boolean shouldDrop) {
        if (shouldDrop && !this.f_58857_.m_5776_()) {
            this.dropItem(type.getConduitItem().m_7968_());
            for (Direction dir : Direction.values()) {
                ConnectionState connectionState = this.bundle.getConnectionState(dir, type);
                if (!(connectionState instanceof DynamicConnectionState)) continue;
                DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                this.dropConnection(dyn);
            }
        }
        boolean shouldRemove = this.bundle.removeType(this.f_58857_, type);
        this.removeNeighborConnections(type);
        this.updateShape();
        if (this.f_58857_.f_46443_) {
            ConduitBreakParticle.addDestroyEffects(this.m_58899_(), type);
        }
        return shouldRemove;
    }

    public void destroyAllConnections() {
        List<ConduitType<?>> typesToRemove = List.copyOf(this.bundle.getTypes());
        for (ConduitType<?> type : typesToRemove) {
            this.bundle.removeType(this.f_58857_, type);
            this.removeNeighborConnections(type);
        }
        this.updateShape();
    }

    public void dropConnection(DynamicConnectionState dyn) {
        for (SlotType slotType : SlotType.values()) {
            ItemStack item = dyn.getItem(slotType);
            if (item.m_41619_()) continue;
            this.dropItem(item);
        }
    }

    private void dropItem(ItemStack stack) {
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), stack));
    }

    public void removeNeighborConnections(ConduitType<?> type) {
        for (Direction dir : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
            if (!(blockEntity instanceof ConduitBlockEntity)) continue;
            ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
            conduit.disconnect(dir.m_122424_(), type);
        }
        Direction[] directionArray = this.f_58857_;
        if (directionArray instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            for (Direction dir : Direction.values()) {
                ConduitBlockEntity conduit;
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                if (!(blockEntity instanceof ConduitBlockEntity) || !(conduit = (ConduitBlockEntity)blockEntity).hasType(type)) continue;
                Optional.of(conduit.bundle.getNodeFor(type)).map(ConduitGraphObject::getGraph).filter(Objects::nonNull).ifPresent(graph -> ConduitSavedData.addPotentialGraph(type, (Graph<Mergeable.Dummy>)graph, serverLevel));
            }
        }
    }

    public void updateShape() {
        this.shape.updateConduit(this.bundle);
    }

    @UseOnly(value=LogicalSide.SERVER)
    private void loadFromSavedData() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ConduitSavedData savedData = ConduitSavedData.get(serverLevel);
        for (int typeIndex = 0; typeIndex < this.bundle.getTypes().size(); ++typeIndex) {
            ConduitType<?> type = this.bundle.getTypes().get(typeIndex);
            this.loadConduitFromSavedData(savedData, type, typeIndex);
        }
        this.lazyNodeNBT.clear();
    }

    @UseOnly(value=LogicalSide.SERVER)
    private <T extends ConduitData<T>> void loadConduitFromSavedData(ConduitSavedData savedData, ConduitType<T> conduitType, int typeIndex) {
        if (this.f_58857_ == null) {
            return;
        }
        ConduitGraphObject<T> node = savedData.takeUnloadedNodeIdentifier(conduitType, this.f_58858_);
        if (node == null && this.bundle.getNodeForTypeExact(conduitType) == null) {
            T data = conduitType.createConduitData(this.f_58857_, this.f_58858_);
            if (typeIndex < this.lazyNodeNBT.size()) {
                data.deserializeNBT((Tag)this.lazyNodeNBT.m_128728_(typeIndex));
            }
            node = new ConduitGraphObject<T>(this.f_58858_, data);
            Graph.integrate(node, List.of());
            this.bundle.setNodeFor(conduitType, node);
            this.lazyNodes.put(conduitType, node);
        } else if (node != null) {
            this.bundle.setNodeFor(conduitType, node);
        }
    }

    private <T extends ConduitData<T>> boolean connectTo(Direction direction, ConduitType<T> type, ConduitData<T> data, boolean forceMerge) {
        if (!this.doTypesMatch(type)) {
            return false;
        }
        if (!data.canConnectTo(this.bundle.getNodeFor(type).getConduitData())) {
            return false;
        }
        if (forceMerge || this.bundle.getConnectionState(direction, type) != StaticConnectionStates.DISABLED) {
            this.connect(direction, type);
            return true;
        }
        return false;
    }

    private boolean doTypesMatch(ConduitType<?> type) {
        for (ConduitType<?> bundleType : this.bundle.getTypes()) {
            if (!bundleType.getTicker().canConnectTo(bundleType, type)) continue;
            return true;
        }
        return false;
    }

    private void connect(Direction direction, ConduitType<?> type) {
        this.bundle.connectTo(this.f_58857_, this.f_58858_, direction, type, false);
        this.updateClient();
    }

    private void connectEnd(Direction direction, ConduitType<?> type) {
        this.bundle.connectTo(this.f_58857_, this.f_58858_, direction, type, true);
        this.updateClient();
    }

    private void disconnect(Direction direction, ConduitType<?> type) {
        if (this.bundle.disconnectFrom(direction, type)) {
            this.updateClient();
        }
    }

    public ConduitBundle getBundle() {
        return this.bundle;
    }

    public ConduitShape getShape() {
        return this.shape;
    }

    public MenuProvider menuProvider(Direction direction, ConduitType<?> type) {
        return new ConduitMenuProvider(direction, type);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        for (ConduitType<?> type : this.bundle.getTypes()) {
            Optional<LazyOptional<T>> proxiedCap;
            ConduitGraphObject<?> node = this.bundle.getNodeFor(type);
            Optional<Object> state = Optional.empty();
            if (node != null && side != null) {
                state = node.getIOState(side);
            }
            if (!(proxiedCap = type.proxyCapability(cap, node == null ? type.createConduitData(this.f_58857_, this.m_58899_()).cast() : node.getConduitData().cast(), this.f_58857_, this.f_58858_, side, state.orElse(null))).isPresent()) continue;
            return proxiedCap.get();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandler getConduitItemHandler() {
        return new ConduitItemHandler();
    }

    public static void pushIOState(Direction direction, ConduitGraphObject<?> node, DynamicConnectionState connectionState) {
        node.pushState(direction, connectionState);
    }

    public static enum UpdateState {
        NONE,
        NEXT_NEXT,
        NEXT,
        INITIALIZED;


        public boolean isInitialized() {
            return this == INITIALIZED;
        }

        public UpdateState next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE, INITIALIZED -> NONE;
                case NEXT_NEXT -> NEXT;
                case NEXT -> INITIALIZED;
            };
        }

        public UpdateState activate() {
            return NEXT_NEXT;
        }
    }

    private class ConduitMenuProvider
    implements MenuProvider {
        private final Direction direction;
        private final ConduitType<?> type;

        private ConduitMenuProvider(Direction direction, ConduitType<?> type) {
            this.direction = direction;
            this.type = type;
        }

        public Component m_5446_() {
            return ConduitBlockEntity.this.m_58900_().m_60734_().m_49954_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
            return new ConduitMenu(ConduitBlockEntity.this, pInventory, pContainerId, this.direction, this.type);
        }
    }

    private class ConduitItemHandler
    implements IItemHandlerModifiable {
        private ConduitItemHandler() {
        }

        public int getSlots() {
            return 162;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= this.getSlots()) {
                return ItemStack.f_41583_;
            }
            SlotData data = SlotData.of(slot);
            if (data.conduitIndex() >= ConduitBlockEntity.this.bundle.getTypes().size()) {
                return ItemStack.f_41583_;
            }
            ConnectionState connectionState = ConduitBlockEntity.this.bundle.getConnectionState(data.direction(), data.conduitIndex());
            if (!(connectionState instanceof DynamicConnectionState)) {
                return ItemStack.f_41583_;
            }
            DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)connectionState;
            ConduitMenuData conduitData = ConduitBlockEntity.this.bundle.getTypes().get(data.conduitIndex()).getMenuData();
            if (data.slotType() == SlotType.FILTER_EXTRACT && conduitData.hasFilterExtract() || data.slotType() == SlotType.FILTER_INSERT && conduitData.hasFilterInsert() || data.slotType() == SlotType.UPGRADE_EXTRACT && conduitData.hasUpgrade()) {
                return dynamicConnectionState.getItem(data.slotType());
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack existing = this.getStackInSlot(slot);
            int limit = Math.min(this.getSlotLimit(slot), stack.m_41741_());
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.m_41613_();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.m_41613_() > limit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                } else {
                    existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                }
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack existing = this.getStackInSlot(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.setStackInSlot(slot, ItemStack.f_41583_);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot >= this.getSlots()) {
                return false;
            }
            SlotData slotData = SlotData.of(slot);
            if (slotData.conduitIndex() >= ConduitBlockEntity.this.bundle.getTypes().size()) {
                return false;
            }
            ConduitType<?> conduitType = ConduitBlockEntity.this.bundle.getTypes().get(slotData.conduitIndex());
            switch (slotData.slotType()) {
                case FILTER_EXTRACT: 
                case FILTER_INSERT: {
                    LazyOptional resourceFilter = stack.getCapability(EIOCapabilities.FILTER);
                    return resourceFilter.map(filter -> conduitType.canApplyFilter(slotData.slotType(), (ResourceFilter)filter)).orElse(false);
                }
                case UPGRADE_EXTRACT: {
                    LazyOptional conduitUpgrade = stack.getCapability(ConduitCapabilities.CONDUIT_UPGRADE);
                    return conduitUpgrade.map(upgrade -> conduitType.canApplyUpgrade(slotData.slotType(), (ConduitUpgrade)upgrade)).orElse(false);
                }
            }
            return false;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot >= this.getSlots()) {
                return;
            }
            SlotData data = SlotData.of(slot);
            if (data.conduitIndex() >= ConduitBlockEntity.this.bundle.getTypes().size()) {
                return;
            }
            ConduitType<?> iConduitType = ConduitBlockEntity.this.bundle.getTypes().get(data.conduitIndex());
            ConduitMenuData conduitData = iConduitType.getMenuData();
            if (data.slotType() == SlotType.FILTER_EXTRACT && conduitData.hasFilterExtract() || data.slotType() == SlotType.FILTER_INSERT && conduitData.hasFilterInsert() || data.slotType() == SlotType.UPGRADE_EXTRACT && conduitData.hasUpgrade()) {
                ConduitBlockEntity.this.bundle.setConnectionItem(data.direction(), data.conduitIndex(), data.slotType(), stack);
                ConnectionState connectionState = ConduitBlockEntity.this.bundle.getConnectionState(data.direction(), iConduitType);
                if (connectionState instanceof DynamicConnectionState) {
                    DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)connectionState;
                    ConduitGraphObject<?> node = ConduitBlockEntity.this.bundle.getNodeForTypeExact(iConduitType);
                    if (node != null) {
                        ConduitBlockEntity.pushIOState(data.direction(), node, dynamicConnectionState);
                    }
                }
            }
        }
    }
}

