/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.turtle.TurtleUpgradeModellers;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.util.Holiday;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class TurtleBlockEntityRenderer
implements BlockEntityRenderer<TurtleBlockEntity> {
    private static final ResourceLocation COLOUR_TURTLE_MODEL = new ResourceLocation("computercraft", "block/turtle_colour");
    private static final ResourceLocation ELF_OVERLAY_MODEL = new ResourceLocation("computercraft", "block/turtle_elf_overlay");
    private final BlockEntityRenderDispatcher renderer;
    private final Font font;

    public TurtleBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.renderer = context.m_173581_();
        this.font = context.m_173586_();
    }

    @Nullable
    public static ResourceLocation getTurtleOverlayModel(@Nullable ResourceLocation overlay, boolean christmas) {
        if (overlay != null) {
            return overlay;
        }
        if (christmas) {
            return ELF_OVERLAY_MODEL;
        }
        return null;
    }

    public void render(TurtleBlockEntity turtle, float partialTicks, PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight) {
        transform.m_85836_();
        Vec3 offset = turtle.getRenderOffset(partialTicks);
        transform.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        String label = turtle.getLabel();
        HitResult hit = this.renderer.f_112250_;
        if (label != null && hit != null && hit.m_6662_() == HitResult.Type.BLOCK && turtle.m_58899_().equals((Object)((BlockHitResult)hit).m_82425_())) {
            Minecraft mc = Minecraft.m_91087_();
            Font font = this.font;
            transform.m_85836_();
            transform.m_85837_(0.5, 1.2, 0.5);
            transform.m_252781_(mc.m_91290_().m_253208_());
            transform.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix = transform.m_85850_().m_252922_();
            int opacity = (int)(mc.f_91066_.m_92141_(0.25f) * 255.0f) << 24;
            float width = (float)(-font.m_92895_(label)) / 2.0f;
            font.m_271703_(label, width, 0.0f, 0x20FFFFFF, false, matrix, buffers, Font.DisplayMode.SEE_THROUGH, opacity, lightmapCoord);
            font.m_271703_(label, width, 0.0f, -1, false, matrix, buffers, Font.DisplayMode.NORMAL, 0, lightmapCoord);
            transform.m_85849_();
        }
        transform.m_252880_(0.5f, 0.5f, 0.5f);
        float yaw = turtle.getRenderYaw(partialTicks);
        transform.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        if (label != null && (label.equals("Dinnerbone") || label.equals("Grumm"))) {
            transform.m_85841_(1.0f, -1.0f, 1.0f);
        }
        transform.m_252880_(-0.5f, -0.5f, -0.5f);
        int colour = turtle.getColour();
        ResourceLocation overlay = turtle.getOverlay();
        if (colour == -1) {
            ItemModelShaper modelManager = Minecraft.m_91087_().m_91291_().m_115103_();
            BakedModel model = modelManager.m_109394_(turtle.m_58900_().m_60734_().m_5456_());
            if (model == null) {
                model = modelManager.m_109393_().m_119409_();
            }
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, model, null);
        } else {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, COLOUR_TURTLE_MODEL, new int[]{colour});
        }
        ResourceLocation overlayModel = TurtleBlockEntityRenderer.getTurtleOverlayModel(overlay, Holiday.getCurrent() == Holiday.CHRISTMAS);
        if (overlayModel != null) {
            this.renderModel(transform, buffers, lightmapCoord, overlayLight, overlayModel, null);
        }
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.LEFT, partialTicks);
        this.renderUpgrade(transform, buffers, lightmapCoord, overlayLight, turtle, TurtleSide.RIGHT, partialTicks);
        transform.m_85849_();
    }

    private void renderUpgrade(PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight, TurtleBlockEntity turtle, TurtleSide side, float f) {
        ITurtleUpgrade upgrade = turtle.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        transform.m_85836_();
        float toolAngle = turtle.getToolRenderAngle(side, f);
        transform.m_252880_(0.0f, 0.5f, 0.5f);
        transform.m_252781_(Axis.f_252495_.m_252977_(toolAngle));
        transform.m_252880_(0.0f, -0.5f, -0.5f);
        TransformedModel model = TurtleUpgradeModellers.getModel(upgrade, turtle.getAccess(), side);
        TurtleBlockEntityRenderer.applyTransformation(transform, model.getMatrix());
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, model.getModel(), null);
        transform.m_85849_();
    }

    private void renderModel(PoseStack transform, MultiBufferSource buffers, int lightmapCoord, int overlayLight, ResourceLocation modelLocation, @Nullable int[] tints) {
        ModelManager modelManager = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_();
        this.renderModel(transform, buffers, lightmapCoord, overlayLight, ClientPlatformHelper.get().getModel(modelManager, modelLocation), tints);
    }

    private void renderModel(PoseStack transform, MultiBufferSource renderer, int lightmapCoord, int overlayLight, BakedModel model, @Nullable int[] tints) {
        ClientPlatformHelper.get().renderBakedModel(transform, renderer, model, lightmapCoord, overlayLight, tints);
    }

    private static void applyTransformation(PoseStack stack, Transformation transformation) {
        Vector3f trans = transformation.m_252829_();
        stack.m_252880_(trans.x(), trans.y(), trans.z());
        stack.m_252781_(transformation.m_253244_());
        Vector3f scale = transformation.m_252900_();
        stack.m_85841_(scale.x(), scale.y(), scale.z());
        stack.m_252781_(transformation.m_252848_());
    }
}

