/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.shared.media.items.PrintoutItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;

public final class PrintoutItemRenderer
extends ItemMapLikeRenderer {
    public static final PrintoutItemRenderer INSTANCE = new PrintoutItemRenderer();

    private PrintoutItemRenderer() {
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        transform.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        transform.m_85841_(0.42f, 0.42f, -0.42f);
        transform.m_252880_(-0.5f, -0.48f, 0.0f);
        PrintoutItemRenderer.drawPrintout(transform, render, stack, light);
    }

    public static void onRenderInFrame(PoseStack transform, MultiBufferSource render, ItemFrame frame, ItemStack stack, int packedLight) {
        if (!(stack.m_41720_() instanceof PrintoutItem)) {
            return;
        }
        transform.m_252880_(0.0f, 0.0f, -0.001f);
        transform.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        transform.m_85841_(0.95f, 0.95f, -0.95f);
        transform.m_252880_(-0.5f, -0.5f, 0.0f);
        int light = frame.m_6095_() == EntityType.f_147033_ ? 15728850 : packedLight;
        PrintoutItemRenderer.drawPrintout(transform, render, stack, light);
    }

    private static void drawPrintout(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        int pages = PrintoutItem.getPageCount(stack);
        boolean book = ((PrintoutItem)stack.m_41720_()).getType() == PrintoutItem.Type.BOOK;
        double width = 176.0;
        double height = 211.0;
        if (!book) {
            width += (double)PrintoutRenderer.offsetAt(pages - 1);
        }
        double visualWidth = width;
        double visualHeight = height;
        if (book) {
            visualWidth += (double)(24.0f + 2.0f * PrintoutRenderer.offsetAt(pages));
            visualHeight += 24.0;
        }
        double max = Math.max(visualHeight, visualWidth);
        float scale = (float)(1.0 / max);
        transform.m_85841_(scale, scale, scale);
        transform.m_85837_((max - width) / 2.0, (max - height) / 2.0, 0.0);
        PrintoutRenderer.drawBorder(transform, render, 0.0f, 0.0f, -0.01f, 0, pages, book, light);
        PrintoutRenderer.drawText(transform, render, 13, 11, 0, light, PrintoutItem.getText(stack), PrintoutItem.getColours(stack));
    }
}

