/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import net.gigabit101.rebornstorage.RebornStorage;
import net.gigabit101.rebornstorage.core.multiblock.MultiblockRegistry;
import net.gigabit101.rebornstorage.nodes.CraftingNode;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="rebornstorage")
public class RebornStorageEventHandler {
    public static boolean debugLogging = false;
    private static Queue<Pair<ICraftingManager, RebuildReason>> rebuildQueue = new LinkedList<Pair<ICraftingManager, RebuildReason>>();

    public static void queue(ICraftingManager craftingManager, CraftingNode node, String reason) {
        if (node.getLevel().f_46443_) {
            return;
        }
        for (ICraftingManager queued : rebuildQueue.stream().map(Pair::getLeft).collect(Collectors.toList())) {
            if (!queued.equals(craftingManager)) continue;
            return;
        }
        rebuildQueue.add((Pair<ICraftingManager, RebuildReason>)Pair.of((Object)craftingManager, (Object)new RebuildReason(node.getPos(), node.getLevel().m_46472_().m_211136_(), reason)));
    }

    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        Pair<ICraftingManager, RebuildReason> rebuildReasonPair;
        if (event.phase == TickEvent.Phase.START) {
            MultiblockRegistry.tickStart(event.level);
        }
        if (event.phase == TickEvent.Phase.END && !event.level.m_5776_() && (rebuildReasonPair = rebuildQueue.poll()) != null) {
            if (debugLogging) {
                RebornStorage.logger.error("Triggering cached crafting manager rebuild pos:" + ((RebuildReason)rebuildReasonPair.getRight()).toString());
            }
            ((ICraftingManager)rebuildReasonPair.getLeft()).invalidate();
        }
    }

    private static class RebuildReason {
        BlockPos pos;
        ResourceLocation worldId;
        String reason;

        public RebuildReason(BlockPos pos, ResourceLocation worldId, String reason) {
            this.pos = pos;
            this.worldId = worldId;
            this.reason = reason;
        }

        public String toString() {
            return "RebuildReason{pos=" + this.pos + ", worldId=" + this.worldId + ", reason='" + this.reason + "'}";
        }
    }
}

