/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.regutil;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tamaized.voidscape.regutil.RegistryClass;

public class RegUtil {
    private static String MODID = "regutil";
    private static final UUID[] ARMOR_MODIFIER_UUID_PER_SLOT = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"), UUID.fromString("86fda400-8542-4d95-b275-c6393de5b887")};
    private static final List<DeferredRegister<?>> REGISTERS = new ArrayList();
    private static final Map<Item, List<RegistryObject<Item>>> BOWS = new HashMap<Item, List<RegistryObject<Item>>>(){
        {
            this.put(Items.f_42411_, new ArrayList());
            this.put(Items.f_42717_, new ArrayList());
        }
    };
    private static final List<RegistryObject<Item>> ARMOR_OVERLAYS = new ArrayList<RegistryObject<Item>>();
    public static boolean renderingArmorOverlay = false;

    public static boolean isMyBow(ItemStack stack, Item check) {
        List<RegistryObject<Item>> list = BOWS.get(check);
        if (list == null) {
            return false;
        }
        for (RegistryObject<Item> o : list) {
            if (!o.isPresent() || !stack.m_150930_((Item)o.get())) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmorOverlay(ItemStack stack) {
        for (RegistryObject<Item> o : ARMOR_OVERLAYS) {
            if (!o.isPresent() || !stack.m_150930_((Item)o.get())) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static void setup(String modid, IEventBus bus, Supplier<RegistryClass> ... inits) {
        MODID = modid;
        RegUtil.create(ForgeRegistries.ITEMS);
        for (Supplier<RegistryClass> init : inits) {
            init.get().init(bus);
        }
        RegUtil.create(ForgeRegistries.RECIPE_SERIALIZERS).register("smithing", () -> new SmithingTransformRecipe.Serializer(){

            public SmithingTransformRecipe m_6729_(ResourceLocation p_266953_, JsonObject p_266720_) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)p_266720_, (String)"template"));
                Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)p_266720_, (String)"base"));
                Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)p_266720_, (String)"addition"));
                ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)p_266720_, (String)"result"));
                class FixedUpgradeRecipe
                extends SmithingTransformRecipe {
                    public FixedUpgradeRecipe(ResourceLocation pId, Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
                        super(pId, pTemplate, pBase, pAddition, pResult);
                    }

                    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
                        ItemStack itemstack = this.m_8043_(pRegistryAccess).m_41777_();
                        CompoundTag compoundtag = pContainer.m_8020_(1).m_41783_();
                        if (compoundtag != null) {
                            itemstack.m_41784_().m_128391_(compoundtag.m_6426_());
                        }
                        return itemstack;
                    }
                }
                return new FixedUpgradeRecipe(p_266953_, ingredient, ingredient1, ingredient2, itemstack);
            }

            public SmithingTransformRecipe m_8005_(ResourceLocation p_267117_, FriendlyByteBuf p_267316_) {
                Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
                Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
                Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)p_267316_);
                ItemStack itemstack = p_267316_.m_130267_();
                return new FixedUpgradeRecipe(p_267117_, ingredient, ingredient1, ingredient2, itemstack);
            }
        });
        for (DeferredRegister deferredRegister : REGISTERS) {
            deferredRegister.register(bus);
        }
    }

    public static <R> DeferredRegister<R> create(IForgeRegistry<R> type) {
        return RegUtil.create(type.getRegistryKey());
    }

    public static <R> DeferredRegister<R> create(ResourceKey<Registry<R>> type) {
        if (type.equals((Object)ForgeRegistries.Keys.ITEMS) && ToolAndArmorHelper.REGISTRY != null) {
            return ToolAndArmorHelper.REGISTRY;
        }
        DeferredRegister def = DeferredRegister.create(type, (String)MODID);
        REGISTERS.add(def);
        if (type.equals((Object)ForgeRegistries.Keys.ITEMS)) {
            ToolAndArmorHelper.REGISTRY = def;
        }
        return def;
    }

    public static Function<Integer, Multimap<Attribute, AttributeModifier>> makeAttributeFactory(AttributeData ... data) {
        return slot -> {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (AttributeData attribute : data) {
                ModAttribute a = attribute.attribute.get();
                builder.put((Object)a, (Object)new AttributeModifier(slot == null ? a.id : ARMOR_MODIFIER_UUID_PER_SLOT[slot], a.type, attribute.value, attribute.op));
            }
            return builder.build();
        };
    }

    public static class ToolAndArmorHelper {
        private static DeferredRegister<Item> REGISTRY;

        public static boolean isBroken(ItemStack stack) {
            return stack.m_41763_() && stack.m_41773_() >= stack.m_41776_() - 1;
        }

        public static RegistryObject<Item> sword(ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_sword"), () -> new SwordItem(tier, 3, -2.4f, properties){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public float m_8102_(ItemStack stack, BlockState state) {
                    return ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
                }

                public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    return !ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(slot));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            });
        }

        public static RegistryObject<Item> shield(final ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_shield"), () -> new ShieldItem(properties.m_41499_(tier.m_6609_())){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    int dmg = Math.min(amount, 6);
                    if (dmg >= remaining) {
                        onBroken.accept(entity);
                        entity.m_5810_();
                    }
                    return Math.min(remaining, dmg);
                }

                public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
                    ItemStack stack = playerIn.m_21120_(handIn);
                    return ToolAndArmorHelper.isBroken(stack) ? InteractionResultHolder.m_19100_((Object)stack) : super.m_7203_(worldIn, playerIn, handIn);
                }

                public int m_6473_() {
                    return tier.m_6601_();
                }

                public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
                    return tier.m_6282_().test(repair);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.getAttributeModifiers(slot, stack));
                        if (slot == EquipmentSlot.OFFHAND) {
                            map.putAll((Multimap)factory.apply(4));
                        }
                    }
                    return map.build();
                }
            });
        }

        private static RegistryObject<Item> registerBow(Item item, RegistryObject<Item> o) {
            if (BOWS.containsKey(item)) {
                BOWS.get(item).add(o);
            }
            return o;
        }

        public static RegistryObject<Item> bow(final ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.registerBow(Items.f_42411_, (RegistryObject<Item>)REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_bow"), () -> new BowItem(properties.m_41499_(tier.m_6609_())){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
                    ItemStack stack = playerIn.m_21120_(handIn);
                    return ToolAndArmorHelper.isBroken(stack) ? InteractionResultHolder.m_19100_((Object)stack) : super.m_7203_(worldIn, playerIn, handIn);
                }

                public int m_6473_() {
                    return tier.m_6601_();
                }

                public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
                    return tier.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.getAttributeModifiers(slot, stack));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            }));
        }

        public static RegistryObject<Item> xbow(final ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.registerBow(Items.f_42717_, (RegistryObject<Item>)REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_xbow"), () -> new CrossbowItem(properties.m_41499_(tier.m_6609_())){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public boolean m_41463_(ItemStack stack) {
                    return stack.m_41720_() instanceof CrossbowItem;
                }

                public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
                    ItemStack itemstack = playerIn.m_21120_(handIn);
                    if (ToolAndArmorHelper.isBroken(itemstack)) {
                        return InteractionResultHolder.m_19100_((Object)itemstack);
                    }
                    if (4.m_40932_((ItemStack)itemstack)) {
                        4.m_40887_((Level)worldIn, (LivingEntity)playerIn, (InteractionHand)handIn, (ItemStack)itemstack, (float)(itemstack.m_41720_() instanceof CrossbowItem && 4.m_40871_((ItemStack)itemstack, (Item)Items.f_42688_) ? 1.6f : 3.15f), (float)1.0f);
                        4.m_40884_((ItemStack)itemstack, (boolean)false);
                        return InteractionResultHolder.m_19096_((Object)itemstack);
                    }
                    return super.m_7203_(worldIn, playerIn, handIn);
                }

                public int m_6473_() {
                    return tier.m_6601_();
                }

                public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
                    return tier.m_6282_().test(repair) || super.m_6832_(toRepair, repair);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.getAttributeModifiers(slot, stack));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            }));
        }

        public static RegistryObject<Item> axe(ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_axe"), () -> new LootingAxe(tier, 5.0f, -3.0f, properties){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public float m_8102_(ItemStack stack, BlockState state) {
                    return ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
                }

                public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        stack.m_41622_(1, attacker, (Consumer)new Consumer<LivingEntity>(){

                            @Override
                            public void accept(LivingEntity entityIn1) {
                                entityIn1.m_21166_(EquipmentSlot.MAINHAND);
                            }
                        });
                        return true;
                    }
                    return false;
                }

                public InteractionResult m_6225_(UseOnContext context) {
                    return ToolAndArmorHelper.isBroken(context.m_43722_()) ? InteractionResult.FAIL : super.m_6225_(context);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(slot));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            });
        }

        public static RegistryObject<Item> pickaxe(ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_pickaxe"), () -> new PickaxeItem(tier, 1, -2.8f, properties){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public float m_8102_(ItemStack stack, BlockState state) {
                    return ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
                }

                public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    return !ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
                }

                public InteractionResult m_6225_(UseOnContext context) {
                    return ToolAndArmorHelper.isBroken(context.m_43722_()) ? InteractionResult.FAIL : super.m_6225_(context);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(slot));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            });
        }

        public static RegistryObject<Item> shovel(ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_shovel"), () -> new ShovelItem(tier, 1.5f, -3.0f, properties){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public float m_8102_(ItemStack stack, BlockState state) {
                    return ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
                }

                public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    return !ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
                }

                public InteractionResult m_6225_(UseOnContext context) {
                    return ToolAndArmorHelper.isBroken(context.m_43722_()) ? InteractionResult.FAIL : super.m_6225_(context);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(slot));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            });
        }

        public static RegistryObject<Item> hoe(ItemTier tier, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final Consumer<TooltipContext> tooltipConsumer) {
            return REGISTRY.register(tier.name().toLowerCase(Locale.US).concat("_hoe"), () -> new HoeItem(tier, -3, 0.0f, properties){

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public float m_8102_(ItemStack stack, BlockState state) {
                    return ToolAndArmorHelper.isBroken(stack) ? 0.0f : super.m_8102_(stack, state);
                }

                public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
                    return !ToolAndArmorHelper.isBroken(stack) && super.m_7579_(stack, target, attacker);
                }

                public InteractionResult m_6225_(UseOnContext context) {
                    return ToolAndArmorHelper.isBroken(context.m_43722_()) ? InteractionResult.FAIL : super.m_6225_(context);
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(slot));
                        if (slot == EquipmentSlot.MAINHAND) {
                            map.putAll((Multimap)factory.apply(null));
                        }
                    }
                    return map.build();
                }
            });
        }

        public static RegistryObject<Item> helmet(ArmorMaterial tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.wrapArmorItemRegistration(tier, tier.register(REGISTRY, "_helmet", ToolAndArmorHelper.armorFactory(tier, ArmorItem.Type.HELMET, properties, factory, tooltipConsumer)));
        }

        public static RegistryObject<Item> chest(ArmorMaterial tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.chest(tier, properties, factory, (stack, tick) -> false, tooltipConsumer);
        }

        public static RegistryObject<Item> chest(ArmorMaterial tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, BiPredicate<ItemStack, Boolean> elytra, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.wrapArmorItemRegistration(tier, tier.register(REGISTRY, "_chest", ToolAndArmorHelper.armorFactory(tier, ArmorItem.Type.CHESTPLATE, properties, factory, elytra, tooltipConsumer)));
        }

        public static RegistryObject<Item> legs(ArmorMaterial tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.wrapArmorItemRegistration(tier, tier.register(REGISTRY, "_legs", ToolAndArmorHelper.armorFactory(tier, ArmorItem.Type.LEGGINGS, properties, factory, tooltipConsumer)));
        }

        public static RegistryObject<Item> boots(ArmorMaterial tier, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.wrapArmorItemRegistration(tier, tier.register(REGISTRY, "_boots", ToolAndArmorHelper.armorFactory(tier, ArmorItem.Type.BOOTS, properties, factory, tooltipConsumer)));
        }

        private static RegistryObject<Item> wrapArmorItemRegistration(ArmorMaterial tier, RegistryObject<Item> object) {
            if (tier.overlay) {
                ARMOR_OVERLAYS.add(object);
            }
            return object;
        }

        private static Supplier<ArmorItem> armorFactory(ArmorMaterial tier, ArmorItem.Type slot, Item.Properties properties, Function<Integer, Multimap<Attribute, AttributeModifier>> factory, Consumer<TooltipContext> tooltipConsumer) {
            return ToolAndArmorHelper.armorFactory(tier, slot, properties, factory, (stack, tick) -> false, tooltipConsumer);
        }

        private static Supplier<ArmorItem> armorFactory(final ArmorMaterial tier, final ArmorItem.Type slot, Item.Properties properties, final Function<Integer, Multimap<Attribute, AttributeModifier>> factory, final BiPredicate<ItemStack, Boolean> elytra, final Consumer<TooltipContext> tooltipConsumer) {
            return () -> new ArmorItem(tier, slot, properties){

                public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
                    boolean flag;
                    boolean bl = flag = !ToolAndArmorHelper.isBroken(stack) && (elytra.test(stack, true) || super.elytraFlightTick(stack, entity, flightTicks));
                    if (flag && !entity.m_9236_().f_46443_ && (flightTicks + 1) % 20 == 0) {
                        stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
                    }
                    return flag;
                }

                public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
                    return !ToolAndArmorHelper.isBroken(stack) && (elytra.test(stack, false) || super.canElytraFly(stack, entity));
                }

                @OnlyIn(value=Dist.CLIENT)
                public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.broken")).m_130940_(ChatFormatting.DARK_RED));
                    }
                    if (elytra.test(stack, false)) {
                        tooltip.add((Component)Component.m_237115_((String)(MODID + ".tooltip.elytra")).m_130940_(ChatFormatting.DARK_AQUA));
                    }
                    tooltipConsumer.accept(new TooltipContext(stack, worldIn, tooltip, flagIn));
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                }

                public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
                    int remaining = stack.m_41776_() - 1 - stack.m_41773_();
                    if (amount >= remaining) {
                        onBroken.accept(entity);
                    }
                    return Math.min(remaining, amount);
                }

                public void onArmorTick(ItemStack stack, Level world, Player player) {
                    if (ToolAndArmorHelper.isBroken(stack)) {
                        if (!player.m_36356_(stack)) {
                            Containers.m_18992_((Level)world, (double)player.m_20182_().m_7096_(), (double)player.m_20182_().m_7098_(), (double)player.m_20182_().m_7094_(), (ItemStack)stack);
                        } else {
                            stack.m_41774_(1);
                        }
                    }
                }

                public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
                    ImmutableMultimap.Builder map = ImmutableMultimap.builder();
                    if (!ToolAndArmorHelper.isBroken(stack)) {
                        map.putAll(super.m_7167_(equipmentSlot));
                        if (equipmentSlot == slot.m_266308_()) {
                            map.putAll((Multimap)factory.apply(equipmentSlot.m_20749_()));
                        }
                    }
                    return map.build();
                }

                @OnlyIn(value=Dist.CLIENT)
                public Object getRenderPropertiesInternal() {
                    return new IClientItemExtensions(){

                        @NotNull
                        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                            HumanoidModel<LivingEntity> tierModel = tier.getArmorModel(entityLiving, itemStack, armorSlot, _default);
                            return tierModel != null ? tierModel : (tier.fullbright || tier.overlay ? new HumanoidModel<LivingEntity>(Minecraft.m_91087_().m_167973_().m_171103_(slot == ArmorItem.Type.LEGGINGS ? ModelLayers.f_171164_ : ModelLayers.f_171165_)){

                                public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
                                    super.m_7695_(matrixStackIn, bufferIn, tier.fullbright || tier.overlayFullbright && renderingArmorOverlay ? 0xF000F0 : packedLightIn, packedOverlayIn, red, green, blue, alpha);
                                }
                            } : super.getHumanoidArmorModel(entityLiving, itemStack, armorSlot, _default));
                        }
                    };
                }

                @Nullable
                @OnlyIn(value=Dist.CLIENT)
                public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot2, String type) {
                    String tierTexture = tier.getArmorTexture(stack, entity, slot2, type);
                    return tierTexture != null ? tierTexture : super.getArmorTexture(stack, entity, slot2, type);
                }
            };
        }

        public static abstract class LootingAxe
        extends AxeItem {
            private static final Set<ToolAction> ACTIONS = Stream.of(ToolActions.AXE_DIG, ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.SWORD_SWEEP).collect(Collectors.toCollection(Sets::newIdentityHashSet));

            public LootingAxe(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
                super(tier, attackDamageIn, attackSpeedIn, builder);
            }

            public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
                return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)stack) > 0 ? ACTIONS.contains(toolAction) : super.canPerformAction(stack, toolAction);
            }
        }

        public record TooltipContext(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        }
    }

    public record AttributeData(Supplier<ModAttribute> attribute, AttributeModifier.Operation op, double value) {
        public static AttributeData make(Supplier<ModAttribute> attribute, AttributeModifier.Operation op, double value) {
            return new AttributeData(attribute, op, value);
        }
    }

    public static class ModAttribute
    extends Attribute {
        final UUID id;
        final String type;

        public ModAttribute(String name, float defaultValue, UUID id, String type) {
            super(name, (double)defaultValue);
            this.id = id;
            this.type = type;
        }
    }

    public static class ArmorMaterial
    implements net.minecraft.world.item.ArmorMaterial {
        private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        private final ResourceLocation name;
        private final int maxDamageFactor;
        private final int[] damageReductionAmountArray;
        private final int enchantability;
        private final SoundEvent soundEvent;
        private final float toughness;
        private final float knockbackResistance;
        private final LazyLoadedValue<Ingredient> repairMaterial;
        private final boolean fullbright;
        private final boolean overlay;
        private final boolean overlayFullbright;

        public ArmorMaterial(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial, boolean fullbright, boolean overlay, boolean overlayFullbright) {
            this.name = new ResourceLocation(MODID, name);
            this.maxDamageFactor = maxDamageFactor;
            this.damageReductionAmountArray = damageReductionAmountArray;
            this.enchantability = enchantability;
            this.soundEvent = soundEvent;
            this.toughness = toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairMaterial = new LazyLoadedValue(repairMaterial);
            this.fullbright = fullbright;
            this.overlay = overlay;
            this.overlayFullbright = overlayFullbright;
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, A _default) {
            return null;
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return null;
        }

        public int m_266425_(ArmorItem.Type pType) {
            return MAX_DAMAGE_ARRAY[pType.m_266308_().m_20749_()] * this.maxDamageFactor;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return this.damageReductionAmountArray[pType.m_266308_().m_20749_()];
        }

        public int m_6646_() {
            return this.enchantability;
        }

        public SoundEvent m_7344_() {
            return this.soundEvent;
        }

        public Ingredient m_6230_() {
            return (Ingredient)this.repairMaterial.m_13971_();
        }

        public String m_6082_() {
            return this.name.toString();
        }

        public RegistryObject<Item> register(DeferredRegister<Item> REGISTRY, String append, Supplier<ArmorItem> obj) {
            return REGISTRY.register(this.name.m_135815_().toLowerCase(Locale.US).concat(append), obj);
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }
    }

    public static class ItemTier
    implements Tier {
        private final String name;
        private final int harvestLevel;
        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int enchantability;
        private final LazyLoadedValue<Ingredient> repairMaterial;

        public ItemTier(String name, int harvestLevelIn, int maxUsesIn, float efficiencyIn, float attackDamageIn, int enchantabilityIn, Supplier<Ingredient> repairMaterialIn) {
            this.name = name;
            this.harvestLevel = harvestLevelIn;
            this.maxUses = maxUsesIn;
            this.efficiency = efficiencyIn;
            this.attackDamage = attackDamageIn;
            this.enchantability = enchantabilityIn;
            this.repairMaterial = new LazyLoadedValue(repairMaterialIn);
        }

        public String name() {
            return this.name;
        }

        public int m_6609_() {
            return this.maxUses;
        }

        public float m_6624_() {
            return this.efficiency;
        }

        public float m_6631_() {
            return this.attackDamage;
        }

        public int m_6604_() {
            return this.harvestLevel;
        }

        public int m_6601_() {
            return this.enchantability;
        }

        public Ingredient m_6282_() {
            return (Ingredient)this.repairMaterial.m_13971_();
        }
    }

    public record ItemProps(Supplier<Item.Properties> properties) {
    }
}

