/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.registry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.client.ClientUtil;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.regutil.RegistryClass;

public class ModEffects
implements RegistryClass {
    private static final DeferredRegister<MobEffect> REGISTRY = RegUtil.create(ForgeRegistries.MOB_EFFECTS);
    public static final RegistryObject<MobEffect> ICHOR = REGISTRY.register("ichor", () -> new StandardEffect(MobEffectCategory.HARMFUL, 0xFF7700, true).texture("effect/ichor.png"));
    public static final RegistryObject<MobEffect> AURA = REGISTRY.register("aura", () -> new StandardEffect(MobEffectCategory.BENEFICIAL, 0x7700FF, false).texture("effect/aura.png"));
    public static final RegistryObject<MobEffect> FORTIFIED = REGISTRY.register("fortified", () -> new StandardEffect(MobEffectCategory.BENEFICIAL, 65450, false).texture("effect/fortified.png"));

    @Override
    public void init(IEventBus bus) {
    }

    public static class StandardEffect
    extends MobEffect {
        private Supplier<Supplier<ResourceLocation>> texture = () -> ClientUtil::getMissingTexture;
        private final boolean allowCure;

        private StandardEffect(MobEffectCategory type, int color, boolean allowCure) {
            super(type, color);
            this.allowCure = allowCure;
        }

        public List<ItemStack> getCurativeItems() {
            return this.allowCure ? super.getCurativeItems() : new ArrayList();
        }

        <T extends StandardEffect> T texture(String loc) {
            return this.texture(new ResourceLocation("voidscape", "textures/" + loc));
        }

        <T extends StandardEffect> T texture(ResourceLocation loc) {
            this.texture = () -> () -> loc;
            return (T)((Object)this);
        }

        public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
            consumer.accept(new IClientMobEffectExtensions(){

                public boolean renderInventoryIcon(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int z) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.get().get());
                    float y1 = y + 7;
                    float x2 = x + 18;
                    float y2 = y1 + 18.0f;
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    buffer.m_5483_((double)x, (double)y2, (double)z).m_7421_(0.0f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x2, (double)y2, (double)z).m_7421_(1.0f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x2, (double)y1, (double)z).m_7421_(1.0f, 0.0f).m_5752_();
                    buffer.m_5483_((double)x, (double)y1, (double)z).m_7421_(0.0f, 0.0f).m_5752_();
                    Tesselator.m_85913_().m_85914_();
                    return true;
                }

                public boolean renderGuiIcon(MobEffectInstance instance, Gui gui, GuiGraphics guiGraphics, int x, int y, float z, float alpha) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.get().get());
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                    float x1 = x + 3;
                    float y1 = y + 3;
                    float x2 = x1 + 18.0f;
                    float y2 = y1 + 18.0f;
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                    buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                    buffer.m_5483_((double)x1, (double)y2, (double)z).m_7421_(0.0f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x2, (double)y2, (double)z).m_7421_(1.0f, 1.0f).m_5752_();
                    buffer.m_5483_((double)x2, (double)y1, (double)z).m_7421_(1.0f, 0.0f).m_5752_();
                    buffer.m_5483_((double)x1, (double)y1, (double)z).m_7421_(0.0f, 0.0f).m_5752_();
                    Tesselator.m_85913_().m_85914_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    return true;
                }
            });
        }
    }
}

