/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.network.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.network.NetworkMessages;

public class ClientPacketSendParticles
implements NetworkMessages.IMessage<ClientPacketSendParticles> {
    private final List<QueuedParticle> queuedParticles = new ArrayList<QueuedParticle>();

    public void queueParticle(ParticleOptions particleOptions, boolean b, double x, double y, double z, double x2, double y2, double z2) {
        this.queuedParticles.add(new QueuedParticle(particleOptions, b, x, y, z, x2, y2, z2));
    }

    public void queueParticle(ParticleOptions particleOptions, boolean b, Vec3 xyz, Vec3 xyz2) {
        this.queuedParticles.add(new QueuedParticle(particleOptions, b, xyz.f_82479_, xyz.f_82480_, xyz.f_82481_, xyz2.f_82479_, xyz2.f_82480_, xyz2.f_82481_));
    }

    @Override
    public void handle(@Nullable Player player) {
        Level level;
        if (player == null || !((level = player.m_9236_()) instanceof ClientLevel)) {
            return;
        }
        ClientLevel level2 = (ClientLevel)level;
        this.queuedParticles.forEach(queuedParticle -> level2.m_6493_(queuedParticle.particleOptions, queuedParticle.b, queuedParticle.x, queuedParticle.y, queuedParticle.z, queuedParticle.x2, queuedParticle.y2, queuedParticle.z2));
    }

    @Override
    public void toBytes(FriendlyByteBuf packet) {
        packet.writeInt(this.queuedParticles.size());
        for (QueuedParticle queuedParticle : this.queuedParticles) {
            packet.m_236858_((ResourceKey)ForgeRegistries.PARTICLE_TYPES.getResourceKey((Object)queuedParticle.particleOptions.m_6012_()).orElseThrow());
            queuedParticle.particleOptions.m_7711_(packet);
            packet.writeBoolean(queuedParticle.b);
            packet.writeDouble(queuedParticle.x);
            packet.writeDouble(queuedParticle.y);
            packet.writeDouble(queuedParticle.z);
            packet.writeDouble(queuedParticle.x2);
            packet.writeDouble(queuedParticle.y2);
            packet.writeDouble(queuedParticle.z2);
        }
    }

    @Override
    public ClientPacketSendParticles fromBytes(FriendlyByteBuf packet) {
        Optional type;
        int size = packet.readInt();
        for (int i = 0; i < size && !(type = ForgeRegistries.PARTICLE_TYPES.getHolder(packet.m_236801_(ForgeRegistries.PARTICLE_TYPES.getRegistryKey()))).isEmpty(); ++i) {
            this.queuedParticles.add(new QueuedParticle((ParticleOptions)this.readParticle((ParticleType)((Holder)type.get()).get(), packet), packet.readBoolean(), packet.readDouble(), packet.readDouble(), packet.readDouble(), packet.readDouble(), packet.readDouble(), packet.readDouble()));
        }
        return this;
    }

    private <T extends ParticleOptions> T readParticle(ParticleType<T> particleType, FriendlyByteBuf buf) {
        return (T)particleType.m_123743_().m_6507_(particleType, buf);
    }

    private record QueuedParticle(ParticleOptions particleOptions, boolean b, double x, double y, double z, double x2, double y2, double z2) {
    }
}

