/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.entity;

import java.util.ArrayList;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.entity.IEthereal;
import tamaized.voidscape.entity.NullServantEntity;
import tamaized.voidscape.entity.StrangePearlEntity;
import tamaized.voidscape.network.client.ClientPacketSendParticles;
import tamaized.voidscape.registry.ModDamageSource;
import tamaized.voidscape.registry.ModEntities;

public class NullServantAugmentBlockEntity
extends LivingEntity
implements IEntityAdditionalSpawnData,
IEthereal {
    private static final EntityDataAccessor<BlockState> MIMIC = SynchedEntityData.m_135353_(NullServantAugmentBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private NullServantEntity parent;

    public NullServantAugmentBlockEntity(EntityType<NullServantAugmentBlockEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
    }

    public NullServantAugmentBlockEntity(NullServantEntity parent) {
        this((EntityType<NullServantAugmentBlockEntity>)((EntityType)ModEntities.NULL_SERVANT_AUGMENT_BLOCK.get()), parent.m_9236_());
        this.parent = parent;
        this.initAugment();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 10.0);
    }

    private void initAugment() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.parent.getAugment() == 1) {
            this.f_19804_.m_135381_(MIMIC, (Object)(this.f_19796_.m_188499_() ? Blocks.f_50440_.m_49966_() : Blocks.f_50069_.m_49966_()));
        } else if (this.parent.getAugment() == 2) {
            this.f_19804_.m_135381_(MIMIC, (Object)(this.f_19796_.m_188499_() ? Blocks.f_50699_.m_49966_() : Blocks.f_50134_.m_49966_()));
        } else if (this.parent.getAugment() == 3) {
            this.f_19804_.m_135381_(MIMIC, (Object)Blocks.f_50259_.m_49966_());
        }
    }

    @Nullable
    public static Vec3 randomPos(Level level, RandomSource random, Vec3 from, Entity clipSource) {
        for (int i = 0; i < 10; ++i) {
            Vec3 vec = new Vec3(5.0, 0.125, 0.0).m_82524_((float)Math.PI / 180 * (random.m_188501_() * 360.0f)).m_82549_(from);
            BlockHitResult result = level.m_45547_(new ClipContext(vec, from, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, clipSource));
            if (result.m_6662_() == HitResult.Type.BLOCK) continue;
            return vec;
        }
        return null;
    }

    public void randomPosOrDiscard() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 pos = NullServantAugmentBlockEntity.randomPos(this.m_9236_(), this.m_217043_(), this.parent.m_20182_(), (Entity)this);
        if (pos != null) {
            this.m_20219_(pos);
            this.m_5496_(SoundEvents.f_12019_, 1.0f, 0.2f + this.f_19796_.m_188501_() * 0.3f);
            ClientPacketSendParticles particles = new ClientPacketSendParticles();
            for (int j = 0; j < 50; ++j) {
                particles.queueParticle((ParticleOptions)ParticleTypes.f_123810_, false, this.m_20182_().m_7096_() - 0.5 + (double)this.f_19796_.m_188501_(), this.m_20182_().m_7098_() - 0.5 + (double)this.f_19796_.m_188501_(), this.m_20182_().m_7094_() - 0.5 + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
            }
            Voidscape.NETWORK.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)particles);
        } else {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MIMIC, (Object)Blocks.f_50752_.m_49966_());
    }

    public BlockState getMimic() {
        return (BlockState)this.f_19804_.m_135370_(MIMIC);
    }

    public void m_7378_(CompoundTag tag) {
        ServerLevel serverLevel;
        Level level;
        if (tag.m_128403_("parent") && (level = this.m_9236_()) instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).m_8791_(tag.m_128342_("parent"))) instanceof NullServantEntity) {
            NullServantEntity p;
            this.parent = p = (NullServantEntity)level;
        }
        this.f_19804_.m_135381_(MIMIC, (Object)NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("mimic")));
        super.m_7378_(tag);
    }

    public void m_7380_(CompoundTag tag) {
        if (this.parent != null) {
            tag.m_128362_("parent", this.parent.m_20148_());
        }
        tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.getMimic()));
        super.m_7380_(tag);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.parent == null ? -1 : this.parent.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        Entity entity = this.m_9236_().m_6815_(additionalData.readInt());
        if (entity instanceof NullServantEntity) {
            NullServantEntity p;
            this.parent = p = (NullServantEntity)entity;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.parent == null) {
            this.m_146870_();
            return true;
        }
        if (pSource.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (this.parent.getAugment() == 1) {
            return super.m_6469_(pSource, pSource.m_276093_(ModDamageSource.VOIDIC) ? pAmount : pAmount * 0.1f);
        }
        if (this.parent.getAugment() == 2) {
            return super.m_6469_(pSource, pSource.m_7639_() == this.parent ? pAmount : pAmount * 0.01f);
        }
        if (this.parent.getAugment() == 3) {
            return super.m_6469_(pSource, pSource.m_7639_() != this.parent && pSource.m_7640_() instanceof StrangePearlEntity ? pAmount : pAmount * 0.01f);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6087_() {
        return true;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public void m_147240_(double pStrength, double pX, double pZ) {
    }

    protected boolean m_6107_() {
        return false;
    }

    public void m_7334_(Entity pEntity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    protected void m_6138_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_20916_ > 0) {
            --this.f_20916_;
        }
        if (!(this.m_9236_().m_5776_() || this.parent != null && this.parent.m_6084_() && this.parent.getAugmentAttack().booleanValue())) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_() && this.parent != null && this.parent.m_6084_() && this.f_19796_.m_188503_(5) == 0) {
            Vec3 dir = new Vec3(this.parent.m_20185_(), this.parent.m_20186_() + (double)(this.parent.m_20192_() / 2.0f), this.parent.m_20189_()).m_82546_(this.m_20182_()).m_82541_().m_82490_(0.5);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123810_, false, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), dir.m_7096_(), dir.m_7098_(), dir.m_7094_());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

