/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.container.TurbineControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class TurbineControllerEntity
extends AbstractTurbineEntity
implements MenuProvider,
INetworkTileEntitySyncProvider {
    public static String COMMAND_ENGAGE_COILS = "coilon";
    public static String COMMAND_DISENGAGE_COILS = "coiloff";
    public static String COMMAND_SET_INTAKERATE = "rate";
    public static String COMMAND_SET_VENT = "vent";
    public static String COMMAND_SCRAM = "scram";

    public TurbineControllerEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.TURBINE_CONTROLLER.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, tce -> tce.setTurbineActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, tce -> tce.setTurbineActive(false)).addServerHandler(COMMAND_ENGAGE_COILS, tce -> tce.executeOnController(tc -> tc.setInductorEngaged(true))).addServerHandler(COMMAND_DISENGAGE_COILS, tce -> tce.executeOnController(tc -> tc.setInductorEngaged(false))).addServerHandler(COMMAND_SET_INTAKERATE, TurbineControllerEntity::setIntakeRate).addServerHandler(COMMAND_SET_VENT, TurbineControllerEntity::setVent).addServerHandler(COMMAND_SCRAM, TurbineControllerEntity::scram).build((AbstractModBlockEntity)this));
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isTurbineActive() ? 1 : 2) : 0);
    }

    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.listenForControllerDataUpdates();
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getMultiblockController().ifPresent(reactor -> reactor.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this.getMultiblockController().ifPresent(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayer player) {
        this.getMultiblockController().ifPresent(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        return new TurbineControllerContainer(windowId, inventory, this);
    }

    public Component m_5446_() {
        return super.getPartDisplayName();
    }

    private void setIntakeRate(CompoundTag data) {
        this.executeOnController(turbine -> turbine.setMaxIntakeRate(data.m_128451_("rate")));
    }

    private void setVent(CompoundTag data) {
        VentSetting setting = (VentSetting)NBTHelper.nbtGetEnum((CompoundTag)data, (String)"vent", VentSetting::valueOf, (Enum)VentSetting.getDefault());
        this.executeOnController(turbine -> turbine.setVentSetting(setting));
    }

    private void scram() {
        this.setTurbineActive(false);
    }
}

