/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.container;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorControllerEntity;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ContainerFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.BooleanData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.DoubleData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.ItemStackData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.WideAmountData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class ReprocessorControllerContainer
extends ModTileContainer<ReprocessorControllerEntity> {
    public final BooleanData ACTIVE;
    public final FluidStackData FLUID_INPUT_STACK;
    public final ItemStackData ITEM_INPUT_STACK;
    public final ItemStackData ITEM_OUTPUT_STACK;
    public final WideAmountData ENERGY_STORED;
    public final DoubleData RECIPE_PROGRESS;

    public ReprocessorControllerContainer(int windowId, Inventory playerInventory, ReprocessorControllerEntity controller) {
        super(5, ContainerFactory.EMPTY, (MenuType)Content.ContainerTypes.REPROCESSOR_CONTROLLER.get(), windowId, playerInventory, (AbstractModBlockEntity)controller);
        MultiblockReprocessor reprocessor = (MultiblockReprocessor)((Object)controller.getMultiblockController().orElseThrow(IllegalStateException::new));
        boolean isClientSide = reprocessor.getWorld().m_5776_();
        this.ACTIVE = BooleanData.of((ModContainer)this, (boolean)isClientSide, () -> reprocessor::isMachineActive);
        this.FLUID_INPUT_STACK = FluidStackData.sampled((int)2, (ModContainer)this, (boolean)isClientSide, () -> () -> reprocessor.getFluidHandler().getFluidInTank(0));
        this.ITEM_INPUT_STACK = ItemStackData.sampled((int)2, (ModContainer)this, (boolean)isClientSide, () -> () -> reprocessor.getItemHandler(IoDirection.Input).getStackInSlot(0));
        this.ITEM_OUTPUT_STACK = ItemStackData.sampled((int)2, (ModContainer)this, (boolean)isClientSide, () -> () -> reprocessor.getItemHandler(IoDirection.Output).getStackInSlot(0));
        this.ENERGY_STORED = WideAmountData.sampled((int)3, (ModContainer)this, (boolean)isClientSide, () -> () -> WideAmount.from((double)reprocessor.getEnergyStorage().getEnergyStored(EnergySystem.ForgeEnergy)));
        this.RECIPE_PROGRESS = DoubleData.of((ModContainer)this, (boolean)isClientSide, () -> reprocessor::getRecipeProgress);
    }

    public ReprocessorControllerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf networkData) {
        this(windowId, playerInventory, (ReprocessorControllerEntity)AbstractModBlockEntity.getGuiClientBlockEntity((FriendlyByteBuf)networkData));
    }

    public int getOutputCapacity() {
        return 5000;
    }

    public WideAmount getEnergyCapacity() {
        return WideAmount.asImmutable((long)5000L);
    }
}

