/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.GuiTheme;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.container.ReprocessorControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorControllerEntity;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.base.client.screen.control.EnergyBar;
import it.zerono.mods.zerocore.base.client.screen.control.FluidBar;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.base.client.screen.control.OnOff;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.ToolTipsBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.control.ItemStackDisplay;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.control.SwitchButton;
import it.zerono.mods.zerocore.lib.client.gui.layout.AnchoredLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.common.util.NonNullSupplier;

public class ReprocessorControllerScreen
extends CommonMultiblockScreen<MultiblockReprocessor, ReprocessorControllerEntity, ReprocessorControllerContainer> {
    private final ItemStackDisplay _inputStack;
    private final ItemStackDisplay _outputStack;
    private final EnergyBar _energyBar;
    private final FluidBar _fluidBar;
    private final GaugeBar _progressBar;
    private final OnOff _onOff;
    private final Button _voidFluid;

    public ReprocessorControllerScreen(ReprocessorControllerContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, (NonNullSupplier<SpriteTextureMap>)((NonNullSupplier)() -> new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix("basic_background.png"), 256, 256)));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REPROCESSOR.buildWithSuffix("part-controller"), 1);
        this.addRecipesButton(() -> this.displayReprocessorRecipes(), "gui.bigreactors.show_recipes.tooltip.title");
        this._inputStack = new ItemStackDisplay((ModContainerScreen)this, "input");
        this._inputStack.bindStack(container.ITEM_INPUT_STACK);
        this._outputStack = new ItemStackDisplay((ModContainerScreen)this, "output");
        this._outputStack.bindStack(container.ITEM_OUTPUT_STACK);
        this._energyBar = new EnergyBar((ModContainerScreen)this, "energyBar", EnergySystem.ForgeEnergy, container.getEnergyCapacity(), container.ENERGY_STORED, null);
        this._fluidBar = new FluidBar((ModContainerScreen)this, "fluidBar", container.getOutputCapacity(), container.FLUID_INPUT_STACK, (NonNullSupplier)BaseIcons.Bucket, "gui.bigreactors.reprocessor.controller.coolantbar.title", null);
        this._progressBar = new GaugeBar((ModContainerScreen)this, "progress", 1.0, (IBindableData)container.RECIPE_PROGRESS, Sprite.EMPTY);
        this._progressBar.setDesiredDimension(16, 32);
        this._progressBar.setBarSprite(new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix("reprocessor_controller_arrow_filled.png"), 16, 32).sprite().ofSize(16, 32).build());
        this._progressBar.setOverlay(new SpriteTextureMap(CommonLocations.TEXTURES_GUI_MULTIBLOCK.buildWithSuffix("reprocessor_controller_arrow.png"), 16, 32).sprite().ofSize(16, 32).build());
        this._progressBar.setOrientation(Orientation.TopToBottom);
        this._onOff = new OnOff((ModContainerScreen)this, (IBindableData)((ReprocessorControllerContainer)this.m_6262_()).ACTIVE, this::onActiveStateChanged, (Component)Component.m_237115_((String)"gui.bigreactors.reprocessor.controller.on.title"), (Component)Component.m_237115_((String)"gui.bigreactors.reprocessor.controller.off.title"));
        this._voidFluid = new Button((ModContainerScreen)this, "voidfluid", "");
        this._voidFluid.Clicked.subscribe(this::onVoidFluid);
        this._voidFluid.setIconForState(CommonIcons.TrashCan.get(), ButtonState.Default);
        this._voidFluid.enablePaintBlending(true);
        this._voidFluid.setPadding(1);
        this._voidFluid.setDesiredDimension(18, 18);
        this._voidFluid.setTooltips((ToolTipsBuilder)new BaseScreenToolTipsBuilder().addTranslatableAsTitle("gui.bigreactors.reprocessor.controller.voidfluid.title").addEmptyLine().addTranslatable("gui.bigreactors.reprocessor.controller.voidfluid.body"));
        this.setTheme(GuiTheme.ER.get());
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(ReprocessorControllerContainer container) {
        return this.createReprocessorStatusIndicator(container.ACTIVE);
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.setContentLayoutEngine((ILayoutEngine)((HorizontalLayoutEngine)((HorizontalLayoutEngine)new HorizontalLayoutEngine().setZeroMargins()).setVerticalAlignment(VerticalAlignment.Top)).setHorizontalAlignment(HorizontalAlignment.Center));
        this.addControl((IControl)this._energyBar);
        this.addControl((IControl)CommonPanels.verticalSeparator((ModContainerScreen)this));
        this.addControl((IControl)this._fluidBar);
        this.addControl((IControl)CommonPanels.verticalSeparator((ModContainerScreen)this));
        Panel recipePanel = new Panel((ModContainerScreen)this);
        recipePanel.setLayoutEngine((ILayoutEngine)new VerticalLayoutEngine());
        recipePanel.setDesiredDimension(64, 84);
        recipePanel.addControl((IControl)this._inputStack);
        recipePanel.addControl((IControl)this._progressBar);
        recipePanel.addControl((IControl)this._outputStack);
        this.addControl((IControl)recipePanel);
        this.addControl((IControl)CommonPanels.verticalSeparator((ModContainerScreen)this));
        Panel commandPanel = CommonPanels.verticalCommandPanel((ModContainerScreen)this, (int)this._onOff.getDesiredDimension(DesiredDimension.Width));
        commandPanel.setLayoutEngine((ILayoutEngine)new AnchoredLayoutEngine().setZeroMargins());
        this._onOff.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Top);
        commandPanel.addControl((IControl)this._onOff);
        this._voidFluid.setLayoutEngineHint((ILayoutEngine.ILayoutEngineHint)AnchoredLayoutEngine.Anchor.Center);
        commandPanel.addControl((IControl)this._voidFluid);
        this.addControl((IControl)commandPanel);
    }

    private void onActiveStateChanged(SwitchButton button) {
        if (!this.isDataUpdateInProgress()) {
            this.sendCommandToServer(button.getActive() ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
        }
    }

    private void onVoidFluid(Button button, Integer mouseButton) {
        this.sendCommandToServer(CommonConstants.COMMAND_VOID_FLUID);
    }
}

