/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.IEnergizerPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.MultiBlockEnergizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.energizer.variant.IMultiblockEnergizerVariant;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockMachineEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public class AbstractEnergizerEntity
extends AbstractMultiblockMachineEntity<MultiBlockEnergizer, IMultiblockEnergizerVariant>
implements IMultiblockPartTypeProvider<MultiBlockEnergizer, IEnergizerPartType> {
    private static final CuboidPartVariantsModelDataCache s_modelDataCache = new CuboidPartVariantsModelDataCache();

    public AbstractEnergizerEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected boolean isEnergizerActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiBlockEnergizer::isMachineActive).orElse(false);
    }

    protected void setEnergizerActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public Component getPartDisplayName() {
        return Component.m_237115_((String)this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"));
    }

    protected ModelData getUpdatedModelData() {
        return CodeHelper.optionalMap((Optional)this.getMultiblockVariant(), (Optional)this.getPartType(), this::getUpdatedModelData).orElse(ModelData.EMPTY);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        BlockPos coordinates = this.getWorldPosition();
        if (position.isFrame()) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.energizer.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.energizer.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiBlockEnergizer createController() {
        Level myWorld = this.m_58904_();
        if (null == myWorld) {
            throw new RuntimeException("Trying to create a Controller from a Part without a Level");
        }
        return new MultiBlockEnergizer(myWorld);
    }

    public Class<MultiBlockEnergizer> getControllerType() {
        return MultiBlockEnergizer.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected ModelData getUpdatedModelData(IMultiblockEnergizerVariant variant, IMultiblockPartType partType) {
        return s_modelDataCache.computeIfAbsent((int)partType.getByteHashCode(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings());
    }
}

