/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.AddRemoveSection;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.reactor.Moderator;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.tag.TagList;
import it.zerono.mods.zerocore.lib.tag.TagSource;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="bigreactors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ModeratorsRegistry {
    private static final TagList<Block> s_moderatorBlocksTags;
    private static final Map<TagKey<Block>, Moderator> s_moderatorBlocksData;
    private static final Map<ResourceLocation, Moderator> s_moderatorFluidsData;
    private static final Marker MARKER;
    private static final Marker WRAPPER;
    private static final Component TOOLTIP_MODERATOR;

    public static Optional<Moderator> getFrom(BlockState state) {
        if (state.m_60795_()) {
            return Optional.of(Moderator.AIR);
        }
        FluidState fs = state.m_60819_();
        if (!fs.m_76178_() && s_moderatorFluidsData.containsKey(FluidHelper.getFluidId((Fluid)fs.m_76152_()))) {
            return Optional.of(s_moderatorFluidsData.get(FluidHelper.getFluidId((Fluid)fs.m_76152_())));
        }
        List tags = TagsHelper.BLOCKS.getTags((Object)state.m_60734_());
        return s_moderatorBlocksTags.findFirst(tags::contains).map(s_moderatorBlocksData::get);
    }

    public static boolean isValid(BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        FluidState fs = state.m_60819_();
        if (!fs.m_76178_() && s_moderatorFluidsData.containsKey(FluidHelper.getFluidId((Fluid)fs.m_76152_()))) {
            return true;
        }
        return s_moderatorBlocksTags.match(arg_0 -> ((Holder.Reference)state.m_60734_().m_204297_()).m_203656_(arg_0));
    }

    public static void registerSolid(String tagId, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        ModeratorsRegistry.registerSolid((TagKey<Block>)TagsHelper.BLOCKS.createKey(tagId), absorption, heatEfficiency, moderation, heatConductivity);
    }

    public static void registerSolid(TagKey<Block> tag, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Preconditions.checkNotNull(tag);
        InternalDispatcher.dispatch("moderator-s-register", () -> {
            if (s_moderatorBlocksData.containsKey(tag)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing radiation moderator for {}", (Object)tag);
            }
            Moderator m = new Moderator(absorption, heatEfficiency, moderation, heatConductivity);
            s_moderatorBlocksData.merge(tag, m, (o, n) -> m);
            s_moderatorBlocksTags.addTag(tag);
        });
    }

    public static void registerFluid(String fluidId, float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fluidId) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("moderator-f-register", () -> {
            ResourceLocation id = new ResourceLocation(fluidId);
            if (s_moderatorFluidsData.containsKey(id)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overriding existing radiation moderator for {}", (Object)id);
            }
            Moderator m = new Moderator(absorption, heatEfficiency, moderation, heatConductivity);
            s_moderatorFluidsData.merge(id, m, (o, n) -> m);
        });
    }

    public static void removeSolid(TagKey<Block> tag) {
        Preconditions.checkNotNull(tag);
        InternalDispatcher.dispatch("moderator-s-remove", () -> {
            s_moderatorBlocksData.remove(tag);
            s_moderatorBlocksTags.removeTag(tag);
        });
    }

    public static void removeSolid(String tagId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagId) ? 1 : 0) != 0);
        ModeratorsRegistry.removeSolid((TagKey<Block>)TagsHelper.BLOCKS.createKey(tagId));
    }

    public static void removeFluid(String fluidId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fluidId) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("moderator-f-remove", () -> s_moderatorFluidsData.remove(new ResourceLocation(fluidId)));
    }

    public static void fillModeratorsTooltips(Map<Item, Set<Component>> tooltipsMap, NonNullSupplier<Set<Component>> setSupplier) {
        s_moderatorBlocksTags.stream().map(arg_0 -> ((TagSource)TagsHelper.BLOCKS).getObjects(arg_0)).flatMap(Collection::stream).map(Block::m_5456_).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_MODERATOR));
        s_moderatorFluidsData.keySet().stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getValue(arg_0)).filter(Objects::nonNull).map(Fluid::m_6859_).forEach(item -> tooltipsMap.computeIfAbsent((Item)item, k -> (Set)setSupplier.get()).add(TOOLTIP_MODERATOR));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        ModeratorsRegistry.processWrapper("solid", wrapper.ReactorSolidModerators, s_moderatorBlocksData::clear, ModeratorsRegistry::removeSolid, w -> ModeratorsRegistry.registerSolid(w.TagId, w.Absorption, w.HeatEfficiency, w.Moderation, w.HeatConductivity));
        ModeratorsRegistry.processWrapper("fluid", wrapper.ReactorFluidModerators, s_moderatorFluidsData::clear, ModeratorsRegistry::removeFluid, w -> ModeratorsRegistry.registerFluid(w.TagId, w.Absorption, w.HeatEfficiency, w.Moderation, w.HeatConductivity));
    }

    public static Optional<Moderator> getFromName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        ResourceLocation id = new ResourceLocation(name);
        if (s_moderatorFluidsData.containsKey(id)) {
            return Optional.of(s_moderatorFluidsData.get(id));
        }
        return Optional.ofNullable(s_moderatorBlocksData.get(TagsHelper.BLOCKS.createKey(id)));
    }

    public static List<String> getModeratorsNames() {
        LinkedList<String> list = new LinkedList<String>();
        s_moderatorFluidsData.keySet().stream().map(ResourceLocation::toString).forEach(list::add);
        s_moderatorBlocksTags.stream().map(TagKey::f_203868_).map(ResourceLocation::toString).forEach(list::add);
        list.sort(String::compareTo);
        return list;
    }

    private ModeratorsRegistry() {
    }

    private static void processWrapper(String objectName, AddRemoveSection<it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Moderator> wrapperSection, Runnable clearAction, Consumer<String> removeAction, Consumer<it.zerono.mods.extremereactors.api.internal.modpack.wrapper.Moderator> addAction) {
        if (wrapperSection.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing {} Reactor Moderators", (Object)objectName);
            clearAction.run();
        } else {
            wrapperSection.removals().filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(removeAction);
        }
        wrapperSection.additions().filter(Objects::nonNull).forEach(addAction);
    }

    static {
        MARKER = MarkerManager.getMarker((String)"API/ModeratorsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
        WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});
        TOOLTIP_MODERATOR = Component.m_237115_((String)"api.bigreactors.reactor.tooltip.moderator").m_6270_(ExtremeReactorsAPI.STYLE_TOOLTIP);
        s_moderatorBlocksTags = TagList.blocks();
        s_moderatorBlocksData = new Object2ObjectArrayMap(32);
        s_moderatorFluidsData = new Object2ObjectArrayMap(32);
    }
}

