/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.core.api;

import com.magorage.tiab.api.HandledState;
import com.magorage.tiab.api.TiabAPIHooks;
import com.magorage.tiab.api.events.ITimeBottleTickEvent;
import com.magorage.tiab.api.events.ITimeBottleUseEvent;
import com.magorage.tiab.api.events.ITimeCommandEvent;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class APIHooks {
    private static final APIHooks API = new APIHooks();
    private final ArrayList<ITimeCommandEvent> COMMAND_HOOKS = new ArrayList();
    private final ArrayList<ITimeBottleUseEvent> USE_HOOKS = new ArrayList();
    private final ArrayList<ITimeBottleTickEvent> TICK_HOOKS = new ArrayList();
    private boolean frozen = false;

    protected static APIHooks getHooks() {
        return API;
    }

    public static void freezeAll() {
        API.freeze();
    }

    protected void addEventCallbacks(TiabAPIHooks hooks) {
        if (hooks.getCommandEvent() != null) {
            this.COMMAND_HOOKS.add(hooks.getCommandEvent());
        }
        if (hooks.getUseEvent() != null) {
            this.USE_HOOKS.add(hooks.getUseEvent());
        }
        if (hooks.getTickEvent() != null) {
            this.TICK_HOOKS.add(hooks.getTickEvent());
        }
    }

    protected boolean fireCommandEvent(ServerPlayer player, int time, boolean isAdd) {
        HandledState handledState = new HandledState();
        boolean success = false;
        for (ITimeCommandEvent hook : this.COMMAND_HOOKS) {
            if (!hook.accept(player, time, isAdd, handledState)) continue;
            success = true;
        }
        return success;
    }

    protected boolean fireUseEvent(ItemStack bottle, Player player, Level level, BlockPos pos) {
        HandledState handledState = new HandledState();
        boolean success = false;
        for (ITimeBottleUseEvent hook : this.USE_HOOKS) {
            if (!hook.accept(bottle, player, level, pos, handledState)) continue;
            success = true;
        }
        return success;
    }

    protected boolean fireTickEvent(ServerPlayer player, ItemStack stack) {
        HandledState handledState = new HandledState();
        boolean success = false;
        for (ITimeBottleTickEvent hook : this.TICK_HOOKS) {
            if (!hook.accept(player, stack, handledState)) continue;
            success = true;
        }
        return success;
    }

    private void freeze() {
        this.frozen = true;
    }
}

