/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.utils;

import dev.kostromdan.mods.crash_assistant.app.utils.JarEntriesScanner;
import dev.kostromdan.mods.crash_assistant.common_config.loading_utils.JarInJarHelper;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModuleFinder {
    public static List<String> findJarsContainingEntries(List<String> packagePrefixes, Path jarPath) {
        return ModuleFinder.findJarsContainingEntries(packagePrefixes, jarPath, SearchMode.PACKAGE);
    }

    public static List<String> findJarsContainingEntries(List<String> searchTerms, Path jarPath, SearchMode mode) {
        List searchPrefixes = searchTerms.stream().map(ModuleFinder::normalizeModuleName).collect(Collectors.toList());
        ArrayList<String> results = new ArrayList<String>();
        JarEntriesScanner.scanJar(jarPath, true, (containerName, entries) -> {
            boolean matched = false;
            for (Map.Entry e : entries.entrySet()) {
                String name = (String)e.getKey();
                boolean isDir = (Boolean)e.getValue();
                if (!matched) {
                    for (String prefix : searchPrefixes) {
                        if (!ModuleFinder.matches(name, isDir, prefix, mode)) continue;
                        results.add((String)containerName);
                        matched = true;
                        break;
                    }
                }
                if (!name.equals("module-info.class")) continue;
                JarInJarHelper.LOGGER.warn("Found module-info.class in " + containerName);
            }
        });
        return results;
    }

    public static List<String> findJarsInFolderAsync(List<String> packagePrefixes, LinkedHashSet<Mod> mods) {
        return ModuleFinder.findJarsInFolderAsync(packagePrefixes, mods, SearchMode.PACKAGE);
    }

    public static List<String> findJarsInFolderAsync(List<String> packagePrefixes, LinkedHashSet<Mod> mods, SearchMode mode) {
        Path modsFolderPath = Paths.get("mods", new String[0]);
        ExecutorService executor = Executors.newWorkStealingPool();
        HashMap jarMap = new HashMap();
        try (Stream<Path> stream = Files.walk(modsFolderPath, new FileVisitOption[0]);){
            stream.filter(path -> path.toString().endsWith(".jar")).forEach(jarPath -> jarMap.put(jarPath.getFileName().toString(), jarPath));
        }
        catch (IOException e) {
            executor.shutdown();
            return new ArrayList<String>();
        }
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        for (Mod mod : mods) {
            CompletableFuture task = CompletableFuture.supplyAsync(() -> {
                Path jarPath = (Path)jarMap.get(mod.getJarName());
                if (jarPath != null) {
                    return ModuleFinder.findJarsContainingEntries(packagePrefixes, jarPath, mode);
                }
                return new ArrayList();
            }, executor);
            tasks.add(task);
        }
        ArrayList<String> allResults = new ArrayList<String>();
        for (CompletableFuture task : tasks) {
            try {
                allResults.addAll((Collection)task.get());
            }
            catch (Exception exception) {}
        }
        executor.shutdown();
        return allResults;
    }

    private static boolean matches(JarEntry entry, String searchTerm, SearchMode mode) {
        return ModuleFinder.matches(entry.getName(), entry.isDirectory(), searchTerm, mode);
    }

    private static boolean matches(String entryName, boolean isDirectory, String searchTerm, SearchMode mode) {
        String normalizedEntryName = ModuleFinder.normalizeModuleName(entryName);
        boolean isClass = entryName.endsWith(".class");
        boolean isPackage = isDirectory;
        if (!isClass && !isPackage) {
            return false;
        }
        if (isPackage) {
            return normalizedEntryName.equals(searchTerm);
        }
        if (mode == SearchMode.PACKAGE) {
            return false;
        }
        String withoutExt = entryName.substring(0, entryName.length() - 6);
        String normalizedWithout = normalizedEntryName.substring(0, normalizedEntryName.length() - 6);
        if (normalizedWithout.equals(searchTerm)) {
            return true;
        }
        String className = withoutExt.substring(withoutExt.lastIndexOf(47) + 1).toLowerCase();
        if ((className + "/").equals(searchTerm)) {
            return true;
        }
        AtomicBoolean found = new AtomicBoolean(false);
        Arrays.stream(className.split("\\$")).map(s -> s + "/").forEach(name -> {
            if (name.equals(searchTerm)) {
                found.set(true);
            }
        });
        return found.get();
    }

    public static String normalizeModuleName(String moduleName) {
        if (!((String)(moduleName = ((String)moduleName).toLowerCase().replace('.', '/'))).endsWith("/")) {
            moduleName = (String)moduleName + "/";
        }
        return moduleName;
    }

    public static enum SearchMode {
        PACKAGE,
        CLASS_OR_PACKAGE;

    }
}

