/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis.dependencies;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.app.utils.JarEntriesScanner;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LinksProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import dev.kostromdan.mods.crash_assistant.common_config.platform.PlatformHelp;
import dev.kostromdan.mods.crash_assistant.common_config.utils.JavaBinaryLocator;
import dev.kostromdan.mods.crash_assistant.common_config.utils.maven_version_cmp.ComparableVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class DependenciesAnalysisGUIBase
extends AnalysisGUIBase {
    private JCheckBox includeNestedCheckbox;
    private volatile boolean isRestarting = false;

    protected abstract void recreateSelf();

    public DependenciesAnalysisGUIBase(JFrame parent, String title, String headerText) {
        super(parent, title, headerText);
        this.initOptions();
    }

    private void initOptions() {
        boolean current;
        JPanel optionsPanel = new JPanel(new FlowLayout(0));
        boolean defaultValue = true;
        Object saved = CrashAssistantLocalConfig.get((String)"analysis.jdeps.include_nested");
        boolean bl = current = saved instanceof Boolean ? (Boolean)saved : defaultValue;
        if (!(saved instanceof Boolean)) {
            CrashAssistantLocalConfig.set((String)"analysis.jdeps.include_nested", (Object)defaultValue);
        }
        this.includeNestedCheckbox = new JCheckBox(LanguageProvider.get((String)"gui.analysis.jdeps.include_nested"), current);
        this.includeNestedCheckbox.addActionListener(e -> this.onIncludeNestedChanged());
        optionsPanel.add(this.includeNestedCheckbox);
        this.addToHeaderCenter(optionsPanel);
    }

    private void onIncludeNestedChanged() {
        if (this.isRestarting) {
            return;
        }
        boolean newValue = this.includeNestedCheckbox.isSelected();
        int res = JOptionPane.showConfirmDialog(this.dialog, LanguageProvider.get((String)"gui.analysis.jdeps.restart_prompt"), LanguageProvider.get((String)"gui.analysis.jdeps.restart_title"), 0, 3);
        if (res == 0) {
            CrashAssistantLocalConfig.set((String)"analysis.jdeps.include_nested", (Object)newValue);
            this.fullyRestartGui();
        } else {
            this.isRestarting = true;
            this.includeNestedCheckbox.setSelected(!newValue);
            this.isRestarting = false;
        }
    }

    protected boolean isIncludeNestedEnabled() {
        Object saved = CrashAssistantLocalConfig.get((String)"analysis.jdeps.include_nested");
        return !(saved instanceof Boolean) || (Boolean)saved != false;
    }

    protected abstract Predicate<String> isRelevantClass();

    protected abstract String getModId();

    protected abstract String getModName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyRestartGui() {
        try {
            isCancelled = true;
            if (executor != null) {
                executor.shutdownNow();
            }
            List list = runningProcesses;
            synchronized (list) {
                for (Process p : runningProcesses) {
                    try {
                        p.destroy();
                    }
                    catch (Exception exception) {}
                }
                runningProcesses.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.dialog != null) {
                    this.dialog.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.recreateSelf();
        });
    }

    @Override
    protected void performAnalysis() {
        List targetMods = ModListUtils.getCurrentModList((boolean)true).stream().filter(mod -> Objects.equals(mod.getModId(), this.getModId())).collect(Collectors.toList());
        if (targetMods.isEmpty()) {
            SwingUtilities.invokeLater(() -> {
                String msg = LanguageProvider.get((String)"gui.analysis.dependencies.no_mod").replace("$MOD$", this.getModName());
                this.appendStyledText(msg, NORMAL_COLOR);
            });
            return;
        }
        if (targetMods.size() > 1) {
            String list = targetMods.stream().map(Mod::getJarName).collect(Collectors.joining(", "));
            String message = LanguageProvider.get((String)"gui.analysis.dependencies.multiple_mods").replace("$MOD$", this.getModName()).replace("$LIST$", list);
            SwingUtilities.invokeLater(() -> this.appendStyledText(message, ERROR_COLOR));
            return;
        }
        String jdepsPath = this.getJDepsPath();
        if (jdepsPath == null) {
            SwingUtilities.invokeLater(() -> {
                this.showJdepsWarn((JFrame)this.dialog.getParent(), this.dialog);
                this.dialog.dispose();
            });
            return;
        }
        CrashAssistantApp.LOGGER.info("Using jdeps at: \"{}\"", (Object)jdepsPath);
        if (this.isIncludeNestedEnabled()) {
            try {
                this.cleanJdepsTmp();
            }
            catch (Exception message) {
                // empty catch block
            }
        }
        Mod targetMod = (Mod)targetMods.get(0);
        HashSet<String> currentTargetClasses = this.getCurrentTargetClasses(targetMod);
        List modsToAnalyze = ModListUtils.getCurrentModList((boolean)true).stream().filter(mod -> !Objects.equals(mod.getModId(), this.getModId())).collect(Collectors.toList());
        int totalMods = modsToAnalyze.size();
        if (totalMods == 0) {
            SwingUtilities.invokeLater(() -> this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.no_other_mods"), NORMAL_COLOR));
            return;
        }
        ConcurrentHashMap missingClassesMap = new ConcurrentHashMap();
        ConcurrentHashMap modDisplayMap = new ConcurrentHashMap();
        AtomicInteger completedTasks = new AtomicInteger(0);
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(totalMods));
        for (Mod mod2 : modsToAnalyze) {
            executor.submit(() -> {
                if (isCancelled) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + mod2.getJarName()));
                JdepsScanResult scan = this.scanModWithJdeps(mod2, jdepsPath, this.isRelevantClass(), false);
                Set invalidDeps = scan.deps.stream().filter(dep -> !currentTargetClasses.contains(dep)).collect(Collectors.toSet());
                Map<String, Set<String>> depsByDisplay = scan.depsByDisplay;
                if (!invalidDeps.isEmpty()) {
                    missingClassesMap.put(mod2, invalidDeps);
                    this.registerDetectedModJar(mod2.getJarName());
                    String displayForMod = mod2.getJarName();
                    block0: for (Map.Entry<String, Set<String>> e : depsByDisplay.entrySet()) {
                        for (String c : e.getValue()) {
                            if (currentTargetClasses.contains(c)) continue;
                            displayForMod = e.getKey();
                            break block0;
                        }
                    }
                    String jarDisplay = displayForMod;
                    int depCount = invalidDeps.size();
                    String targetJarName = targetMod.getJarName();
                    modDisplayMap.put(mod2, jarDisplay);
                    SwingUtilities.invokeLater(() -> {
                        if (!isCancelled) {
                            this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.found") + " ", NORMAL_COLOR);
                            this.appendStyledText(String.valueOf(depCount), ERROR_COLOR);
                            this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.dependencies_in").replace("$MOD$", this.getModName()), NORMAL_COLOR);
                            this.appendStyledText(jarDisplay, ERROR_COLOR);
                            this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.missing_from_current"), NORMAL_COLOR);
                            this.appendStyledText(targetJarName, MOD_COLOR);
                            this.appendStyledText("\n", NORMAL_COLOR);
                            String logMessage = String.format("Found %d " + this.getModName() + " mod class dependency(ies) in %s, which are missing from the current %s", depCount, jarDisplay, targetJarName);
                            CrashAssistantApp.LOGGER.info(logMessage);
                        }
                    });
                }
                int completed = completedTasks.incrementAndGet();
                SwingUtilities.invokeLater(() -> {
                    if (!isCancelled) {
                        this.progressBar.setValue(completed);
                    }
                });
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled) {
            SwingUtilities.invokeLater(() -> {
                if (missingClassesMap.isEmpty()) {
                    String targetJarName = targetMod.getJarName();
                    this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.none_missing_start").replace("$MOD$", this.getModName()), NORMAL_COLOR);
                    this.appendStyledText(targetJarName, MOD_COLOR);
                    this.appendStyledText("\n", NORMAL_COLOR);
                    String logMessage = String.format("Haven't found in any mod, " + this.getModName() + " mod class dependency(ies), which are missing from the current %s", targetJarName);
                    CrashAssistantApp.LOGGER.info(logMessage);
                } else {
                    this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.walkthrough").replace("$MOD$", this.getModName()), NORMAL_COLOR);
                    ArrayList sortedMods = new ArrayList(missingClassesMap.keySet());
                    sortedMods.sort(Comparator.comparing(Mod::getJarName));
                    for (Mod mod : sortedMods) {
                        Set missingClasses = (Set)missingClassesMap.get(mod);
                        ArrayList sortedClasses = new ArrayList(missingClasses);
                        Collections.sort(sortedClasses);
                        String displayName = modDisplayMap.get(mod) != null ? (String)modDisplayMap.get(mod) : mod.getJarName();
                        this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.mod_label"), NORMAL_COLOR);
                        this.appendStyledText(displayName, ERROR_COLOR);
                        this.appendStyledText("\n", NORMAL_COLOR);
                        this.appendStyledText(LanguageProvider.get((String)"gui.analysis.dependencies.missing_classes").replace("$MOD$", this.getModName()), NORMAL_COLOR);
                        this.appendStyledText(String.join((CharSequence)"\n", sortedClasses) + "\n\n", NORMAL_COLOR);
                        String logMessage = String.format("Mod: %s\nMissing classes of " + this.getModName() + ":\n%s\n\n", displayName, String.join((CharSequence)"\n", sortedClasses));
                        CrashAssistantApp.LOGGER.info(logMessage.trim());
                    }
                }
            });
        }
        if (this.isIncludeNestedEnabled()) {
            try {
                this.cleanJdepsTmp();
            }
            catch (Exception e) {
                CrashAssistantApp.LOGGER.warn("Failed to clean jdeps tmp directory after analysis: {}", (Object)e.getMessage());
            }
        }
    }

    private HashSet<String> getCurrentTargetClasses(Mod targetMod) {
        HashSet<String> currentTargetClasses = new HashSet<String>();
        try {
            Path jarPath = Paths.get("mods", targetMod.getJarName());
            JarEntriesScanner.scanJar(jarPath, true, (containerName, entries) -> {
                for (Map.Entry e : entries.entrySet()) {
                    String name = (String)e.getKey();
                    if (!this.isRelevantClass().test(name)) continue;
                    currentTargetClasses.add(this.fixClassName(name));
                }
            });
            CrashAssistantApp.LOGGER.info("Found " + currentTargetClasses.size() + " " + this.getModName() + " classes in " + targetMod.getJarName());
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error while analysing " + this.getModName() + " mod deps: ", (Throwable)e);
        }
        return currentTargetClasses;
    }

    private String fixClassName(String className) {
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    protected String getJDepsPath() {
        String jdepsPathFromLocalConfig;
        String valueFromConfig;
        BufferedReader reader;
        Process process;
        ProcessBuilder processBuilder;
        String jdepsPath;
        String javaBinaryPath = JavaBinaryLocator.getJavaBinary();
        if (javaBinaryPath.contains("javaw")) {
            javaBinaryPath = javaBinaryPath.replace("javaw", "java");
        }
        if (this.validateJdepsPath(jdepsPath = this.transformJavaBinaryPathToJdepsPath(javaBinaryPath))) {
            return jdepsPath;
        }
        String javaHome = System.getenv("JAVA_HOME");
        String javaHomeToJdepsPath = this.transformJavaHomeToJdepsPath(javaHome);
        if (this.validateJdepsPath(javaHomeToJdepsPath)) {
            return javaHomeToJdepsPath;
        }
        try {
            processBuilder = PlatformHelp.isWindows() ? new ProcessBuilder("cmd.exe", "/c", "echo %JAVA_HOME%") : new ProcessBuilder("/bin/sh", "-c", "echo $JAVA_HOME");
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String echoOutput = reader.readLine();
            String echoJdepsPath = this.transformJavaHomeToJdepsPath(echoOutput);
            if (this.validateJdepsPath(echoJdepsPath)) {
                return echoJdepsPath;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Error while trying to get JAVA_HOME from echo: {}", (Object)e.getMessage());
        }
        try {
            processBuilder = PlatformHelp.isWindows() ? new ProcessBuilder("cmd.exe", "/c", "where java") : new ProcessBuilder("/bin/sh", "-c", "which java");
            process = processBuilder.start();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String javaPath = reader.readLine();
            String cmdJdepsPath = this.transformJavaBinaryPathToJdepsPath(javaPath);
            if (this.validateJdepsPath(cmdJdepsPath)) {
                return cmdJdepsPath;
            }
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.warn("Error while trying to get Java from command location: {}", (Object)e.getMessage());
        }
        if (this.validateJdepsPath("jdeps")) {
            return "jdeps";
        }
        if (PlatformHelp.isWindows()) {
            List<String> javaDirectories = Arrays.asList("C:\\Program Files\\Java", "C:\\Program Files\\Eclipse Adoptium", System.getProperty("user.home") + "\\.jdks");
            ArrayList<File> javaFolders = new ArrayList<File>();
            for (String directory : javaDirectories) {
                File[] folders;
                File dir = new File(directory);
                if (!dir.exists() || !dir.isDirectory() || (folders = dir.listFiles(File::isDirectory)) == null) continue;
                javaFolders.addAll(Arrays.asList(folders));
            }
            javaFolders.sort((f1, f2) -> {
                try {
                    String name1 = this.removeVendorPrefix(f1.getName());
                    String name2 = this.removeVendorPrefix(f2.getName());
                    return new ComparableVersion(name2).compareTo(new ComparableVersion(name1));
                }
                catch (Exception e) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            for (File folder : javaFolders) {
                String folderJdepsPath = this.transformJavaHomeToJdepsPath(folder.getAbsolutePath());
                if (!this.validateJdepsPath(folderJdepsPath)) continue;
                return folderJdepsPath;
            }
        }
        if ((valueFromConfig = (String)CrashAssistantLocalConfig.get((String)"JDK_PATH")) != null && !valueFromConfig.isEmpty() && this.validateJdepsPath(jdepsPathFromLocalConfig = this.transformJavaHomeToJdepsPath(valueFromConfig))) {
            return jdepsPathFromLocalConfig;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean validateJdepsPath(String jdepsPath) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(jdepsPath, "-version");
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String versionOutput = reader.readLine();
                if (versionOutput != null && !PlatformHelp.isJdkVersionSufficient((String)versionOutput)) {
                    CrashAssistantApp.LOGGER.warn("Found jdeps at \"{}\" but its version ({}) is lower than current major version ({})", (Object)jdepsPath, (Object)versionOutput.trim(), (Object)PlatformHelp.getCurrentJdkMajorVersion());
                    boolean bl = false;
                    return bl;
                }
            }
            process.waitFor();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected String transformJavaHomeToJdepsPath(String javaHome) {
        if (javaHome != null && !javaHome.isEmpty()) {
            String osName = System.getProperty("os.name").toLowerCase();
            if (javaHome.endsWith(File.separator)) {
                javaHome = javaHome.substring(0, javaHome.length() - 1);
            }
            if (javaHome.endsWith("bin")) {
                return javaHome + File.separator + (osName.contains("win") ? "jdeps.exe" : "jdeps");
            }
            return javaHome + File.separator + "bin" + File.separator + (osName.contains("win") ? "jdeps.exe" : "jdeps");
        }
        return null;
    }

    protected String transformJavaBinaryPathToJdepsPath(String javaBinaryPath) {
        return javaBinaryPath.replaceAll("(?<=[/\\\\])java(\\.exe)?$", "jdeps$1");
    }

    protected String removeVendorPrefix(String folderName) {
        return folderName.replaceAll("^[a-zA-Z]+-", "");
    }

    protected void showJdepsWarn(JFrame parent, JDialog dialog) {
        new JdkWarningDialog(parent, dialog).setVisible(true);
    }

    protected void cleanJdepsTmp() throws Exception {
        Path dir = Paths.get("local", "crash_assistant", "jdeps_tmp");
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JdepsScanResult scanModWithJdeps(Mod mod, String jdepsPath, Predicate<String> predicate, boolean stopAfterFirst) {
        JdepsScanResult result = new JdepsScanResult();
        Process process = null;
        try {
            Path mainJarPath = Paths.get("mods", mod.getJarName()).toAbsolutePath();
            List<TargetInfo> targets = this.buildTargetInfosFromMod(mainJarPath, mod);
            Iterator<TargetInfo> iterator = targets.iterator();
            while (iterator.hasNext()) {
                TargetInfo target = iterator.next();
                if (isCancelled) {
                    return result;
                }
                ProcessBuilder pb = new ProcessBuilder(jdepsPath, "-verbose:class", target.path.toString());
                pb.redirectErrorStream(true);
                process = pb.start();
                runningProcesses.add(process);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null && !isCancelled) {
                        int spaceIndex;
                        String classPath;
                        String dependency;
                        int arrowIndex = (line = line.trim()).indexOf("->");
                        if (arrowIndex == -1 || (dependency = line.substring(arrowIndex + 2).trim()).endsWith(".class") || !predicate.test(classPath = dependency.substring(0, (spaceIndex = dependency.indexOf(32)) == -1 ? dependency.length() : spaceIndex).replace('.', '/') + ".class")) continue;
                        if (stopAfterFirst) {
                            result.matched = true;
                            result.matchedDisplay = target.display;
                            return result;
                        }
                        String fixed = this.fixClassName(classPath);
                        result.deps.add(fixed);
                        result.depsByDisplay.computeIfAbsent(target.display, k -> new HashSet()).add(fixed);
                    }
                }
                process.waitFor();
                runningProcesses.remove(process);
            }
            return result;
        }
        catch (InterruptedException ignored) {
            CrashAssistantApp.LOGGER.warn("Analysis of " + mod.getJarName() + " was interrupted.");
            return result;
        }
        catch (Exception e) {
            CrashAssistantApp.LOGGER.error("Error while analysing jdeps for " + mod.getJarName() + ": ", (Throwable)e);
            return result;
        }
        finally {
            if (process != null) {
                runningProcesses.remove(process);
            }
        }
    }

    protected List<TargetInfo> buildTargetInfosFromMod(Path mainJarPath, Mod mod) {
        ArrayList<TargetInfo> targets = new ArrayList<TargetInfo>();
        if (this.isIncludeNestedEnabled()) {
            try {
                Path baseOut = Paths.get("local", "crash_assistant", "jdeps_tmp", mainJarPath.getFileName().toString());
                Files.createDirectories(baseOut, new FileAttribute[0]);
                this.extractRecursivelyDetailed(mainJarPath, mod, baseOut, mod.getJarName(), targets);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        targets.add(new TargetInfo(mainJarPath.toAbsolutePath(), mod.getJarName()));
        return targets;
    }

    private void extractRecursivelyDetailed(Path currentJarPath, Mod currentMod, Path baseOut, String displayPrefix, List<TargetInfo> out) {
        List children = currentMod.getJarJarMods();
        if (children == null || children.isEmpty()) {
            return;
        }
        try (JarFile jarFile = new JarFile(currentJarPath.toFile());){
            for (Mod child : children) {
                String internal;
                JarEntry entry;
                String p = child.getPathFromJarJar();
                if (p == null) {
                    p = "";
                }
                if (p.startsWith("/")) {
                    p = p.substring(1);
                }
                if ((entry = jarFile.getJarEntry(internal = p + child.getJarName())) == null || entry.isDirectory()) continue;
                Path outPath = baseOut.resolve(internal.replace('/', File.separatorChar));
                try {
                    Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                    InputStream in = jarFile.getInputStream(entry);
                    try {
                        Files.copy(in, outPath, StandardCopyOption.REPLACE_EXISTING);
                        Path childJar = outPath.toAbsolutePath();
                        String display = displayPrefix + "!/" + internal;
                        out.add(new TargetInfo(childJar, display));
                        this.extractRecursivelyDetailed(childJar, child, outPath.getParent(), display, out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class JdkWarningDialog
    extends JDialog {
        public JdkWarningDialog(JFrame parent, JDialog parentDialog) {
            super(parent, LanguageProvider.get((String)"gui.analysis.dependencies.jdk_required_title"), true);
            this.setLayout(new BorderLayout());
            String message = LanguageProvider.get((String)"gui.analysis.dependencies.jdk_required_message").replace("$ADOPTIUM_JDK_LINK$", LinksProvider.ADOPTIUM_JDK.getLink());
            JEditorPane textPane = CrashAssistantGUI.getEditorPane(message, true, 550);
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)scrollPane, "Center");
            JPanel buttonPanel = new JPanel(new FlowLayout(1));
            JButton installButton = new JButton(LanguageProvider.get((String)"gui.analysis.dependencies.install_jdk_via_winget_button"));
            installButton.addActionListener(e -> {
                try {
                    int option = JOptionPane.showConfirmDialog(this, LanguageProvider.get((String)"gui.analysis.dependencies.install_jdk_confirm_message"), LanguageProvider.get((String)"gui.analysis.dependencies.install_jdk_title"), 2, 1);
                    if (option != 0) {
                        return;
                    }
                    new ProcessBuilder("cmd.exe", "/c", "start", "cmd.exe", "/k", "winget", "install", "--id=Oracle.JDK.21", "-e").start();
                    this.dispose();
                    if (parentDialog != null) {
                        parentDialog.dispose();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.analysis.dependencies.install_jdk_error").replace("$ERROR$", ex.getMessage()), LanguageProvider.get((String)"gui.analysis.dependencies.installation_error_title"), 0);
                }
            });
            buttonPanel.add(installButton);
            JButton selectButton = new JButton(LanguageProvider.get((String)"gui.analysis.dependencies.select_jdk_button"));
            selectButton.addActionListener(e -> {
                JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.analysis.dependencies.specify_jdk_path"), LanguageProvider.get((String)"gui.analysis.dependencies.select_jdk_title"), 1);
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(1);
                fileChooser.setDialogTitle(LanguageProvider.get((String)"gui.analysis.dependencies.select_jdk_directory"));
                fileChooser.setCurrentDirectory(new File("C:\\"));
                fileChooser.setPreferredSize(new Dimension(600, 400));
                if (fileChooser.showOpenDialog(this) == 0) {
                    File selectedFolder = fileChooser.getSelectedFile();
                    String jdkPath = selectedFolder.getAbsolutePath();
                    CrashAssistantLocalConfig.set((String)"JDK_PATH", (Object)jdkPath);
                    JOptionPane.showMessageDialog(this, LanguageProvider.get((String)"gui.analysis.dependencies.success"), LanguageProvider.get((String)"gui.analysis.dependencies.jdk_path_saved_title"), 1);
                    this.dispose();
                    if (parentDialog != null) {
                        parentDialog.dispose();
                    }
                }
            });
            buttonPanel.add(selectButton);
            JButton closeButton = new JButton(LanguageProvider.get((String)"gui.close"));
            closeButton.addActionListener(e -> {
                this.dispose();
                if (parentDialog != null) {
                    parentDialog.dispose();
                }
            });
            buttonPanel.add(closeButton);
            this.add((Component)buttonPanel, "South");
            this.setSize(600, 400);
            this.setLocationRelativeTo(parent);
        }
    }

    protected static class JdepsScanResult {
        public boolean matched = false;
        public String matchedDisplay = null;
        public final HashSet<String> deps = new HashSet();
        public final Map<String, Set<String>> depsByDisplay = new HashMap<String, Set<String>>();

        protected JdepsScanResult() {
        }
    }

    protected static class TargetInfo {
        public final Path path;
        public final String display;

        public TargetInfo(Path path, String display) {
            this.path = path;
            this.display = display;
        }
    }
}

