/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.analysis.AnalysisGUIBase;
import dev.kostromdan.mods.crash_assistant.app.utils.ModuleFinder;
import dev.kostromdan.mods.crash_assistant.common_config.config.CrashAssistantLocalConfig;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.Mod;
import dev.kostromdan.mods.crash_assistant.common_config.mod_list.ModListUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class PackageFinderGUI
extends AnalysisGUIBase {
    private final String searchTerm;
    private final String originalSearchTerm;

    public PackageFinderGUI(JFrame parent, String search) {
        super(parent, LanguageProvider.get((String)"gui.menu.analysis.package_class_finder"), LanguageProvider.get((String)"gui.analysis.package_finder.header"));
        String term = this.originalSearchTerm = search.trim();
        if (term.toLowerCase().endsWith(".class")) {
            term = term.substring(0, term.length() - 6);
        }
        this.searchTerm = term.replace('.', '/');
    }

    public static void showPackageFinderDialog(JFrame parent) {
        String lastSearch = (String)CrashAssistantLocalConfig.get((String)"analysis.package_finder_last_search");
        String input = (String)JOptionPane.showInputDialog(parent, LanguageProvider.get((String)"gui.analysis.package_finder.header") + "\n\n" + LanguageProvider.get((String)"gui.analysis.package_finder.input_message"), LanguageProvider.get((String)"gui.menu.analysis.package_class_finder"), -1, null, null, lastSearch);
        if (input != null && !input.trim().isEmpty()) {
            CrashAssistantLocalConfig.set((String)"analysis.package_finder_last_search", (Object)input.trim());
            new PackageFinderGUI(parent, input.trim()).start();
        }
    }

    @Override
    protected void performAnalysis() {
        LinkedHashSet modsToAnalyze = ModListUtils.getCurrentModList((boolean)true);
        int totalMods = modsToAnalyze.size();
        AtomicInteger completedTasks = new AtomicInteger(0);
        AtomicInteger foundCounter = new AtomicInteger(0);
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(totalMods));
        for (Mod mod : modsToAnalyze) {
            executor.submit(() -> {
                List<Object> foundPaths;
                if (isCancelled) {
                    return;
                }
                SwingUtilities.invokeLater(() -> this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + mod.getJarName()));
                try {
                    Path jarPath = Paths.get("mods", mod.getJarName());
                    foundPaths = ModuleFinder.findJarsContainingEntries(Collections.singletonList(this.searchTerm), jarPath, ModuleFinder.SearchMode.CLASS_OR_PACKAGE);
                }
                catch (Exception e) {
                    CrashAssistantApp.LOGGER.error("Error scanning mod " + mod.getJarName(), (Throwable)e);
                    foundPaths = Collections.emptyList();
                }
                if (!foundPaths.isEmpty()) {
                    this.registerDetectedModJar(mod.getJarName());
                    if (foundCounter.getAndIncrement() == 0) {
                        String msg = LanguageProvider.get((String)"gui.analysis.package_finder.found").replace("$TERM$", this.originalSearchTerm);
                        SwingUtilities.invokeLater(() -> this.appendStyledText(msg, NORMAL_COLOR));
                    }
                    List<Object> finalFoundPaths = foundPaths;
                    SwingUtilities.invokeLater(() -> {
                        for (String path : finalFoundPaths) {
                            this.appendStyledText(path + "\n", MOD_COLOR);
                        }
                    });
                }
                int completed = completedTasks.incrementAndGet();
                SwingUtilities.invokeLater(() -> {
                    if (!isCancelled) {
                        this.progressBar.setValue(completed);
                    }
                });
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!isCancelled && foundCounter.get() == 0) {
            SwingUtilities.invokeLater(() -> {
                String msg = LanguageProvider.get((String)"gui.analysis.package_finder.not_found").replace("$TERM$", this.originalSearchTerm);
                this.appendStyledText(msg, NORMAL_COLOR);
            });
        }
    }
}

