/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui.analysis;

import dev.kostromdan.mods.crash_assistant.app.CrashAssistantApp;
import dev.kostromdan.mods.crash_assistant.app.gui.CrashAssistantGUI;
import dev.kostromdan.mods.crash_assistant.app.gui.FilesRemover;
import dev.kostromdan.mods.crash_assistant.common_config.lang.LanguageProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public abstract class AnalysisGUIBase {
    protected static final List<Process> runningProcesses = Collections.synchronizedList(new ArrayList());
    protected static final Color ERROR_COLOR = Color.RED;
    protected static final Color NORMAL_COLOR = Color.BLACK;
    protected static final Color MOD_COLOR = new Color(0, 0, 255);
    protected static volatile boolean isCancelled = false;
    protected static ExecutorService executor;
    protected JDialog dialog;
    protected JTextPane textPane;
    protected JLabel statusLabel;
    protected JLabel currentJarLabel;
    protected JProgressBar progressBar;
    protected JPanel headerPanel;
    protected final LinkedHashSet<String> detectedModJarsForRemoval = new LinkedHashSet();

    public AnalysisGUIBase(JFrame parent, String title, String headerText) {
        this.dialog = new JDialog(parent, title + " (" + LanguageProvider.get((String)"gui.window_name") + ")", true);
        this.dialog.setLayout(new BorderLayout());
        JLabel headerLabel = new JLabel("<html>" + headerText.replaceAll("\n", "<br>") + "<br>&nbsp;</html>");
        headerLabel.setHorizontalAlignment(2);
        JPanel topPanel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel(LanguageProvider.get((String)"gui.analysis.analyzing_mods"));
        this.statusLabel.setHorizontalAlignment(2);
        this.currentJarLabel = new JLabel(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + LanguageProvider.get((String)"gui.analysis.none"));
        this.currentJarLabel.setHorizontalAlignment(2);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        topPanel.add((Component)this.statusLabel, "North");
        topPanel.add((Component)this.currentJarLabel, "Center");
        topPanel.add((Component)this.progressBar, "South");
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.add((Component)headerLabel, "North");
        this.headerPanel.add((Component)topPanel, "South");
        this.dialog.add((Component)this.headerPanel, "North");
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.textPane.setCaretPosition(0);
        DefaultCaret caret = (DefaultCaret)this.textPane.getCaret();
        caret.setUpdatePolicy(1);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        this.dialog.add((Component)scrollPane, "Center");
        this.dialog.setSize(900, 500);
        this.dialog.setLocationRelativeTo(parent);
        isCancelled = false;
        runningProcesses.clear();
        executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.dialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                isCancelled = true;
                executor.shutdownNow();
                List<Process> list = runningProcesses;
                synchronized (list) {
                    for (Process p : runningProcesses) {
                        p.destroy();
                    }
                    runningProcesses.clear();
                }
            }
        });
    }

    protected void appendStyledText(String text, Color color) {
        StyledDocument doc = this.textPane.getStyledDocument();
        Style style = this.textPane.addStyle("Color Style", null);
        StyleConstants.setForeground(style, color);
        try {
            doc.insertString(doc.getLength(), text, style);
        }
        catch (BadLocationException e) {
            CrashAssistantApp.LOGGER.error("Error appending styled text: ", (Throwable)e);
            try {
                doc.insertString(doc.getLength(), text, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    protected void addOkButton() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton detectedModsButton = new JButton(LanguageProvider.get((String)"gui.analysis.detected_mods_files_remover_button"));
        detectedModsButton.setEnabled(!this.detectedModJarsForRemoval.isEmpty());
        detectedModsButton.addActionListener(e -> {
            Map<String, Path> map = this.buildDetectedModsMap();
            if (map.isEmpty()) {
                JOptionPane.showMessageDialog(this.dialog, LanguageProvider.get((String)"gui.analysis.no_detected_mods"), LanguageProvider.get((String)"gui.files_remover.title"), 1);
                return;
            }
            FilesRemover.showDialog((Window)this.dialog, map, FilesRemover.Mode.JAR);
        });
        buttonPanel.add(detectedModsButton);
        String whyButtonKey = this.getWhyButtonTextKey();
        if (whyButtonKey != null) {
            JButton whyButton = new JButton(LanguageProvider.get((String)whyButtonKey));
            whyButton.addActionListener(e -> {
                String titleKey = this.getWhyDialogTitleKey();
                String bodyKey = this.getWhyDialogBodyKey();
                String title = titleKey != null ? LanguageProvider.get((String)titleKey) : "";
                String body = bodyKey != null ? LanguageProvider.get((String)bodyKey) : "";
                int width = this.getWhyDialogWidth();
                JEditorPane infoPane = CrashAssistantGUI.getEditorPane(body, true, width);
                JOptionPane.showMessageDialog(this.dialog, infoPane, title, 1);
            });
            buttonPanel.add(whyButton);
        }
        JButton okButton = new JButton(LanguageProvider.get((String)"gui.ok"));
        okButton.addActionListener(e -> this.dialog.dispose());
        buttonPanel.add(okButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Path> buildDetectedModsMap() {
        LinkedHashMap<String, Path> map = new LinkedHashMap<String, Path>();
        LinkedHashSet<String> linkedHashSet = this.detectedModJarsForRemoval;
        synchronized (linkedHashSet) {
            for (String jar : this.detectedModJarsForRemoval) {
                if (jar == null) continue;
                map.put(jar, Paths.get("mods", jar));
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDetectedModJar(String jarName) {
        if (jarName == null || jarName.isEmpty()) {
            return;
        }
        LinkedHashSet<String> linkedHashSet = this.detectedModJarsForRemoval;
        synchronized (linkedHashSet) {
            this.detectedModJarsForRemoval.add(jarName);
        }
    }

    protected String getWhyButtonTextKey() {
        return null;
    }

    protected String getWhyDialogTitleKey() {
        return null;
    }

    protected String getWhyDialogBodyKey() {
        return null;
    }

    protected int getWhyDialogWidth() {
        return 500;
    }

    protected void addToHeaderCenter(Component component) {
        this.headerPanel.add(component, "Center");
        this.headerPanel.revalidate();
        this.headerPanel.repaint();
    }

    public void start() {
        new Thread(() -> {
            this.performAnalysis();
            if (!isCancelled) {
                SwingUtilities.invokeLater(() -> {
                    this.addOkButton();
                    this.statusLabel.setText(LanguageProvider.get((String)"gui.analysis.analysis_complete"));
                    this.currentJarLabel.setText(LanguageProvider.get((String)"gui.analysis.current_mod") + " " + LanguageProvider.get((String)"gui.analysis.none"));
                });
            }
        }).start();
        this.dialog.setVisible(true);
    }

    protected abstract void performAnalysis();
}

