/*
 * Decompiled with CFR 0.152.
 */
package dev.kostromdan.mods.crash_assistant.app.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Path2D;
import javax.swing.Timer;
import javax.swing.border.Border;

public class AnimatedBorder
implements Border {
    private float phase = 0.0f;
    private float incrementer = 1.0f;
    private boolean animating = true;
    private final float[] dashArray = new float[]{20.0f, 10.0f};
    private final Component component;
    private final Color borderColor;

    public AnimatedBorder(Component component, Color borderColor, boolean goingLeft) {
        this.component = component;
        this.borderColor = borderColor;
        if (goingLeft) {
            this.phase = 300000.0f;
            this.incrementer = -1.0f;
        }
        Timer animationTimer = new Timer(50, e -> {
            this.phase += this.incrementer;
            component.repaint();
        });
        animationTimer.start();
        new Timer(30000, e -> {
            animationTimer.stop();
            this.animating = false;
            component.repaint();
        }).start();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(this.borderColor);
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(x, y);
        ((Path2D)path).lineTo(x + width, y);
        ((Path2D)path).lineTo(x + width, y + height);
        ((Path2D)path).lineTo(x, y + height);
        ((Path2D)path).lineTo(x, y);
        if (this.animating) {
            BasicStroke stroke = new BasicStroke(2.0f, 0, 0, 10.0f, this.dashArray, this.phase);
            g2d.setStroke(stroke);
        } else {
            g2d.setStroke(new BasicStroke(2.0f));
        }
        g2d.draw(path);
        g2d.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

