/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.core.definitions.AEBlocks;
import appeng.server.testplots.TestPlots;
import appeng.server.testworld.Plot;
import appeng.server.testworld.RectanglePacking;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;

public class TestWorldGenerator {
    private static final int PADDING = 3;
    private static final int OUTER_PADDING = 10;
    private final ServerLevel level;
    private final BlockPos origin;
    private final ServerPlayer player;
    private final List<PositionedPlot> positionedPlots;
    private final BoundingBox overallBounds;
    private final BlockPos suitableStartPos;

    public TestWorldGenerator(ServerLevel level, ServerPlayer player, BlockPos origin, @Nullable ResourceLocation plotId) {
        this.level = level;
        this.origin = origin;
        this.player = player;
        List<Plot> plots = plotId != null ? Collections.singletonList(TestPlots.getById(plotId)) : TestPlots.createPlots();
        RectanglePacking.PositionedArea<Plot> positionedArea = RectanglePacking.pack(plots, plot -> {
            BoundingBox bb = plot.getBounds();
            return new RectanglePacking.Size(bb.m_71056_() + 6, bb.m_71058_() + 6);
        });
        this.positionedPlots = positionedArea.rectangles().stream().map(pp -> {
            BoundingBox relativeBounds = ((Plot)pp.what()).getBounds();
            BlockPos plotOrigin = new BlockPos(pp.x() - ((Plot)pp.what()).getBounds().m_162395_() + 3, origin.m_123342_(), pp.y() - ((Plot)pp.what()).getBounds().m_162398_() + 3);
            BoundingBox absBoundingBox = relativeBounds.m_71045_(plotOrigin.m_123341_(), plotOrigin.m_123342_(), plotOrigin.m_123343_());
            return new PositionedPlot(plotOrigin, absBoundingBox, (Plot)pp.what());
        }).toList();
        this.overallBounds = (BoundingBox)BoundingBox.m_162388_(this.positionedPlots.stream().map(PositionedPlot::bounds).toList()).orElseThrow();
        this.suitableStartPos = origin.m_7918_(positionedArea.w() / 2, 0, -2);
    }

    public BlockPos getSuitableStartPos() {
        return this.suitableStartPos;
    }

    public boolean isWithinBounds(BlockPos pos) {
        return this.overallBounds.m_191961_(10).m_71051_((Vec3i)pos);
    }

    public void generate() {
        this.clearLevel();
        this.buildPlatform();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.buildPlots(entities);
        this.clearEntities(entities);
    }

    private void buildPlots(List<Entity> entities) {
        for (PositionedPlot positionedPlot : this.positionedPlots) {
            this.outline(positionedPlot);
            this.placeSign(positionedPlot);
            positionedPlot.plot.build(this.level, (Player)this.player, positionedPlot.origin, entities);
        }
    }

    private void placeSign(PositionedPlot positionedPlot) {
        BlockPos signPos = new BlockPos(positionedPlot.bounds.m_162399_() + 2, this.origin.m_123342_(), positionedPlot.bounds.m_162398_() - 2);
        this.level.m_7731_(signPos, Blocks.f_50095_.m_49966_().m_60717_(Rotation.CLOCKWISE_180), 3);
        this.level.m_141902_(signPos, BlockEntityType.f_58924_).ifPresent(sign -> {
            SignText signText = sign.m_277157_(true);
            sign.m_155713_(null);
            signText.m_277132_(true);
            signText.m_276901_(DyeColor.WHITE);
            StringBuilder text = new StringBuilder(positionedPlot.plot.getId().m_135815_());
            int line = 0;
            while (line < 4 && !text.isEmpty()) {
                int lineLength = Math.min(12, text.length());
                String lineText = text.substring(0, lineLength);
                text.delete(0, lineLength);
                signText = signText.m_276913_(line++, (Component)Component.m_237113_((String)lineText));
            }
            sign.m_276956_(signText, true);
        });
    }

    private void outline(PositionedPlot positionedPlot) {
        BlockPos from = new BlockPos(positionedPlot.bounds.m_162395_() - 1, positionedPlot.origin.m_123342_() - 1, positionedPlot.bounds.m_162398_() - 1);
        BlockPos to = new BlockPos(positionedPlot.bounds.m_162399_() + 1, positionedPlot.origin.m_123342_() - 1, positionedPlot.bounds.m_162401_() + 1);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
            this.level.m_7731_(pos, AEBlocks.SKY_STONE_SMALL_BRICK.block().m_49966_(), 3);
        }
    }

    private void buildPlatform() {
        ChunkPos from = new ChunkPos(new BlockPos(this.overallBounds.m_162395_() - 10, 0, this.overallBounds.m_162398_() - 10));
        ChunkPos to = new ChunkPos(new BlockPos(this.overallBounds.m_162399_() + 10, 0, this.overallBounds.m_162401_() + 10));
        BlockState state = AEBlocks.SKY_STONE_BRICK.block().m_49966_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ChunkPos.m_45599_((ChunkPos)from, (ChunkPos)to).forEach(chunkPos -> {
            LevelChunk chunk = this.level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            for (int x = 0; x < 16; ++x) {
                pos.m_142451_(chunkPos.m_45604_() + x);
                for (int z = 0; z < 16; ++z) {
                    pos.m_142443_(chunkPos.m_45605_() + z);
                    for (int y = -3; y <= -1; ++y) {
                        pos.m_142448_(this.origin.m_123342_() + y);
                        chunk.m_6978_((BlockPos)pos, state, false);
                    }
                }
            }
        });
    }

    private void clearLevel() {
        ChunkPos from = new ChunkPos(new BlockPos(this.overallBounds.m_162395_() - 10, 0, this.overallBounds.m_162398_() - 10));
        ChunkPos to = new ChunkPos(new BlockPos(this.overallBounds.m_162399_() + 10, 0, this.overallBounds.m_162401_() + 10));
        ChunkPos.m_45599_((ChunkPos)from, (ChunkPos)to).forEach(chunkPos -> {
            LevelChunk chunk = this.level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            if (!chunk.m_6430_()) {
                this.clearChunk(chunk);
            }
        });
    }

    private void clearChunk(LevelChunk chunk) {
        if (chunk.m_6430_()) {
            return;
        }
        int sectionId = 0;
        for (LevelChunkSection sec : chunk.m_7103_()) {
            if (!sec.m_188008_()) {
                BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
                BlockState air = Blocks.f_50016_.m_49966_();
                int bottomBlock = chunk.m_141937_() + 16 * sectionId;
                for (int y = 0; y < 16; ++y) {
                    p.m_142448_(bottomBlock + y);
                    for (int x = 0; x < 16; ++x) {
                        p.m_142451_(chunk.m_7697_().m_45604_() + x);
                        for (int z = 0; z < 16; ++z) {
                            p.m_142443_(chunk.m_7697_().m_45605_() + z);
                            this.level.m_7731_((BlockPos)p, air, 3);
                        }
                    }
                }
            }
            ++sectionId;
        }
    }

    private void clearEntities(List<Entity> plotEntities) {
        Entity[] entities;
        for (Entity entity : entities = (Entity[])Iterables.toArray((Iterable)this.level.m_8583_(), Entity.class)) {
            if (plotEntities.contains(entity) || entity instanceof Player || !entity.m_6084_()) continue;
            entity.m_146870_();
        }
    }

    private record PositionedPlot(BlockPos origin, BoundingBox bounds, Plot plot) {
    }
}

