/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;

public final class GuidebookPlot {
    private GuidebookPlot() {
    }

    @TestPlot(value="guidebook_structure_workarea")
    public static void guidebookStructureWorkArea(PlotBuilder plot) {
        plot.block("[0,15] -1 [0,15]", Blocks.f_50505_);
        plot.block("-1 -1 [0,15]", Blocks.f_50298_);
        plot.block("[0,15] -1 -1", Blocks.f_50301_);
        BlockPos controlPos = BlockPos.f_121853_.m_122013_(2).m_122030_(1);
        GuidebookPlot.control(plot, controlPos.m_122030_(0), "LOAD", (blockEntity, origin) -> String.format(Locale.ROOT, "ae2guide importstructure %s", GuidebookPlot.formatBlockPos(origin)));
        GuidebookPlot.control(plot, controlPos.m_122030_(1), "SAVE", (blockEntity, origin) -> String.format(Locale.ROOT, "ae2guide exportstructure %s %d %d %d", GuidebookPlot.formatBlockPos(origin), 16, 16, 16));
        GuidebookPlot.control(plot, controlPos.m_122030_(2), "CLEAR", (blockEntity, origin) -> {
            BlockPos to = origin.m_7918_(16, 16, 16);
            return String.format(Locale.ROOT, "fill %s %s air", GuidebookPlot.formatBlockPos(origin), GuidebookPlot.formatBlockPos(to));
        });
    }

    private static String formatBlockPos(BlockPos pos) {
        return pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
    }

    private static void control(PlotBuilder plot, BlockPos pos, String label, BiFunction<BlockEntity, BlockPos, String> commandSupplier) {
        plot.blockState(pos, (BlockState)Blocks.f_50153_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(RotationSegment.m_245225_((Direction)Direction.NORTH))));
        plot.customizeBlockEntity(pos, BlockEntityType.f_58924_, sign -> sign.m_277142_().m_276913_(0, (Component)Component.m_237113_((String)label)));
        pos = pos.m_122012_();
        BlockPos cmdBlockRelPos = pos.m_7495_().m_7495_();
        plot.block(cmdBlockRelPos, Blocks.f_50272_);
        plot.customizeBlockEntity(cmdBlockRelPos, BlockEntityType.f_58938_, cmdBlock -> {
            BlockPos origin = cmdBlock.m_58899_().m_7918_(-cmdBlockRelPos.m_123341_(), -cmdBlockRelPos.m_123342_(), -cmdBlockRelPos.m_123343_());
            cmdBlock.m_59141_().m_6590_((String)commandSupplier.apply((BlockEntity)cmdBlock, origin));
        });
        plot.buttonOn(pos.m_7495_(), Direction.UP);
    }
}

