/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.game;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextProcessor {
    public static final TextProcessor INSTANCE = new TextProcessor();
    private static final Pattern CONTROL_PATTERN = Pattern.compile("\\$\\(((?:(?:\\w+|#[0-9A-Fa-f]{6})(?:;(?:\\w+|#[0-9A-Fa-f]{6}))*)?)\\)");

    public List<Component> process(Component text) {
        return this.process(text.getString());
    }

    public List<Component> process(String text) {
        return (List)Arrays.stream(text.split("\\$\\((?:n|newline)\\)")).map(String::trim).map(this::processLine).collect(ImmutableList.toImmutableList());
    }

    public Component processLine(Component line) {
        return this.processLine(line.getString());
    }

    public Component processLine(String line) {
        if (line.isEmpty()) {
            return Component.m_237119_();
        }
        Matcher m = CONTROL_PATTERN.matcher(line);
        MutableComponent tc = Component.m_237119_();
        int idx = 0;
        Style style = Style.f_131099_;
        while (m.find()) {
            if (idx < m.start()) {
                tc.m_7220_((Component)Component.m_237113_((String)line.substring(idx, m.start())).m_130948_(style));
            }
            idx = m.end();
            String cmd = m.group(1).trim();
            if (cmd.isEmpty()) {
                style = Style.f_131099_;
                continue;
            }
            block3: for (String part : cmd.split(";")) {
                if (part.startsWith("#")) {
                    try {
                        int color = Integer.parseInt(part.substring(1), 16);
                        style = style.m_131148_(TextColor.m_131266_((int)color));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ("b".equalsIgnoreCase(part.strip()) || "bold".equalsIgnoreCase(part.strip())) {
                    style = style.m_131136_(Boolean.valueOf(true));
                    continue;
                }
                if ("i".equalsIgnoreCase(part.strip()) || "italic".equalsIgnoreCase(part.strip())) {
                    style = style.m_131155_(Boolean.valueOf(true));
                    continue;
                }
                if ("u".equalsIgnoreCase(part.strip()) || "underline".equalsIgnoreCase(part.strip())) {
                    style = style.m_131162_(Boolean.valueOf(true));
                    continue;
                }
                if ("s".equalsIgnoreCase(part.strip()) || "strikethrough".equalsIgnoreCase(part.strip())) {
                    style = style.m_178522_(Boolean.valueOf(true));
                    continue;
                }
                for (ChatFormatting tf : ChatFormatting.values()) {
                    if (!tf.m_126666_().equalsIgnoreCase(part.strip())) continue;
                    style = style.m_131140_(tf);
                    continue block3;
                }
                style = this.customCommand(style, part.strip());
            }
        }
        if (idx < line.length()) {
            tc.m_7220_((Component)Component.m_237113_((String)line.substring(idx)).m_130948_(style));
        }
        return tc;
    }

    public Style customCommand(Style style, String command) {
        return style;
    }
}

