/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.LibX;
import org.moddingx.libx.impl.config.ConfigImpl;
import org.moddingx.libx.impl.config.ConfigState;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;
import org.moddingx.libx.util.Misc;

public record ConfigShadowMessage(@Nullable ConfigImpl config, @Nullable ConfigState state) {

    public static class Handler
    implements PacketHandler<ConfigShadowMessage> {
        @Override
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        @Override
        public boolean handle(ConfigShadowMessage msg, Supplier<NetworkEvent.Context> ctx) {
            if (msg.config() != null && msg.state() != null) {
                msg.config().shadowBy(msg.state());
            }
            return true;
        }
    }

    public static class Serializer
    implements PacketSerializer<ConfigShadowMessage> {
        @Override
        public Class<ConfigShadowMessage> messageClass() {
            return ConfigShadowMessage.class;
        }

        @Override
        public void encode(ConfigShadowMessage msg, FriendlyByteBuf buffer) {
            if (msg.config() == null || msg.state() == null) {
                buffer.m_130085_(Misc.MISSINGNO);
            } else {
                buffer.m_130085_(msg.config().id);
                FriendlyByteBuf b = new FriendlyByteBuf(Unpooled.buffer());
                msg.state().write(b);
                buffer.m_130130_(b.writerIndex());
                buffer.writeBytes((ByteBuf)b);
            }
        }

        @Override
        public ConfigShadowMessage decode(FriendlyByteBuf buffer) {
            ResourceLocation configId = buffer.m_130281_();
            if (Misc.MISSINGNO.equals((Object)configId)) {
                return new ConfigShadowMessage(null, null);
            }
            ConfigImpl config = ConfigImpl.getConfigNullable(configId);
            int size = buffer.m_130242_();
            if (config == null) {
                LibX.logger.warn("Received shadow message for unknown config: '" + configId + "'. Ignoring");
                buffer.skipBytes(size);
                return new ConfigShadowMessage(null, null);
            }
            if (config.clientConfig) {
                LibX.logger.warn("Received shadow message for not-synced config: '" + configId + "'. Ignoring");
                buffer.skipBytes(size);
                return new ConfigShadowMessage(null, null);
            }
            return new ConfigShadowMessage(config, config.readState(buffer));
        }
    }
}

