/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot.entry;

import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import org.moddingx.libx.datagen.provider.loot.entry.GenericLootModifier;
import org.moddingx.libx.datagen.provider.loot.entry.SimpleLootFactory;

public interface LootModifier<T>
extends GenericLootModifier<T>,
SimpleLootFactory<T> {
    public static <T> LootModifier<T> identity(SimpleLootFactory<T> element) {
        return LootModifier.of(element, (T item, LootPoolSingletonContainer.Builder<?> entry) -> entry);
    }

    public static <T> LootModifier<T> of(final SimpleLootFactory<T> element, final BiFunction<T, LootPoolSingletonContainer.Builder<?>, LootPoolSingletonContainer.Builder<?>> function) {
        return new LootModifier<T>(){

            @Override
            public LootPoolSingletonContainer.Builder<?> apply(T item, LootPoolSingletonContainer.Builder<?> entry) {
                return (LootPoolSingletonContainer.Builder)function.apply(item, entry);
            }

            @Override
            public SimpleLootFactory<T> element() {
                return element;
            }
        };
    }

    public static <T> LootModifier<T> chain(SimpleLootFactory<T> element, List<LootModifier<T>> children) {
        if (children.size() == 0) {
            return LootModifier.identity(element);
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return LootModifier.of(element, (T item, LootPoolSingletonContainer.Builder<?> entry) -> {
            for (LootModifier modifier : children) {
                entry = modifier.apply((T)item, (LootPoolSingletonContainer.Builder<?>)entry);
            }
            return entry;
        });
    }

    @Override
    public LootPoolSingletonContainer.Builder<?> apply(T var1, LootPoolSingletonContainer.Builder<?> var2);

    @Override
    default public LootPoolSingletonContainer.Builder<?> build(T item) {
        return this.apply(item, this.element().build(item));
    }

    default public LootModifier<T> andThen(LootModifier<T> other) {
        return LootModifier.chain(this.element(), List.of(this, other));
    }
}

