/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.config.correct;

import com.google.gson.JsonElement;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.moddingx.libx.config.mapper.ValueMapper;

public interface ConfigCorrection<T> {
    public <U> Optional<U> tryGet(JsonElement var1, ValueMapper<U, ?> var2);

    default public <U> Optional<U> correct(@Nullable JsonElement json, ValueMapper<U, ?> mapper, Function<T, U> extractor) {
        return this.tryCorrect(json, mapper, value -> Optional.ofNullable(extractor.apply(value)));
    }

    public <U> Optional<U> tryCorrect(@Nullable JsonElement var1, ValueMapper<U, ?> var2, Function<T, Optional<U>> var3);

    public static <X, R> Function<X, Optional<R>> check(Predicate<X> present, Function<X, R> result) {
        return value -> present.test(value) ? Optional.ofNullable(result.apply(value)) : Optional.empty();
    }
}

