/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.capability;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.moddingx.libx.util.lazy.LazyValue;

public class SimpleProvider<A>
implements ICapabilityProvider {
    @Nullable
    private final ICapabilityProvider parent;
    private final Capability<A> capability;
    private final LazyValue<A> value;

    public SimpleProvider(Capability<A> capability, Supplier<A> value) {
        this(null, capability, value);
    }

    public SimpleProvider(Capability<A> capability, LazyValue<A> value) {
        this(null, capability, value);
    }

    public SimpleProvider(@Nullable ICapabilityProvider parent, Capability<A> capability, Supplier<A> value) {
        this(parent, capability, new LazyValue<A>(value));
    }

    public SimpleProvider(@Nullable ICapabilityProvider parent, Capability<A> capability, LazyValue<A> value) {
        this.parent = parent;
        this.capability = capability;
        this.value = value;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.capability == cap) {
            return LazyOptional.of(() -> Objects.requireNonNull(this.value.get())).cast();
        }
        return this.parent != null ? this.parent.getCapability(cap, side) : LazyOptional.empty();
    }
}

