/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.durabilitytooltip;

import com.supermartijn642.durabilitytooltip.DurabilityTooltip;
import com.supermartijn642.durabilitytooltip.DurabilityTooltipConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DurabilityTooltipClient {
    private static String lastBlackListConfig = "";
    private static Set<String> blackListedMods = new HashSet<String>();

    public static boolean isBlackListed(Item item) {
        String owningMod = ForgeRegistries.ITEMS.getKey((Object)item).m_135827_();
        if (!DurabilityTooltipConfig.blackListedMods.get().equals(lastBlackListConfig)) {
            blackListedMods.clear();
            Arrays.stream(DurabilityTooltipConfig.blackListedMods.get().split(",")).map(String::trim).filter(s -> {
                boolean valid = s.matches("[a-z0-9_.-]+");
                if (!valid) {
                    DurabilityTooltip.LOGGER.error("Invalid modid '" + s + "' in config value 'blackListedMods'!");
                }
                return valid;
            }).forEach(blackListedMods::add);
            lastBlackListConfig = DurabilityTooltipConfig.blackListedMods.get();
        }
        return blackListedMods.contains(owningMod);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemTooltip(ItemTooltipEvent e) {
        if (!(DurabilityTooltipConfig.onlyVanillaTools.get().booleanValue() && !ForgeRegistries.ITEMS.getKey((Object)e.getItemStack().m_41720_()).m_135827_().equals("minecraft") || DurabilityTooltipClient.isBlackListed(e.getItemStack().m_41720_()) || !DurabilityTooltipConfig.showWhenFull.get().booleanValue() && !e.getItemStack().m_41768_() || !e.getItemStack().m_41763_() || e.getFlags().m_7050_() && e.getItemStack().m_41768_())) {
            int maxDurability = e.getItemStack().m_41776_();
            int durability = maxDurability - e.getItemStack().m_41773_();
            DurabilityTooltipConfig.tooltipStyle.get().appendTooltip(e.getToolTip(), durability, maxDurability);
        }
    }
}

