/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmerrymaking.util;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83148_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result.m_83296_();
    }

    public static VoxelShape setMaxHeight(VoxelShape source, double height) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)height, (double)maxZ);
            result.set(Shapes.m_83148_((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_));
        });
        return result.get().m_83296_();
    }

    public static VoxelShape limitHorizontal(VoxelShape source) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape shape = Shapes.m_83048_((double)VoxelShapeHelper.limit(minX), (double)minY, (double)VoxelShapeHelper.limit(minZ), (double)VoxelShapeHelper.limit(maxX), (double)maxY, (double)VoxelShapeHelper.limit(maxZ));
            result.set(Shapes.m_83148_((VoxelShape)((VoxelShape)result.get()), (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_));
        });
        return result.get().m_83296_();
    }

    public static VoxelShape[] getRotatedShapes(VoxelShape source) {
        VoxelShape shapeNorth = VoxelShapeHelper.rotate(source, Direction.NORTH);
        VoxelShape shapeEast = VoxelShapeHelper.rotate(source, Direction.EAST);
        VoxelShape shapeSouth = VoxelShapeHelper.rotate(source, Direction.SOUTH);
        VoxelShape shapeWest = VoxelShapeHelper.rotate(source, Direction.WEST);
        return new VoxelShape[]{shapeSouth, shapeWest, shapeNorth, shapeEast};
    }

    public static VoxelShape rotate(VoxelShape source, Direction direction) {
        double[] adjustedValues = VoxelShapeHelper.adjustValues(direction, source.m_83288_(Direction.Axis.X), source.m_83288_(Direction.Axis.Z), source.m_83297_(Direction.Axis.X), source.m_83297_(Direction.Axis.Z));
        return Shapes.m_83048_((double)adjustedValues[0], (double)source.m_83288_(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)source.m_83297_(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    private static double[] adjustValues(Direction direction, double var1, double var2, double var3, double var4) {
        switch (direction) {
            case WEST: {
                double var_temp_1 = var1;
                var1 = 1.0 - var3;
                double var_temp_2 = var2;
                var2 = 1.0 - var4;
                var3 = 1.0 - var_temp_1;
                var4 = 1.0 - var_temp_2;
                break;
            }
            case NORTH: {
                double var_temp_3 = var1;
                var1 = var2;
                var2 = 1.0 - var3;
                var3 = var4;
                var4 = 1.0 - var_temp_3;
                break;
            }
            case SOUTH: {
                double var_temp_4 = var1;
                var1 = 1.0 - var4;
                double var_temp_5 = var2;
                var2 = var_temp_4;
                double var_temp_6 = var3;
                var3 = 1.0 - var_temp_5;
                var4 = var_temp_6;
                break;
            }
        }
        return new double[]{var1, var2, var3, var4};
    }

    private static double limit(double value) {
        return Math.max(0.0, Math.min(1.0, value));
    }
}

