/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmerrymaking.blocks.deco;

import com.maideniles.maidensmerrymaking.blocks.deco.HorizontalDecoBlock;
import com.maideniles.maidensmerrymaking.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectedChristmasDecoBlock
extends HorizontalDecoBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final Map<BlockState, VoxelShape> SHAPES = new HashMap<BlockState, VoxelShape>();

    public ConnectedChristmasDecoBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TYPE, (Comparable)((Object)Type.DEFAULT))).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
    }

    private VoxelShape getShape(BlockState state) {
        return this.SHAPES.computeIfAbsent(state, state1 -> {
            VoxelShape TOP = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            VoxelShape[] DEFAULT_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Direction.SOUTH));
            VoxelShape[] LEFT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] RIGHT_INVERTED_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] LEFT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Direction.SOUTH));
            VoxelShape[] RIGHT_CORNER_BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Direction.SOUTH));
            Type type = (Type)((Object)((Object)state1.m_61143_(TYPE)));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TOP);
            switch (type) {
                case DEFAULT: {
                    shapes.add(DEFAULT_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    break;
                }
                case LEFT_CORNER: {
                    shapes.add(DEFAULT_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    shapes.add(LEFT_CORNER_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    break;
                }
                case RIGHT_CORNER: {
                    shapes.add(DEFAULT_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    shapes.add(RIGHT_CORNER_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    break;
                }
                case LEFT_CORNER_INVERTED: {
                    shapes.add(LEFT_INVERTED_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                    break;
                }
                case RIGHT_CORNER_INVERTED: {
                    shapes.add(RIGHT_INVERTED_BASE[((Direction)state.m_61143_((Property)DIRECTION)).m_122416_()]);
                }
            }
            return VoxelShapeHelper.combineAll(shapes);
        });
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(state);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getDecorationState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getDecorationState(state, level, pos);
    }

    private BlockState getDecorationState(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockState backState;
        Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
        BlockState frontState = level.m_8055_(pos.m_121945_(direction.m_122424_()));
        if (frontState.m_60734_() instanceof ConnectedChristmasDecoBlock) {
            if (frontState.m_61143_((Property)DIRECTION) == direction.m_122427_()) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT_CORNER));
            }
            if (frontState.m_61143_((Property)DIRECTION) == direction.m_122428_()) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT_CORNER));
            }
        }
        if ((backState = level.m_8055_(pos.m_121945_(direction))).m_60734_() instanceof ConnectedChristmasDecoBlock) {
            BlockState rightState;
            BlockState leftState;
            if (!(backState.m_61143_((Property)DIRECTION) != direction.m_122427_() || (leftState = level.m_8055_(pos.m_121945_(direction.m_122428_()))).m_60734_() instanceof ConnectedChristmasDecoBlock && leftState.m_61143_((Property)DIRECTION) != direction.m_122424_())) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT_CORNER_INVERTED));
            }
            if (!(backState.m_61143_((Property)DIRECTION) != direction.m_122428_() || (rightState = level.m_8055_(pos.m_121945_(direction.m_122427_()))).m_60734_() instanceof ConnectedChristmasDecoBlock && rightState.m_61143_((Property)DIRECTION) != direction.m_122424_())) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT_CORNER_INVERTED));
            }
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.DEFAULT));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        DEFAULT("default"),
        LEFT_CORNER("left_corner"),
        RIGHT_CORNER("right_corner"),
        LEFT_CORNER_INVERTED("left_corner_inverted"),
        RIGHT_CORNER_INVERTED("right_corner_inverted");

        private String id;

        private Type(String id) {
            this.id = id;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.id;
        }
    }
}

