/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Bridges {
    public static final String modid = "mcwbridges";
    public static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationWoodModLoaded(set, block, item, BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 2.5f).m_60918_(SoundType.f_56736_));
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationRockModLoaded(set, block, item, BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 5.0f).m_60918_(SoundType.f_56742_));
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTab(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab) {
        Bridges.addToTabModLoaded(event, MODID, WOOD, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> WOOD, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : WOOD) {
                Block log_bridge_middle = Finder.findBlock(MODID, i + "_log_bridge_middle");
                Block rope_bridge = Finder.findBlock(MODID, "rope_" + i + "_bridge");
                Block bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block log_bridge_stair = Finder.findBlock(MODID, i + "_log_bridge_stair");
                Block rope_bridge_stair = Finder.findBlock(MODID, i + "_rope_bridge_stair");
                Block rail_bridge = Finder.findBlock(MODID, i + "_rail_bridge");
                event.m_246326_((ItemLike)log_bridge_middle);
                event.m_246326_((ItemLike)rope_bridge);
                event.m_246326_((ItemLike)bridge_pier);
                event.m_246326_((ItemLike)log_bridge_stair);
                event.m_246326_((ItemLike)rope_bridge_stair);
                event.m_246326_((ItemLike)rail_bridge);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStone(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab) {
        Bridges.addToTabStoneModLoaded(event, MODID, STONE, tab, "minecraft");
    }

    @Deprecated(forRemoval=true)
    public static void addToTabStoneModLoaded(BuildCreativeModeTabContentsEvent event, String MODID, List<String> STONE, CreativeModeTab tab, String modLoaded) {
        if (event.getTab() == tab && ModList.get().isLoaded(modid) && ModList.get().isLoaded(modLoaded)) {
            for (String i : STONE) {
                Block stone_bridge = Finder.findBlock(MODID, i + "_bridge");
                Block stone_bridge_pier = Finder.findBlock(MODID, i + "_bridge_pier");
                Block stone_bridge_stair = Finder.findBlock(MODID, i + "_bridge_stair");
                Block balustrade_stone_bridge = Finder.findBlock(MODID, "balustrade_" + i + "_bridge");
                event.m_246326_((ItemLike)stone_bridge);
                event.m_246326_((ItemLike)stone_bridge_pier);
                event.m_246326_((ItemLike)stone_bridge_stair);
                event.m_246326_((ItemLike)balustrade_stone_bridge);
            }
        }
    }
}

