/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.blocks.WheelBarrowBlock;
import com.alaharranhonor.swem.forge.items.ShavingsItem;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class WheelBarrowBE
extends BlockEntity {
    public ItemStackHandler itemHandler = this.createHandler();
    private int timer = 0;
    private boolean shouldTick = false;
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public WheelBarrowBE(BlockPos p_155630_, BlockState p_155631_) {
        super((BlockEntityType)BlockEntitySetup.WHEEL_BARROW_BLOCK_ENTITY.get(), p_155630_, p_155631_);
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128379_("shouldTick", this.shouldTick);
        super.m_183515_(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag layers = new CompoundTag();
        this.itemHandler.getStackInSlot(0).m_41739_(layers);
        nbt.m_128365_("layers", (Tag)layers);
        this.m_183515_(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (tag.m_128441_("layers")) {
            this.itemHandler.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.m_128423_("layers"))));
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.itemHandler.getStackInSlot(0).m_41739_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.itemHandler.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)pkt.m_131708_()));
    }

    public void m_142466_(CompoundTag nbt) {
        this.itemHandler.deserializeNBT(nbt.m_128469_("inv"));
        this.shouldTick = nbt.m_128471_("shouldTick");
        super.m_142466_(nbt);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                WheelBarrowBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof ShavingsItem.SoiledShavingsItem;
            }

            public int getSlotLimit(int slot) {
                return 8;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.handler.invalidate();
        }
    }

    public void dropItems() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), this.itemHandler.getStackInSlot(i));
            RandomSource RANDOM = this.f_58857_.m_213780_();
            entity.m_20334_(RANDOM.m_188583_() * (double)0.05f, RANDOM.m_188583_() * (double)0.05f + (double)0.2f, RANDOM.m_188583_() * (double)0.05f);
            this.f_58857_.m_7967_((Entity)entity);
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void resetTimer() {
        this.timer = 0;
        this.shouldTick = false;
    }

    public void startTicking() {
        this.shouldTick = true;
    }

    public void tickServer() {
        if (this.shouldTick) {
            ++this.timer;
            if (this.timer % 20 == 0) {
                this.resetBlockStateLevel();
                this.dropCompost();
                this.resetTimer();
            }
        }
    }

    private void resetBlockStateLevel() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)WheelBarrowBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
    }

    private void dropCompost() {
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        ItemStack stack = new ItemStack((ItemLike)BlockSetup.WET_COMPOST.get());
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), stack);
        this.f_58857_.m_7967_((Entity)itemEntity);
    }
}

