/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.container.TagLockMenu;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.util.ILockableContainer;
import com.alaharranhonor.swem.forge.util.NameTagLock;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.alaharranhonor.swem.forge.util.TagLockContainer;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RackBaseBE
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
ILockableContainer {
    protected final ItemStackHandler itemHandler;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(this::getInventory);
    private UUID ownerId;
    private String ownerName;
    private final TagLockContainer lockContainer = new TagLockContainer(this, 5){

        @Override
        public void m_6596_() {
            RackBaseBE.this.m_6596_();
        }
    };

    protected RackBaseBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        this(pType, pPos, pBlockState, 0);
    }

    protected RackBaseBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int slots) {
        super(pType, pPos, pBlockState);
        this.itemHandler = this.createHandler(slots);
    }

    public InteractionResult handleSlottedInteraction(Player player, ItemStack stack, int slot) {
        boolean inserted = true;
        ItemStack copy = stack.m_41777_();
        ItemStack leftover = this.itemHandler.insertItem(slot, copy, true);
        if (leftover.m_41613_() == copy.m_41613_()) {
            inserted = false;
        }
        if (inserted) {
            this.itemHandler.insertItem(slot, copy, false);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            PacketDistributor.TRACKING_CHUNK.with(() -> this.m_58904_().m_46745_(this.m_58899_())).send(this.m_58483_());
        } else {
            ItemStackHandler inv = this.getInventory();
            ItemStack extracted = inv.extractItem(slot, 64, false);
            if (extracted.m_41619_()) {
                return InteractionResult.PASS;
            }
            ItemEntity itementity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), extracted);
            itementity.m_20334_(this.f_58857_.f_46441_.m_188583_() * (double)0.05f, this.f_58857_.f_46441_.m_188583_() * (double)0.05f + (double)0.2f, this.f_58857_.f_46441_.m_188583_() * (double)0.05f);
            this.f_58857_.m_7967_((Entity)itementity);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11678_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            PacketDistributor.TRACKING_CHUNK.with(() -> this.m_58904_().m_46745_(this.m_58899_())).send(this.m_58483_());
        }
        return InteractionResult.SUCCESS;
    }

    public abstract RackType getRackType();

    protected abstract ItemStackHandler createHandler(int var1);

    public ItemStackHandler getInventory() {
        return this.itemHandler;
    }

    public boolean canAccess(Player player) {
        if (player.m_20148_().equals(this.ownerId)) {
            return true;
        }
        if (Keys.hasPermission(player, PermissionNodes.CAN_ACCESS)) {
            return true;
        }
        return this.lockContainer.canAccess(player);
    }

    public void setOwner(Player player) {
        this.ownerId = player.m_20148_();
        this.ownerName = player.m_5446_().getString();
    }

    public boolean hasOwner() {
        return this.ownerId != null;
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128365_("Locks", (Tag)this.lockContainer.createTag());
        if (this.ownerId != null) {
            tag.m_128362_("Owner", this.ownerId);
        }
        if (this.ownerName != null) {
            tag.m_128359_("OwnerName", this.ownerName);
        }
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("inv")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        }
        if (tag.m_128441_("Lock")) {
            NameTagLock lock = new NameTagLock();
            lock.deserializeNBT(tag.m_128469_("Lock"));
            this.lockContainer.setLock(0, lock);
        } else if (tag.m_128441_("Locks")) {
            this.lockContainer.fromTag(tag.m_128437_("Locks", 10));
        }
        if (tag.m_128441_("Owner")) {
            this.ownerId = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("OwnerName")) {
            this.ownerName = tag.m_128461_("OwnerName");
        }
        super.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.handler.invalidate();
        }
    }

    public void dropItems() {
        int i;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ItemEntity entity = this.createItemDrop(this.itemHandler.getStackInSlot(i));
            this.f_58857_.m_7967_((Entity)entity);
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        for (i = 0; i < this.lockContainer.m_6643_(); ++i) {
            ItemStack item = this.lockContainer.m_8020_(i);
            if (item.m_41619_()) continue;
            ItemEntity entity = this.createItemDrop(item);
            this.f_58857_.m_7967_((Entity)entity);
            this.lockContainer.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @NotNull
    private ItemEntity createItemDrop(ItemStack item) {
        ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), item);
        RandomSource random = this.f_58857_.m_213780_();
        entity.m_20334_(random.m_188583_() * (double)0.05f, random.m_188583_() * (double)0.05f + (double)0.2f, random.m_188583_() * (double)0.05f);
        return entity;
    }

    @Override
    public TagLockContainer getLocks() {
        return this.lockContainer;
    }

    @Override
    public boolean canModifyLocks(Player player) {
        return player.m_20148_().equals(this.ownerId) || Keys.hasPermission(player, PermissionNodes.CAN_ACCESS);
    }

    public Component m_5446_() {
        if (this.ownerName == null) {
            Player player = this.f_58857_.m_46003_(this.ownerId);
            if (player == null) {
                return Component.m_237113_((String)"Unknown");
            }
            this.ownerName = player.m_5446_().getString();
        }
        return Component.m_237113_((String)this.ownerName);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TagLockMenu(pContainerId, pPlayerInventory, this.getLocks());
    }

    public <E extends GeoAnimatable> PlayState predicate(AnimationState<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

