/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.tileentity;

import com.alaharranhonor.swem.forge.blocks.LockerBlock;
import com.alaharranhonor.swem.forge.container.LockerContainer;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.alaharranhonor.swem.forge.registry.BlockEntitySetup;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class LockerBE
extends RandomizableContainerBlockEntity
implements MenuProvider {
    protected int numPlayersUsing;
    private NonNullList<ItemStack> lockerContents = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
    private SimpleContainer lockSlot = new SimpleContainer(2){

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return pStack.m_150930_(Items.f_42656_);
        }

        public boolean m_6542_(Player pPlayer) {
            return LockerBE.this.m_7525_(pPlayer);
        }
    };
    private final IItemHandlerModifiable items = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> this.items);
    private boolean leftSideOpened;
    private UUID owner;

    public LockerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntitySetup.LOCKER_BLOCK_ENTITY.get(), pos, state);
    }

    public void initializeWithOwner(Player player) {
        this.owner = player.m_20148_();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public static void swapContents(LockerBE te, LockerBE otherTe) {
        NonNullList<ItemStack> list = te.m_7086_();
        te.m_6520_(otherTe.m_7086_());
        otherTe.m_6520_(list);
    }

    public Container getLockSlot() {
        return this.lockSlot;
    }

    public boolean m_7525_(Player player) {
        ItemStack lock = this.lockSlot.m_8020_(this.leftSideOpened ? 0 : 1);
        if (lock.m_41619_()) {
            return true;
        }
        if (Keys.hasPermission(player, PermissionNodes.CAN_ACCESS)) {
            return true;
        }
        if (player.m_20148_().equals(this.owner)) {
            return true;
        }
        return lock.m_41786_().getString().equals(player.m_5446_().getString());
    }

    public boolean canModifyLock(Player player) {
        return player.m_20148_().equals(this.owner) || Keys.hasPermission(player, PermissionNodes.CAN_ACCESS);
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.lockerContents;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.lockerContents = itemsIn;
    }

    public Component m_5446_() {
        return this.leftSideOpened ? Component.m_237115_((String)"container.swem.locker.left") : Component.m_237115_((String)"container.swem.locker.right");
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.swem.locker");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new LockerContainer(id, player, this, this.leftSideOpened);
    }

    public void setLeftSideOpened(boolean leftSideOpened) {
        this.leftSideOpened = leftSideOpened;
    }

    public int m_6643_() {
        return 36;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.lockerContents);
        }
        compound.m_128365_("Locks", (Tag)this.lockSlot.m_7927_());
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.lockerContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.lockerContents);
        }
        this.lockSlot.m_7797_(nbt.m_128437_("Locks", 10));
        if (nbt.m_128403_("Owner")) {
            this.owner = nbt.m_128342_("Owner");
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof LockerBlock) {
            this.f_58857_.m_7696_(this.m_58899_(), block, 1, this.numPlayersUsing);
            this.f_58857_.m_46672_(this.m_58899_(), block);
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.itemHandler != null) {
            this.itemHandler.invalidate();
        }
    }

    private IItemHandlerModifiable createHandler() {
        return new InvWrapper((Container)this);
    }
}

