/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.ActionBehavior;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.ClientboundHorseAnimationPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerboundHorseAnimationPacket {
    private int entityID;
    private int action;
    private final boolean failed;

    public ServerboundHorseAnimationPacket(int entityID, int action) {
        this.entityID = entityID;
        this.action = action;
        this.failed = false;
    }

    public ServerboundHorseAnimationPacket(boolean failed) {
        this.failed = failed;
    }

    public static ServerboundHorseAnimationPacket decode(ByteBuf buf) {
        try {
            int entityID = buf.readInt();
            int action = buf.readInt();
            return new ServerboundHorseAnimationPacket(entityID, action);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("SHorseAnimationPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new ServerboundHorseAnimationPacket(true);
        }
    }

    public static void encode(ServerboundHorseAnimationPacket msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityID);
        buffer.writeInt(msg.action);
    }

    public static void handle(ServerboundHorseAnimationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = player.m_9236_().m_6815_(msg.entityID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (msg.action == 1) {
                horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.REAR);
                horse.setDisobedienceTimer(142);
                return;
            }
            if (msg.action == 2) {
                horse.getBehavior(ActionBehavior.class).startAction(ActionBehavior.Action.BUCK);
                horse.setDisobedienceTimer(142);
                return;
            }
            switch (msg.action) {
                case 3: {
                    SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new ClientboundHorseAnimationPacket(horse.m_19879_(), 3));
                    horse.setGait(SWEMHorseEntityBase.Gait.WALK);
                    break;
                }
                case 4: {
                    SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new ClientboundHorseAnimationPacket(horse.m_19879_(), 4));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

