/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.network.protocol.game;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.SCameraLockPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class CCameraLockPacket {
    private UUID horseUUID;
    private boolean locked;
    private final boolean failed;

    public CCameraLockPacket(UUID horseUUID, boolean locked) {
        this.horseUUID = horseUUID;
        this.locked = locked;
        this.failed = false;
    }

    public CCameraLockPacket(boolean failed) {
        this.failed = failed;
    }

    public static CCameraLockPacket decode(ByteBuf buf) {
        try {
            UUID horseUUID = ((FriendlyByteBuf)buf).m_130259_();
            boolean locked = buf.readBoolean();
            return new CCameraLockPacket(horseUUID, locked);
        }
        catch (IndexOutOfBoundsException e) {
            ModRef.LOGGER.error("CCameraLockPacket: Unexpected end of packet.\nMessage: " + ByteBufUtil.hexDump((ByteBuf)buf, (int)0, (int)buf.writerIndex()), (Throwable)e);
            return new CCameraLockPacket(true);
        }
    }

    public static void encode(CCameraLockPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130077_(msg.horseUUID);
        buffer.writeBoolean(msg.locked);
    }

    public static void handle(CCameraLockPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Entity entity = ((ServerLevel)player.m_9236_()).m_8791_(msg.horseUUID);
            if (!(entity instanceof SWEMHorseEntityBase)) {
                return;
            }
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            horse.setCameraLock(msg.locked);
            SWEMPackets.sendToPlayers(PacketDistributor.TRACKING_ENTITY.with(() -> horse), new SCameraLockPacket(horse.m_19879_(), horse.m_146908_(), horse.m_146909_()));
        });
        ctx.get().setPacketHandled(true);
    }
}

