/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.keys;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.keys.Key;
import com.alaharranhonor.swem.forge.registry.CapabilitySetup;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.permission.nodes.PermissionNode;

public class Keys {
    private static final HashMap<ResourceLocation, Key> KEYS = new HashMap();
    public static final Key FILM = Keys.register(new Key(ModRef.res("film"), PermissionNodes.CAN_FILM));
    public static final Key MOD = Keys.register(new Key(ModRef.res("mod"), PermissionNodes.CAN_TAME, PermissionNodes.CAN_TACKUP, PermissionNodes.CAN_FRIEND, PermissionNodes.CAN_TRANSFER, PermissionNodes.CAN_ACCESS, PermissionNodes.CAN_RENAME, PermissionNodes.CAN_DISMOUNT, PermissionNodes.CAN_NEED, PermissionNodes.CAN_BREED));
    public static final Key ADMIN = Keys.register(new Key(ModRef.res("admin"), PermissionNodes.CAN_MODIFY, PermissionNodes.CAN_LEVEL, PermissionNodes.CAN_SUMMON));

    public static void init() {
    }

    public static boolean hasPermission(Player player, PermissionNode<?> perm) {
        ServerPlayer serverPlayer;
        if (!ServerConfig.enableKeyPermissions) {
            return true;
        }
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_20194_().m_129792_() && serverPlayer.m_20310_(4)) {
            return true;
        }
        return player.getCapability(CapabilitySetup.KEY_HOLDER).map(holder -> holder.hasPermission(perm)).orElse(false);
    }

    public static boolean hasPermission(CommandSourceStack src, PermissionNode<?> perm) {
        try {
            return src.m_81377_().m_129792_() && src.m_6761_(4) || Keys.hasPermission((Player)src.m_81375_(), perm);
        }
        catch (CommandSyntaxException e) {
            return true;
        }
    }

    private static Key register(Key key) {
        KEYS.put(key.id, key);
        return key;
    }

    public static Key fromId(ResourceLocation id) {
        return KEYS.get(id);
    }

    public static Set<String> getNames() {
        return KEYS.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toSet());
    }
}

