/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.keys;

import com.alaharranhonor.swem.forge.keys.IKeyHolder;
import com.alaharranhonor.swem.forge.keys.Key;
import com.alaharranhonor.swem.forge.keys.Keys;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.server.permission.nodes.PermissionNode;

public class KeyHolder
implements IKeyHolder {
    private final Set<Key> keys = new HashSet<Key>();

    @Override
    public boolean addKey(Key key) {
        boolean added = this.keys.add(key);
        return added;
    }

    @Override
    public boolean removeKey(Key key) {
        boolean removed = this.keys.remove(key);
        return removed;
    }

    @Override
    public Set<Key> getKeys() {
        return ImmutableSet.copyOf(this.keys);
    }

    @Override
    public boolean hasKey(Key key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean hasPermission(PermissionNode<?> permission) {
        for (Key key : this.keys) {
            if (!key.perms.contains(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearKeys() {
        this.keys.clear();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag keys = new ListTag();
        this.getKeys().forEach(key -> keys.add((Object)StringTag.m_129297_((String)key.id.toString())));
        nbt.m_128365_("Keys", (Tag)keys);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag keysTag = nbt.m_128437_("Keys", 8);
        this.keys.clear();
        keysTag.forEach(tag -> {
            ResourceLocation keyId = new ResourceLocation(tag.m_7916_());
            this.keys.add(Keys.fromId(keyId));
        });
    }
}

