/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AmethystShovel
extends ShovelItem {
    private static final UUID BROKEN_ATTRIBUTE_MODIFIER = UUID.fromString("339c12f0-caab-4cbc-8335-a134fa12fc2c");

    public AmethystShovel(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41773_() == stack.m_41776_() - 1;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        return AmethystShovel.isBroken(pStack) ? 0.0f : super.m_8102_(pStack, pState);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND && AmethystShovel.isBroken(stack)) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BROKEN_ATTRIBUTE_MODIFIER, "broken", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> tooltips, TooltipFlag pIsAdvanced) {
        if (AmethystShovel.isBroken(pStack)) {
            tooltips.add((Component)Component.m_237115_((String)"tool.broken").m_130940_(ChatFormatting.GRAY));
        }
    }
}

