/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.items.tack;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.client.model.ModelBoneType;
import com.alaharranhonor.swem.forge.community.RackType;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.community.content.tack.TackCost;
import com.alaharranhonor.swem.forge.community.content.tack.type.TackTypeData;
import com.alaharranhonor.swem.forge.entities.Tackable;
import com.alaharranhonor.swem.forge.entities.horse.HorseModelType;
import com.alaharranhonor.swem.forge.tack.TackItemDefinition;
import com.alaharranhonor.swem.forge.util.IHasColor;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TackItem
extends Item
implements IHasColor,
GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this, (boolean)true);
    private final TackItemDefinition tackDefinition;

    public TackItem(Item.Properties pProperties) {
        super(pProperties);
        this.tackDefinition = null;
    }

    public TackItem(TackItemDefinition pTackDefinition, Item.Properties pProperties) {
        super(pProperties);
        this.tackDefinition = pTackDefinition;
    }

    public static TackItem as(ItemStack stack) {
        return (TackItem)stack.m_41720_();
    }

    public Component m_7626_(ItemStack pStack) {
        if (this.tackDefinition == null || this.tackDefinition.display() == null) {
            return super.m_7626_(pStack);
        }
        return Component.m_237113_((String)this.tackDefinition.display().displayName());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (this.tackDefinition == null || this.tackDefinition.display() == null) {
            return;
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)"Credits: ").m_7220_((Component)Component.m_237113_((String)this.tackDefinition.display().credits())).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237113_((String)"Inspiration: ").m_7220_((Component)Component.m_237113_((String)this.tackDefinition.display().inspiration())).m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        Tackable tackable;
        if (playerIn.m_9236_().m_5776_()) {
            return InteractionResult.PASS;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof TackItem)) {
            return InteractionResult.PASS;
        }
        TackItem tack = (TackItem)item;
        if (!(target instanceof Tackable && (tackable = (Tackable)target).canReceiveTack(playerIn) && tackable.canEquip(stack, tack.getType()))) {
            return InteractionResult.PASS;
        }
        if (tack.getType() == TackType.SADDLE_BAG && tackable.hasTack(TackType.SADDLE_BAG)) {
            return InteractionResult.PASS;
        }
        if (!tackable.equipTack(stack, playerIn)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public TackCost getCost() {
        return this.tackDefinition.cost();
    }

    public TackType getType() {
        return this.tackDefinition.type();
    }

    public TackTypeData getData() {
        return this.tackDefinition.data();
    }

    public <T extends TackTypeData> T getData(Class<T> cls) {
        return (T)this.tackDefinition.data();
    }

    @Override
    public Color getColor() {
        return this.tackDefinition.data().getColor();
    }

    public ResourceLocation getTextureOnHorse(HorseModelType pModelType, ModelBoneType pModelBoneType) {
        if (this.tackDefinition != null && this.tackDefinition.horseTextures().contains((Object)pModelType, (Object)pModelBoneType)) {
            return (ResourceLocation)this.tackDefinition.horseTextures().get((Object)pModelType, (Object)pModelBoneType);
        }
        String itemName = ForgeRegistries.ITEMS.getKey((Object)this).m_135815_();
        return ModRef.res(String.format("textures/entity/horse/%s/%s.png", pModelBoneType.name, itemName));
    }

    public ResourceLocation getTextureOnRack(RackType pRackType) {
        if (this.tackDefinition != null && this.tackDefinition.rackTextures().containsKey((Object)pRackType)) {
            return this.tackDefinition.rackTextures().get((Object)pRackType);
        }
        String itemName = ForgeRegistries.ITEMS.getKey((Object)this).m_135815_();
        return ModRef.res(String.format("textures/entity/rack/%s/%s.png", pRackType.name, itemName));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
    }
}

