/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.eventhandlers;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.blocks.HitchingPostBase;
import com.alaharranhonor.swem.forge.blocks.HitchingPostBaseMini;
import com.alaharranhonor.swem.forge.blocks.HitchingRing;
import com.alaharranhonor.swem.forge.blocks.LeadAnchorBlock;
import com.alaharranhonor.swem.forge.blocks.SWEMBlockStateProperties;
import com.alaharranhonor.swem.forge.blocks.TackBoxBlock;
import com.alaharranhonor.swem.forge.commands.SWEMCommand;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.config.HorseSpawnType;
import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.data.HorseDataManager;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.FlightBehavior;
import com.alaharranhonor.swem.forge.items.tools.AmethystBow;
import com.alaharranhonor.swem.forge.items.tools.AmethystPickaxe;
import com.alaharranhonor.swem.forge.items.tools.AmethystShield;
import com.alaharranhonor.swem.forge.items.tools.AmethystSword;
import com.alaharranhonor.swem.forge.items.tools.SWEMItemTier;
import com.alaharranhonor.swem.forge.keys.KeyHolder;
import com.alaharranhonor.swem.forge.keys.KeyHolderProvider;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.CMountEntityPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ClientBoundSetTankControlsPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.ServerboundHorseAnimationPacket;
import com.alaharranhonor.swem.forge.registry.BlockSetup;
import com.alaharranhonor.swem.forge.registry.CapabilitySetup;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import com.alaharranhonor.swem.forge.registry.TagSetup;
import com.alaharranhonor.swem.forge.tileentity.BridleRackBE;
import com.alaharranhonor.swem.forge.tileentity.HorseArmorRackBE;
import com.alaharranhonor.swem.forge.tileentity.LockerBE;
import com.alaharranhonor.swem.forge.tileentity.SaddleRackBE;
import com.alaharranhonor.swem.forge.tileentity.WheelBarrowBE;
import com.alaharranhonor.swem.forge.util.PermissionNodes;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;

@Mod.EventBusSubscriber(modid="swem")
public class CommonEventHandler {
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private static HorseDataManager horseDataManager;
    private static final LevelResource SWEM_DATA_PATH;
    private static final UUID RANGE_MODIFIER_ID;
    private static final AttributeModifier RANGE_MODIFIER;

    @SubscribeEvent
    public static void preventVanillaHorseSpawn(MobSpawnEvent.SpawnPlacementCheck event) {
        if (event.getEntityType() == EntityType.f_20457_ && event.getSpawnType() == MobSpawnType.CHUNK_GENERATION && ServerConfig.horseSpawn == HorseSpawnType.SWEM_ONLY) {
            event.setResult(Event.Result.DENY);
        }
    }

    public static HorseDataManager getHorseDataManager() {
        return horseDataManager;
    }

    @SubscribeEvent
    public static void serverStarting(ServerAboutToStartEvent event) {
        horseDataManager = new HorseDataManager(event.getServer().m_129843_(SWEM_DATA_PATH));
        try {
            horseDataManager.load();
        }
        catch (IOException e) {
            ModRef.LOGGER.error("Could not load horse data from file.", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void serverShutdown(ServerStoppingEvent event) {
        horseDataManager.save(event.getServer());
    }

    @SubscribeEvent
    public static void preventBreakingWithBrokenTools(BlockEvent.BreakEvent event) {
        ItemStack tool = event.getPlayer().m_21205_();
        if (tool.m_220167_(i -> {
            TieredItem tiered;
            Item item = (Item)i.get();
            return item instanceof TieredItem && (tiered = (TieredItem)item).m_43314_() == SWEMItemTier.AMETHYST || item instanceof AmethystBow || item instanceof AmethystShield;
        }) && AmethystPickaxe.isBroken(tool)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void preventBreakingUnownedBlocks(BlockEvent.BreakEvent event) {
        BlockEntity rack;
        LockerBE locker;
        BlockEntity be = event.getLevel().m_7702_(event.getPos());
        Player player = event.getPlayer();
        if (be instanceof LockerBE && !(locker = (LockerBE)be).canModifyLock(player)) {
            event.setCanceled(true);
            return;
        }
        if (be instanceof SaddleRackBE && !(rack = (SaddleRackBE)be).canModifyLocks(player)) {
            event.setCanceled(true);
            return;
        }
        if (be instanceof BridleRackBE && !(rack = (BridleRackBE)be).canModifyLocks(player)) {
            event.setCanceled(true);
            return;
        }
        if (be instanceof HorseArmorRackBE && !(rack = (HorseArmorRackBE)be).canModifyLocks(player)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void increaseHitRange(TickEvent.PlayerTickEvent event) {
        Entity entity;
        if (event.phase == TickEvent.Phase.START || !((entity = event.player.m_20202_()) instanceof SWEMHorseEntityBase)) {
            CommonEventHandler.removeRange(event.player);
            return;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        if (event.player.m_21205_().m_204117_(TagSetup.Items.LONG_WEAPONS)) {
            CommonEventHandler.applyRange(event.player);
        } else {
            CommonEventHandler.removeRange(event.player);
        }
    }

    private static void applyRange(Player player) {
        AttributeInstance attributes = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        attributes.m_22118_(RANGE_MODIFIER);
    }

    private static void removeRange(Player player) {
        AttributeInstance attributes = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (attributes.m_22109_(RANGE_MODIFIER)) {
            attributes.m_22120_(RANGE_MODIFIER_ID);
        }
    }

    @SubscribeEvent
    public static void defeatherHorseArmor(PlayerEvent.ItemCraftedEvent event) {
        if (!event.getCrafting().m_150930_((Item)ItemSetup.FEATHER_FLIGHT.get())) {
            return;
        }
        boolean defeathered = false;
        boolean damaged = false;
        Container inv = event.getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!damaged && stack.m_150930_(Items.f_42574_)) {
                ItemStack shears = stack.m_41777_();
                shears.m_41622_(1, (LivingEntity)event.getEntity(), p -> {});
                event.getEntity().m_150109_().m_150079_(shears);
                damaged = true;
                continue;
            }
            if (defeathered || !stack.m_204117_(TagSetup.Items.AMETHYST_HORSE_ARMORS)) continue;
            ItemStack result = stack.m_41777_();
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Defeathered", true);
            result.m_41700_("swem", (Tag)tag);
            event.getEntity().m_150109_().m_150079_(result);
            defeathered = true;
        }
    }

    @SubscribeEvent
    public static void copyDefeatheredTag(PlayerEvent.ItemCraftedEvent event) {
        if (!event.getCrafting().m_204117_(TagSetup.Items.AMETHYST_HORSE_ARMORS)) {
            return;
        }
        Container inv = event.getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_204117_(TagSetup.Items.AMETHYST_HORSE_ARMORS)) continue;
            CompoundTag tag = stack.m_41737_("swem");
            if (tag != null) {
                event.getCrafting().m_41700_("swem", (Tag)tag);
            }
            return;
        }
    }

    @SubscribeEvent
    public static void copySaddlebagInventory(PlayerEvent.ItemCraftedEvent event) {
        if (!TackType.SADDLE_BAG.is(event.getCrafting())) {
            return;
        }
        Container inv = event.getInventory();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!TackType.SADDLE_BAG.is(stack)) continue;
            event.getCrafting().deserializeNBT(stack.serializeNBT());
            return;
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        if (event.getOriginal().getPersistentData().m_128441_("tracked")) {
            event.getEntity().getPersistentData().m_128365_("tracked", event.getOriginal().getPersistentData().m_128423_("tracked"));
        }
        event.getEntity().getCapability(CapabilitySetup.KEY_HOLDER).ifPresent(newCap -> {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(CapabilitySetup.KEY_HOLDER).ifPresent(originalCap -> {
                if (newCap instanceof KeyHolder) {
                    KeyHolder newKeys = (KeyHolder)newCap;
                    if (originalCap instanceof KeyHolder) {
                        KeyHolder originalKeys = (KeyHolder)originalCap;
                        newKeys.deserializeNBT(originalKeys.serializeNBT());
                    }
                }
            });
            event.getOriginal().invalidateCaps();
        });
    }

    @SubscribeEvent
    public static void onFinishedLoading(ServerStartedEvent event) {
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(SWEMCommand.register());
    }

    @SubscribeEvent
    public static void gatherPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(PermissionNodes.NODES.values());
    }

    @SubscribeEvent
    public static void attachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(ModRef.res("key_holder"), (ICapabilityProvider)new KeyHolderProvider());
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
    }

    @SubscribeEvent
    public static void entityDismount(EntityMountEvent event) {
        if (event.isMounting()) {
            return;
        }
        if (event.getEntityBeingMounted() == null) {
            return;
        }
        Entity mount = event.getEntityBeingMounted();
        Entity rider = event.getEntityMounting();
        if (mount instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)mount;
            if (horse.m_20197_().size() > 1 && horse.m_20197_().stream().allMatch(ent -> ent instanceof Player)) {
                return;
            }
            horse.setGait(SWEMHorseEntityBase.Gait.WALK);
            if (!horse.m_9236_().m_5776_()) {
                horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_FORWARD, (Object)false);
                horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_BACKWARDS, (Object)false);
                horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_LEFT, (Object)false);
                horse.m_20088_().m_135381_(SWEMHorseEntityBase.IS_MOVING_RIGHT, (Object)false);
            } else {
                SWEMPackets.sendToServer(new ServerboundHorseAnimationPacket(horse.m_19879_(), 4));
            }
        }
    }

    @SubscribeEvent
    public static void preventShiftDismountWhenFLying(EntityMountEvent event) {
        if (event.isMounting()) {
            return;
        }
        Entity dismountingPlayer = event.getEntityMounting();
        Entity entity = event.getEntityBeingMounted();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            return;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        if (!horse.m_6084_() || !dismountingPlayer.m_6084_()) {
            return;
        }
        Player controllingPlayer = horse.getControllingPlayer();
        if (controllingPlayer != null && !controllingPlayer.m_20148_().equals(dismountingPlayer.m_20148_())) {
            return;
        }
        FlightBehavior flight = horse.getBehavior(FlightBehavior.class);
        if (dismountingPlayer.m_6144_() && flight.isFlying()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void canEntityBeMounted(EntityMountEvent event) {
        if (!event.isMounting()) {
            return;
        }
        if (event.getEntityBeingMounted() == null) {
            return;
        }
        Entity entity = event.getEntityBeingMounted();
        if (entity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
            if (event.getEntityMounting() instanceof Player && !horse.canPlayerMount((Player)event.getEntityMounting())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getLevel().f_46443_ && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
            SWEMPackets.sendToServer(new CMountEntityPacket(event.getTarget()));
        }
    }

    @SubscribeEvent
    public static void amethystSwordReducedDamage(LivingHurtEvent event) {
        if (!(event.getEntity() instanceof SWEMHorseEntityBase)) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_21205_().m_41720_() instanceof AmethystSword || player.m_21206_().m_41720_() instanceof AmethystSword) {
            event.setAmount(event.getAmount() * 0.25f);
        }
    }

    @SubscribeEvent
    public static void leadWithBridleReins(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof SWEMHorseEntityBase)) {
            return;
        }
        SWEMHorseEntityBase horse = (SWEMHorseEntityBase)entity;
        if (horse.m_21524_() == event.getEntity() && horse.isBridleLeashed()) {
            horse.setBridleLeashed(false);
            horse.m_21455_(true, false);
            event.setCancellationResult(InteractionResult.CONSUME);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void resetHitchingPostCustomKnot(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof LeashFenceKnotEntity)) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60734_() instanceof HitchingPostBase) {
            event.getLevel().m_7731_(event.getPos(), (BlockState)event.getLevel().m_8055_(event.getPos()).m_61124_((Property)HitchingPostBase.CUSTOM_LEAD, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (state.m_60734_() instanceof HitchingPostBaseMini) {
            event.getLevel().m_7731_(event.getPos(), (BlockState)event.getLevel().m_8055_(event.getPos()).m_61124_((Property)HitchingPostBaseMini.CUSTOM_LEAD, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (state.m_60734_() instanceof LeadAnchorBlock) {
            event.getLevel().m_5594_(event.getEntity(), event.getPos(), state.m_60734_().getSoundType(state, (LevelReader)event.getLevel(), event.getPos(), (Entity)event.getEntity()).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            event.getLevel().m_7731_(event.getPos(), Blocks.f_50016_.m_49966_(), 3);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hideLeadKnotEntity(EntityJoinLevelEvent event) {
        Block block;
        if (event.getEntity() instanceof LeashFenceKnotEntity && !event.getEntity().m_9236_().f_46443_ && ((block = event.getLevel().m_8055_(event.getEntity().m_20183_()).m_60734_()) instanceof HitchingPostBase || block instanceof HitchingPostBaseMini || block instanceof LeadAnchorBlock || block instanceof HitchingRing)) {
            event.getEntity().m_6842_(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().getPersistentData().m_128471_("swem:tank_controls")) {
            SWEMPackets.sendToPlayers(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), new ClientBoundSetTankControlsPacket());
        }
    }

    @SubscribeEvent
    public static void onLightningStrike(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof SWEMHorseEntityBase) {
            LightningBolt bolt = event.getLightning();
            bolt.m_20874_(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof SWEMHorseEntityBase) {
            SWEMHorseEntityBase horse = (SWEMHorseEntityBase)livingEntity;
            DamageSource source = event.getSource();
            if (source.m_269533_(DamageTypeTags.f_268725_)) {
                horse.m_9236_().m_6269_(null, (Entity)horse, SoundEvents.f_12145_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                event.setAmount(0.0f);
                horse.m_7311_(0);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof Player) {
            if (event.getEntity().m_20159_()) {
                event.getEntity().m_8127_();
            }
            event.getEntity().getPersistentData().m_128473_("FilmingHorse");
        }
    }

    @SubscribeEvent
    public static void syncKeys(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public static void onBarrelShearing(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack itemstack = event.getItemStack();
        InteractionHand handIn = event.getHand();
        Level worldIn = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = worldIn.m_8055_(pos);
        if (itemstack.m_41720_() == Items.f_42574_ && player.m_6144_() && state.m_60734_() instanceof BarrelBlock) {
            itemstack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(handIn));
            BarrelBlockEntity te = (BarrelBlockEntity)worldIn.m_7702_(pos);
            for (int i = 0; i < te.m_6643_(); ++i) {
                ItemStack stack = te.m_8020_(i);
                if (stack.m_41619_()) continue;
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
            }
            worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            ItemEntity entity2 = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)BlockSetup.HALF_BARRELS.get(DyeColor.BROWN.m_41060_()).get()));
            ItemEntity entity1 = new ItemEntity(worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)BlockSetup.HALF_BARRELS.get(DyeColor.BROWN.m_41060_()).get()));
            worldIn.m_7967_((Entity)entity2);
            worldIn.m_7967_((Entity)entity1);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.ALLOW);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void breakWheelBarrow(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_6144_()) {
            return;
        }
        BlockEntity be = event.getLevel().m_7702_(event.getPos());
        if (!(be instanceof WheelBarrowBE)) {
            return;
        }
        WheelBarrowBE wheelbarrow = (WheelBarrowBE)be;
        BlockState state = event.getLevel().m_8055_(event.getPos());
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        wheelbarrow.m_187476_(stack);
        event.getEntity().m_150109_().m_150079_(stack);
        event.getLevel().m_8055_(event.getPos()).onDestroyedByPlayer(event.getLevel(), event.getPos(), event.getEntity(), true, event.getLevel().m_6425_(event.getPos()));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void recolorTackBox(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().m_6144_()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().m_8055_(pos);
        if (!(state.m_60734_() instanceof TackBoxBlock)) {
            return;
        }
        ItemStack heldItem = event.getItemStack();
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color == null) {
            return;
        }
        BlockState targetState = ((TackBoxBlock)((Object)BlockSetup.TACK_BOX.get(color.m_41060_()).get())).m_49966_();
        targetState = (BlockState)targetState.m_61124_(TackBoxBlock.TYPE, (Comparable)((Object)((SWEMBlockStateProperties.TackBoxType)((Object)state.m_61143_(TackBoxBlock.TYPE)))));
        targetState = (BlockState)targetState.m_61124_((Property)TackBoxBlock.f_54117_, (Comparable)((Direction)state.m_61143_((Property)TackBoxBlock.f_54117_)));
        Level level = event.getLevel();
        CompoundTag nbt = level.m_7702_(pos).m_187482_();
        level.m_7731_(pos, targetState, 3);
        level.m_7702_(pos).m_142466_(nbt);
        heldItem.m_41774_(1);
    }

    @SubscribeEvent
    public static void onBlockMissingMappings(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256747_, "swem").forEach(mapping -> {
            String blockName = mapping.getKey().m_135815_();
            if (blockName.equalsIgnoreCase("amethyst_ore")) {
                mapping.remap((Object)Blocks.f_50069_);
                return;
            }
            if (blockName.equalsIgnoreCase("banner")) {
                mapping.remap((Object)((Block)BlockSetup.BANNER.get()));
                return;
            }
            if (blockName.equalsIgnoreCase("whitewash_plank")) {
                mapping.remap((Object)((Block)BlockSetup.WHITEWASH_PLANKS.get()));
            }
            mapping.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("swpm", blockName))));
        });
        event.getMappings(Registries.f_256913_, "swem").forEach(mapping -> {
            String itemName = mapping.getKey().m_135815_();
            if (itemName.equalsIgnoreCase("whitewash_plank")) {
                mapping.remap((Object)((Block)BlockSetup.WHITEWASH_PLANKS.get()).m_5456_());
            }
            if (itemName.equalsIgnoreCase("amethyst_ore")) {
                mapping.ignore();
                return;
            }
            if (itemName.equalsIgnoreCase("amethyst")) {
                mapping.remap((Object)((Item)ItemSetup.SHINING_AMETHYST_SHARD.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("amethyst_pants")) {
                mapping.remap((Object)((Item)ItemSetup.AMETHYST_LEGGINGS.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("diamond_longsword")) {
                mapping.remap((Object)((Item)ItemSetup.DIAMOND_SWORD.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("gold_longsword")) {
                mapping.remap((Object)((Item)ItemSetup.GOLD_SWORD.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("iron_longsword")) {
                mapping.remap((Object)((Item)ItemSetup.IRON_SWORD.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("banner")) {
                mapping.remap((Object)((Item)ItemSetup.ALAHARRAN_BANNER.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("banner_pattern")) {
                mapping.remap((Object)((Item)ItemSetup.ALAHARRAN_BANNER_PATTERN.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("horse_armor_amethyst_netherite")) {
                mapping.remap((Object)((Item)ItemSetup.AMETHYST_HORSE_ARMOR_WITHERED.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("horse_armor_amethyst_emerald")) {
                mapping.remap((Object)((Item)ItemSetup.AMETHYST_HORSE_ARMOR_ELVEN.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("horse_armor_amethyst_copper")) {
                mapping.remap((Object)((Item)ItemSetup.AMETHYST_HORSE_ARMOR_SULTAN.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("adventure_saddle_amethyst_netherite")) {
                mapping.remap((Object)((Item)ItemSetup.ADVENTURE_SADDLE_WITHERED.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("adventure_saddle_amethyst_emerald")) {
                mapping.remap((Object)((Item)ItemSetup.ADVENTURE_SADDLE_ELVEN.get()));
                return;
            }
            if (itemName.equalsIgnoreCase("adventure_saddle_amethyst_copper")) {
                mapping.remap((Object)((Item)ItemSetup.ADVENTURE_SADDLE_SULTAN.get()));
                return;
            }
            mapping.remap((Object)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("swpm", itemName))));
        });
    }

    static {
        SWEM_DATA_PATH = new LevelResource("swem");
        RANGE_MODIFIER_ID = UUID.fromString("610e8686-32c8-46df-b3f5-03c3dede706a");
        RANGE_MODIFIER = new AttributeModifier(RANGE_MODIFIER_ID, "horseback_reach", 1.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }
}

