/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.progression.leveling;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.GodBehavior;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.ILeveling;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;

public class HealthLeveling
implements ILeveling {
    private final SWEMHorseEntityBase horse;
    private final SynchedEntityData dataManager;
    private final float[] requiredXpArray;
    private final String[] levelNames = new String[]{"Health I", "Health II", "Health III", "Health IV", "Health V"};

    public HealthLeveling(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.dataManager = this.horse.m_20088_();
        this.requiredXpArray = new float[]{(float)((Integer)ServerConfig.TOTAL_HEALTH_XP.get()).intValue() * 0.1f, (float)((Integer)ServerConfig.TOTAL_HEALTH_XP.get()).intValue() * 0.225f, (float)((Integer)ServerConfig.TOTAL_HEALTH_XP.get()).intValue() * 0.3f, (float)((Integer)ServerConfig.TOTAL_HEALTH_XP.get()).intValue() * 0.375f};
    }

    @Override
    public boolean addXP(float amount) {
        if (this.getLevel() == this.getMaxLevel()) {
            return false;
        }
        this.setXp(this.getXp() + amount);
        return this.checkLevelUp();
    }

    @Override
    public void removeXp(float amount) {
        this.setXp(this.getXp() - amount);
    }

    @Override
    public boolean checkLevelUp() {
        if (this.getXp() >= this.getRequiredXp() && this.getLevel() < this.getMaxLevel()) {
            this.levelUp();
            return true;
        }
        return false;
    }

    @Override
    public void levelUp() {
        String oldLevel = this.getLevelName();
        float excessXP = this.getXp() - this.getRequiredXp();
        this.setLevel(this.getLevel() + 1);
        this.setXp(excessXP);
        this.horse.onLevelUp(oldLevel, this.getLevelName());
        this.horse.levelUpHealth();
    }

    @Override
    public int getLevel() {
        return (Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_LEVEL);
    }

    public void setLevel(int level) {
        this.dataManager.m_135381_(SWEMHorseEntityBase.HEALTH_LEVEL, (Object)Mth.m_14045_((int)level, (int)0, (int)this.getMaxLevel()));
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public float getXp() {
        return ((Float)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_XP)).floatValue();
    }

    public void setXp(float xp) {
        if (this.horse.getBehavior(GodBehavior.class).isGod()) {
            return;
        }
        if (xp < 0.0f) {
            xp = 0.0f;
        }
        this.dataManager.m_135381_(SWEMHorseEntityBase.HEALTH_XP, (Object)Float.valueOf(xp));
    }

    @Override
    public float getRequiredXp() {
        if (this.getLevel() == this.getMaxLevel()) {
            return -1.0f;
        }
        return this.requiredXpArray[(Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_LEVEL)];
    }

    @Override
    public String getLevelName() {
        return this.levelNames[(Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_LEVEL)];
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("HealthLevel", ((Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_LEVEL)).intValue());
        compound.m_128350_("HealthXP", ((Float)this.dataManager.m_135370_(SWEMHorseEntityBase.HEALTH_XP)).floatValue());
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128441_("HealthLevel")) {
            this.setLevel(compound.m_128451_("HealthLevel"));
        }
        if (compound.m_128441_("HealthXP")) {
            this.setXp(compound.m_128457_("HealthXP"));
        }
    }
}

