/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.progression.leveling;

import com.alaharranhonor.swem.forge.config.ServerConfig;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.impl.GodBehavior;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.ILeveling;
import com.alaharranhonor.swem.forge.registry.ItemSetup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class AffinityLeveling
implements ILeveling {
    public final float[] requiredXpArray;
    private final SWEMHorseEntityBase horse;
    private final SynchedEntityData dataManager;
    private final String[] levelNames = new String[]{"Affinity", "Affinity I", "Affinity II", "Affinity III", "Affinity IV", "Affinity V", "Affinity VI", "Affinity VII", "Affinity VIII", "Affinity IX", "Affinity X", "Bonded"};
    private final float[] obeyDebuff = new float[]{1.0f, 0.95f, 0.9f, 0.85f, 0.75f, 0.65f, 0.5f, 0.35f, 0.2f, 0.1f, 0.05f, 0.0f};
    private int currentSwipes = 0;
    private int[] daysSwiped = new int[5];
    private int timesBrushed = 0;

    public AffinityLeveling(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.dataManager = this.horse.m_20088_();
        this.requiredXpArray = new float[this.obeyDebuff.length];
        this.requiredXpArray[0] = 100.0f;
        for (int i = 1; i < this.obeyDebuff.length; ++i) {
            this.requiredXpArray[i] = (float)((Integer)ServerConfig.TOTAL_AFFINITY_XP.get()).intValue() * (1.0f - this.obeyDebuff[i]);
        }
    }

    public boolean brush() {
        if (this.timesBrushed < 7) {
            if (this.timesBrushed >= 5) {
                this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 4);
            } else if (this.timesBrushed >= 3) {
                this.horse.emitYayParticles((ServerLevel)this.horse.m_9236_(), 4);
            } else {
                this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
            }
            ++this.timesBrushed;
            this.addXP(10 - this.timesBrushed);
            return true;
        }
        this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 4);
        return false;
    }

    @Override
    public boolean addXP(float amount) {
        if (this.getLevel() == this.getMaxLevel()) {
            return false;
        }
        this.setXp(this.getXp() + amount);
        return this.checkLevelUp();
    }

    @Override
    public void removeXp(float amount) {
        this.setXp(this.getXp() - amount);
    }

    @Override
    public boolean checkLevelUp() {
        if (this.getXp() >= this.getRequiredXp() && this.getLevel() < this.getMaxLevel()) {
            this.levelUp();
            return true;
        }
        return false;
    }

    @Override
    public void levelUp() {
        String oldLevel = this.getLevelName();
        float excessXP = this.getXp() - this.getRequiredXp();
        this.setLevel(this.getLevel() + 1);
        this.setXp(excessXP);
        this.horse.onLevelUp(oldLevel, this.getLevelName());
        if (this.getLevel() == 7) {
            this.horse.messageRider((Component)Component.m_237110_((String)"horse.swem.affinity.can_bite", (Object[])new Object[]{this.horse.m_5446_()}));
        } else if (this.getLevel() == 8) {
            this.horse.messageRider((Component)Component.m_237110_((String)"horse.swem.affinity.can_kick", (Object[])new Object[]{this.horse.m_5446_()}));
        } else if (this.getLevel() == 9) {
            this.horse.messageRider((Component)Component.m_237110_((String)"horse.swem.affinity.can_stomp", (Object[])new Object[]{this.horse.m_5446_()}));
        }
    }

    private void levelDown(float excessXP) {
        this.setLevel(this.getLevel() - 1);
        this.setXp(this.getRequiredXp() + excessXP);
    }

    @Override
    public int getLevel() {
        return (Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_LEVEL);
    }

    public void setLevel(int level) {
        this.dataManager.m_135381_(SWEMHorseEntityBase.AFFINITY_LEVEL, (Object)Mth.m_14045_((int)level, (int)0, (int)this.getMaxLevel()));
        if (level == 2 && this.horse.progressionManager.getJumpLeveling().getLevel() < 1) {
            this.horse.progressionManager.getJumpLeveling().levelUp();
        }
    }

    @Override
    public int getMaxLevel() {
        return 11;
    }

    @Override
    public float getXp() {
        return ((Float)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_XP)).floatValue();
    }

    public void setXp(float xp) {
        if (this.horse.getBehavior(GodBehavior.class).isGod()) {
            return;
        }
        if (xp < 0.0f && this.getLevel() > 0) {
            this.levelDown(xp);
            return;
        }
        this.dataManager.m_135381_(SWEMHorseEntityBase.AFFINITY_XP, (Object)Float.valueOf(Math.max(xp, 0.0f)));
    }

    @Override
    public float getRequiredXp() {
        return this.requiredXpArray[(Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_LEVEL)];
    }

    @Override
    public String getLevelName() {
        if (this.getLevel() == this.getMaxLevel()) {
            return this.levelNames[this.levelNames.length - 1];
        }
        return this.levelNames[(Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_LEVEL)];
    }

    public float getDebuff() {
        return this.obeyDebuff[(Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_LEVEL)];
    }

    public ItemStack getCurrentDesensitizingItem() {
        return (ItemStack)this.dataManager.m_135370_(SWEMHorseEntityBase.CURRENT_DESENSITIZING_ITEM);
    }

    private void setCurrentDesensitizingItem(ItemStack stack) {
        this.dataManager.m_135381_(SWEMHorseEntityBase.CURRENT_DESENSITIZING_ITEM, (Object)stack);
    }

    public void resetDaily() {
        this.currentSwipes = 0;
        this.timesBrushed = 0;
    }

    public void desensitize(ItemStack stack) {
        if (this.getCurrentDesensitizingItem().m_41720_() != stack.m_41720_() && !this.getCurrentDesensitizingItem().m_41619_() || this.currentSwipes >= 7) {
            this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 4);
            return;
        }
        ++this.currentSwipes;
        if (stack.m_41720_() == ItemSetup.BELLS.get() && this.daysSwiped[0] != -1) {
            this.setCurrentDesensitizingItem(stack);
            this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 3);
            int randomNum = this.horse.m_217043_().m_188503_(10) + 1;
            if (randomNum <= 9) {
                this.horse.disobey();
            } else {
                this.horse.startKick();
            }
            if (this.currentSwipes == 7) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                this.daysSwiped[0] = this.daysSwiped[0] + 1;
                if (this.daysSwiped[0] == 3) {
                    this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
                    this.setCurrentDesensitizingItem(ItemStack.f_41583_);
                    this.daysSwiped[0] = -1;
                    this.addXP(250.0f);
                }
            }
        } else if (stack.m_41720_() == ItemSetup.HOOLAHOOP.get() && this.daysSwiped[1] != -1) {
            this.setCurrentDesensitizingItem(stack);
            this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 3);
            int randomNum = this.horse.m_217043_().m_188503_(10) + 1;
            if (randomNum <= 9) {
                this.horse.disobey();
            } else {
                this.horse.startKick();
            }
            if (this.currentSwipes == 7) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                this.daysSwiped[1] = this.daysSwiped[1] + 1;
                if (this.daysSwiped[1] == 3) {
                    this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
                    this.setCurrentDesensitizingItem(ItemStack.f_41583_);
                    this.daysSwiped[1] = -1;
                    this.addXP(250.0f);
                }
            }
        } else if (stack.m_41720_() == ItemSetup.POMPOM.get() && this.daysSwiped[2] != -1) {
            this.setCurrentDesensitizingItem(stack);
            this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 3);
            int randomNum = this.horse.m_217043_().m_188503_(10) + 1;
            if (randomNum <= 9) {
                this.horse.disobey();
            } else {
                this.horse.startKick();
            }
            if (this.currentSwipes == 7) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                this.daysSwiped[2] = this.daysSwiped[2] + 1;
                if (this.daysSwiped[2] == 3) {
                    this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
                    this.setCurrentDesensitizingItem(ItemStack.f_41583_);
                    this.daysSwiped[2] = -1;
                    this.addXP(250.0f);
                }
            }
        } else if (stack.m_41720_() == ItemSetup.SHOPPING_BAG.get() && this.daysSwiped[3] != -1) {
            this.setCurrentDesensitizingItem(stack);
            this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 3);
            int randomNum = this.horse.m_217043_().m_188503_(10) + 1;
            if (randomNum <= 9) {
                this.horse.disobey();
            } else {
                this.horse.startKick();
            }
            if (this.currentSwipes == 7) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                this.daysSwiped[3] = this.daysSwiped[3] + 1;
                if (this.daysSwiped[3] == 3) {
                    this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
                    this.setCurrentDesensitizingItem(ItemStack.f_41583_);
                    this.addXP(250.0f);
                    this.daysSwiped[3] = -1;
                }
            }
        } else if (stack.m_41720_() == ItemSetup.TARP.get() && this.daysSwiped[4] != -1) {
            this.setCurrentDesensitizingItem(stack);
            this.horse.emitBadParticles((ServerLevel)this.horse.m_9236_(), 3);
            int randomNum = this.horse.m_217043_().m_188503_(10) + 1;
            if (randomNum <= 9) {
                this.horse.disobey();
            } else {
                this.horse.startKick();
            }
            if (this.currentSwipes == 7) {
                this.horse.emitEchParticles((ServerLevel)this.horse.m_9236_(), 4);
                this.daysSwiped[4] = this.daysSwiped[4] + 1;
                if (this.daysSwiped[4] == 3) {
                    this.horse.emitWootParticles((ServerLevel)this.horse.m_9236_(), 4);
                    this.setCurrentDesensitizingItem(ItemStack.f_41583_);
                    this.addXP(250.0f);
                    this.daysSwiped[4] = -1;
                }
            }
        }
    }

    @Override
    public void write(CompoundTag compound) {
        compound.m_128405_("AffinityLevel", ((Integer)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_LEVEL)).intValue());
        compound.m_128350_("AffinityXP", ((Float)this.dataManager.m_135370_(SWEMHorseEntityBase.AFFINITY_XP)).floatValue());
        CompoundTag nbt = new CompoundTag();
        compound.m_128365_("desensiztingItem", (Tag)((ItemStack)this.dataManager.m_135370_(SWEMHorseEntityBase.CURRENT_DESENSITIZING_ITEM)).m_41739_(nbt));
        compound.m_128405_("currentSwipes", this.currentSwipes);
        compound.m_128385_("daysSwiped", this.daysSwiped);
    }

    @Override
    public void read(CompoundTag compound) {
        if (compound.m_128441_("AffinityLevel")) {
            this.setLevel(compound.m_128451_("AffinityLevel"));
        }
        if (compound.m_128441_("AffinityXP")) {
            this.setXp(compound.m_128457_("AffinityXP"));
        }
        if (compound.m_128441_("desensiztingItem")) {
            this.setCurrentDesensitizingItem(ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_("desensiztingItem"))));
        }
        if (compound.m_128441_("currentSwipes")) {
            this.currentSwipes = compound.m_128451_("currentSwipes");
        }
        if (compound.m_128441_("daysSwiped")) {
            this.daysSwiped = compound.m_128465_("daysSwiped");
        }
    }
}

