/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.progression;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.AffinityLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.HealthLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.JumpLeveling;
import com.alaharranhonor.swem.forge.entities.horse.progression.leveling.SpeedLeveling;
import net.minecraft.nbt.CompoundTag;

public class ProgressionManager {
    private final SWEMHorseEntityBase horse;
    private final SpeedLeveling speedLeveling;
    private final JumpLeveling jumpLeveling;
    private final HealthLeveling healthLeveling;
    private final AffinityLeveling affinityLeveling;

    public ProgressionManager(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.speedLeveling = new SpeedLeveling(horse);
        this.jumpLeveling = new JumpLeveling(horse);
        this.healthLeveling = new HealthLeveling(horse);
        this.affinityLeveling = new AffinityLeveling(horse);
    }

    public void write(CompoundTag compound) {
        this.speedLeveling.write(compound);
        this.jumpLeveling.write(compound);
        this.healthLeveling.write(compound);
        this.affinityLeveling.write(compound);
    }

    public void read(CompoundTag compound) {
        this.speedLeveling.read(compound);
        this.jumpLeveling.read(compound);
        this.healthLeveling.read(compound);
        this.affinityLeveling.read(compound);
        while (this.speedLeveling.checkLevelUp()) {
        }
        while (this.jumpLeveling.checkLevelUp()) {
        }
        while (this.healthLeveling.checkLevelUp()) {
        }
        while (this.affinityLeveling.checkLevelUp()) {
        }
    }

    public SpeedLeveling getSpeedLeveling() {
        return this.speedLeveling;
    }

    public JumpLeveling getJumpLeveling() {
        return this.jumpLeveling;
    }

    public HealthLeveling getHealthLeveling() {
        return this.healthLeveling;
    }

    public AffinityLeveling getAffinityLeveling() {
        return this.affinityLeveling;
    }

    public String simpleString() {
        return "S" + this.speedLeveling.getLevel() + "J" + this.jumpLeveling.getLevel() + "H" + this.healthLeveling.getLevel() + "A" + this.affinityLeveling.getLevel();
    }
}

