/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.needs;

import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedBlock;
import com.alaharranhonor.swem.forge.entities.horse.needs.FeedItem;
import com.alaharranhonor.swem.forge.entities.horse.needs.Feeds;
import com.alaharranhonor.swem.forge.entities.horse.needs.SpecialFeedItem;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HungerNeed {
    private static final int MAX_FEEDS_PER_DAY = 10;
    private static final int POINTS_PER_DAY = 224;
    public static final int STOMACH_TICKS_PER_POINT = 44;
    private final SWEMHorseEntityBase horse;
    public final Object2IntOpenHashMap<ResourceLocation> timesFed = new Object2IntOpenHashMap();
    public HungerState state = HungerState.FED;
    public Object2IntOpenHashMap<FeedItem.Category> pointsPerCategory = new Object2IntOpenHashMap();
    public int points;
    public int missedMeals;
    public boolean ateGrain;
    public long fillTime;

    public HungerNeed(SWEMHorseEntityBase horse) {
        this.horse = horse;
        this.setState(HungerState.FED);
    }

    public void morningHungyTime() {
        this.points = 0;
        this.pointsPerCategory.clear();
        this.timesFed.clear();
        this.ateGrain = false;
        this.horse.setTotalTimesFed(0);
        this.fillTime = this.horse.m_9236_().m_46467_();
        if (this.horse.m_30614_()) {
            this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 10);
        }
    }

    public void nightHungyTime() {
        AttributeInstance maxHealth;
        if (!this.horse.m_30614_()) {
            return;
        }
        if (this.points < 224) {
            ++this.missedMeals;
            if (this.missedMeals > 21) {
                this.missedMeals = 21;
            }
        } else if (this.missedMeals > 0) {
            this.missedMeals -= 3;
            if (this.missedMeals < 0) {
                this.missedMeals = 0;
            }
        }
        if (this.state == HungerState.STARVING) {
            AttributeInstance maxHealth2 = this.horse.m_21051_(Attributes.f_22276_);
            if (maxHealth2.m_22115_() > 6.0) {
                maxHealth2.m_22100_(maxHealth2.m_22115_() - 1.0);
            }
        } else if ((this.state == HungerState.FED || this.state == HungerState.FULLY_FED) && (maxHealth = this.horse.m_21051_(Attributes.f_22276_)).m_22115_() <= this.horse.getAlteredMaxHealth()) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 1.0);
        }
        this.updateHungerState();
        this.horse.emitMehParticles((ServerLevel)this.horse.m_9236_(), 10);
    }

    public boolean feedWith(BlockState state) {
        if (this.horse.getTotalTimesFed() == 10 && !Feeds.FOLIAGE.ingredient().test(new ItemStack((ItemLike)state.m_60734_()))) {
            return false;
        }
        Block block = state.m_60734_();
        FeedBlock feed = Feeds.fromBlock(block);
        if (feed == null) {
            return false;
        }
        if (feed.maxPerDay() == this.getTimesFed(feed)) {
            return false;
        }
        int points = feed.getPointsForState(state);
        if (!Feeds.FOLIAGE.ingredient().test(new ItemStack((ItemLike)block))) {
            this.addTotalTimesFed(1);
        }
        this.timesFed.addTo((Object)feed.id(), 1);
        FeedItem.Category category = feed.category();
        if (this.pointsPerCategory.getInt((Object)category) >= category.pointLimit) {
            if (!this.horse.m_20067_()) {
                this.horse.m_5496_(SoundEvents.f_11976_, 1.0f, 1.0f + (this.horse.m_217043_().m_188501_() - this.horse.m_217043_().m_188501_()) * 0.2f);
            }
            feed.onEaten().accept(this.horse, true);
            return true;
        }
        this.pointsPerCategory.addTo((Object)category, feed.pointsGiven());
        this.points += points;
        this.fillTime = this.horse.m_9236_().m_46467_() + (long)points * 44L;
        if (feed.category() == FeedItem.Category.GRAINS) {
            this.ateGrain = true;
        }
        this.horse.progressionManager.getHealthLeveling().addXP(points);
        if (!this.horse.m_20067_()) {
            this.horse.m_5496_(SoundEvents.f_11976_, 1.0f, 1.0f + (this.horse.m_217043_().m_188501_() - this.horse.m_217043_().m_188501_()) * 0.2f);
        }
        feed.onEaten().accept(this.horse, false);
        return true;
    }

    public boolean feedWith(ItemStack stack) {
        SpecialFeedItem specialFeedItem = Feeds.getSpecialFeed(stack);
        if (specialFeedItem != null && !this.horse.hasEatenSpecialFeed(specialFeedItem)) {
            specialFeedItem.onEaten(this.horse);
            this.horse.addSpecialFeedToList(specialFeedItem.getId());
            return true;
        }
        if (this.horse.getTotalTimesFed() == 10 && !Feeds.FOLIAGE.ingredient().test(stack)) {
            return false;
        }
        FeedItem feed = this.getAsFeed(stack);
        if (feed == null) {
            return false;
        }
        if (feed.maxPerDay() == this.getTimesFed(feed)) {
            return false;
        }
        int points = feed.pointsGiven();
        if (!Feeds.FOLIAGE.ingredient().test(stack)) {
            this.addTotalTimesFed(1);
        }
        this.timesFed.addTo((Object)feed.id(), 1);
        FeedItem.Category category = feed.category();
        if (this.pointsPerCategory.getInt((Object)category) >= category.pointLimit) {
            if (!this.horse.m_20067_()) {
                this.horse.m_5496_(SoundEvents.f_11976_, 1.0f, 1.0f + (this.horse.m_217043_().m_188501_() - this.horse.m_217043_().m_188501_()) * 0.2f);
            }
            feed.onEaten().accept(this.horse, true);
            return true;
        }
        this.pointsPerCategory.addTo((Object)category, feed.pointsGiven());
        this.points += points;
        this.fillTime = this.horse.m_9236_().m_46467_() + (long)points * 44L;
        if (feed.category() == FeedItem.Category.GRAINS) {
            this.ateGrain = true;
        }
        this.horse.progressionManager.getHealthLeveling().addXP(points);
        if (!this.horse.m_20067_()) {
            this.horse.m_5496_(SoundEvents.f_11976_, 1.0f, 1.0f + (this.horse.m_217043_().m_188501_() - this.horse.m_217043_().m_188501_()) * 0.2f);
        }
        feed.onEaten().accept(this.horse, false);
        return true;
    }

    public FeedItem getAsFeed(ItemStack stack) {
        return Feeds.fromItem(stack);
    }

    public boolean canEatFeed(FeedItem feed) {
        return feed.horseyMustHaveYumYum() || !this.isSatisfied() && !this.isFilled() && this.getTimesFed(feed) < feed.maxPerDay() && this.pointsPerCategory.getInt((Object)feed.category()) < feed.category().pointLimit;
    }

    public boolean needsGrains() {
        return !this.ateGrain;
    }

    public boolean hasMaxPoints() {
        return this.points >= 224;
    }

    public boolean isSatisfied() {
        return this.hasMaxPoints() && !this.needsGrains();
    }

    public boolean isFilled() {
        return this.horse.m_9236_().m_46467_() < this.fillTime;
    }

    public int getTimesFed(FeedItem feed) {
        return this.timesFed.getInt((Object)feed.id());
    }

    public int getTotalTimesFed() {
        return this.horse.getTotalTimesFed();
    }

    private void addTotalTimesFed(int amount) {
        this.horse.setTotalTimesFed(this.getTotalTimesFed() + amount);
    }

    public void updateHungerState() {
        this.setState(HungerState.fromMeals(this.missedMeals, this.ateGrain));
    }

    public boolean isStarving() {
        return this.state == HungerState.STARVING;
    }

    public HungerState getState() {
        return HungerState.values()[(Integer)this.horse.m_20088_().m_135370_(SWEMHorseEntityBase.HUNGER_STATE)];
    }

    public void setState(HungerState state) {
        this.state = state;
        this.horse.m_20088_().m_135381_(SWEMHorseEntityBase.HUNGER_STATE, (Object)state.ordinal());
        state.applyDebuff(this.horse);
    }

    public void setFromState(HungerState state) {
        this.missedMeals = state.missedMeals;
        this.horse.levelUpHealth();
        this.setState(state);
    }

    public CompoundTag write(CompoundTag nbt) {
        if (this.state == null) {
            return nbt;
        }
        nbt.m_128359_("State", this.state.id);
        nbt.m_128405_("MissedMeals", this.missedMeals);
        nbt.m_128379_("AteGrain", this.ateGrain);
        nbt.m_128405_("Points", this.points);
        nbt.m_128405_("TotalTimesFed", this.horse.getTotalTimesFed());
        CompoundTag timesFedNbt = new CompoundTag();
        this.timesFed.forEach((id, times) -> timesFedNbt.m_128405_(id.toString(), times.intValue()));
        nbt.m_128365_("TimesFed", (Tag)timesFedNbt);
        nbt.m_128356_("FillTime", this.fillTime);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        this.missedMeals = nbt.m_128451_("MissedMeals");
        this.ateGrain = nbt.m_128471_("AteGrain");
        this.points = nbt.m_128451_("Points");
        this.fillTime = nbt.m_128451_("FillTime");
        int totalTimesFed = nbt.m_128451_("TotalTimesFed");
        this.addTotalTimesFed(totalTimesFed);
        CompoundTag timesFedTag = nbt.m_128469_("TimesFed");
        for (String feed : timesFedTag.m_128431_()) {
            this.timesFed.put((Object)new ResourceLocation(feed), timesFedTag.m_128451_(feed));
        }
        if (nbt.m_128441_("State")) {
            this.setState(HungerState.fromId(nbt.m_128461_("State")));
        } else {
            this.updateHungerState();
        }
    }

    public static enum HungerState {
        STARVING("starving", 7, SWEMHorseEntityBase.Gait.WALK, 0.3f, 0.3f),
        MALNOURISHED("malnourished", 3, SWEMHorseEntityBase.Gait.CANTER, 0.2f, 0.2f),
        HUNGRY("hungry", 1, SWEMHorseEntityBase.Gait.GALLOP, 0.1f, 0.1f),
        FED("fed", 0, SWEMHorseEntityBase.Gait.GALLOP, 0.0f, 0.0f),
        FULLY_FED("fully_fed", 0, SWEMHorseEntityBase.Gait.GALLOP, 0.0f, -0.1f);

        public static final UUID ATTRIBUTE_ID;
        public final String id;
        private final int missedMeals;
        private final SWEMHorseEntityBase.Gait maxSpeed;
        public final float speedDebuff;
        public final float obedienceDebuff;

        private HungerState(String id, int missedMeals, SWEMHorseEntityBase.Gait maxSpeed, float speedDebuff, float obedienceDebuff) {
            this.id = id;
            this.missedMeals = missedMeals;
            this.maxSpeed = maxSpeed;
            this.speedDebuff = speedDebuff;
            this.obedienceDebuff = obedienceDebuff;
        }

        public void applyDebuff(SWEMHorseEntityBase horse) {
            AttributeInstance attr = horse.m_21051_(Attributes.f_22279_);
            attr.m_22120_(ATTRIBUTE_ID);
            if (horse.getGait() != SWEMHorseEntityBase.Gait.WALK && this.speedDebuff != 0.0f) {
                attr.m_22125_(new AttributeModifier(ATTRIBUTE_ID, this.id, (double)(-this.speedDebuff), AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }

        public void removeDebuff(SWEMHorseEntityBase horse) {
            AttributeInstance attr = horse.m_21051_(Attributes.f_22279_);
            attr.m_22120_(ATTRIBUTE_ID);
        }

        public boolean canBeAtSpeed(SWEMHorseEntityBase.Gait speed) {
            return speed.ordinal() <= this.maxSpeed.ordinal();
        }

        public static HungerState fromId(String id) {
            for (HungerState state : HungerState.values()) {
                if (!state.id.equals(id)) continue;
                return state;
            }
            return FED;
        }

        public static HungerState fromMeals(int missedMeals, boolean ateGrain) {
            if (ateGrain && missedMeals == 0) {
                return FULLY_FED;
            }
            for (HungerState state : HungerState.values()) {
                if (missedMeals < state.missedMeals) continue;
                return state;
            }
            return FED;
        }

        public boolean reducesGallop() {
            return this.ordinal() < 3;
        }

        static {
            ATTRIBUTE_ID = UUID.fromString("4d3ef4b3-2384-4a75-9927-ebf090ae1250");
        }
    }
}

