/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.coats;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.community.CommunityManager;
import com.alaharranhonor.swem.forge.entities.horse.coats.BaseCoats;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseCoat;
import com.alaharranhonor.swem.forge.entities.horse.coats.HorseColor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class CoatManager {
    private static final Map<ResourceLocation, HorseCoat> ALL_COATS = new HashMap<ResourceLocation, HorseCoat>();
    private static final Map<ResourceLocation, HorseCoat> FOAL_COATS = new HashMap<ResourceLocation, HorseCoat>();
    private static final List<HorseCoat> COAT_CYCLE = new ArrayList<HorseCoat>();
    private static final Path COATS_DIR = CommunityManager.COMMUNITY_DIR.resolve("coats");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(HorseColor.class, (Object)new HorseColor.Serializer()).create();

    public static void init() {
        CoatManager.register(BaseCoats.SALAMARTY_ARISHANT_CYTRIS);
        CoatManager.register(BaseCoats.WHITE);
        CoatManager.register(BaseCoats.GRAY);
        CoatManager.register(BaseCoats.BLACK);
        CoatManager.register(BaseCoats.CHESTNUT);
        CoatManager.register(BaseCoats.BROWN);
        CoatManager.register(BaseCoats.ROAN);
        CoatManager.register(BaseCoats.BUCKSKIN);
        CoatManager.register(BaseCoats.PAINT);
        CoatManager.register(BaseCoats.PALOMINO);
        CoatManager.register(BaseCoats.NOBUCKLE);
        CoatManager.register(BaseCoats.WILDANDFREE);
        CoatManager.register(BaseCoats.TALLDARKHANDSOME);
        CoatManager.register(BaseCoats.SWEETBOI);
        CoatManager.register(BaseCoats.APPY);
        CoatManager.register(BaseCoats.GOLDEN);
        CoatManager.register(BaseCoats.LEOPARD);
        CoatManager.register(BaseCoats.GALAXY);
        CoatManager.register(BaseCoats.RAINBOW);
        CoatManager.register(BaseCoats.MAN_O_WAR);
        CoatManager.register(BaseCoats.SECRETARIAT);
        CoatManager.register(BaseCoats.SERGEANT_RECKLESS);
        CoatManager.register(BaseCoats.VALEGRO);
        CoatManager.register(BaseCoats.DOLLAR_JOHN_WAYNE);
        CoatManager.register(BaseCoats.TRIGGER_ROY_ROGERS);
        CoatManager.register(BaseCoats.MR_ED);
        CoatManager.register(BaseCoats.JOERGEN_PEWDIEPIE);
        CoatManager.register(BaseCoats.SHWOOMPL_MARKIPLIER);
        CoatManager.register(BaseCoats.FINBAR_FOALEY_JACKSEPTICEYE);
        CoatManager.register(BaseCoats.JOEY_THIS_ESME);
        CoatManager.register(BaseCoats.GOOSEBERRY_JUSTPEACHY);
        CoatManager.register(BaseCoats.EPONA_ZELDA);
        CoatManager.register(BaseCoats.ROACH_WITCHER);
        CoatManager.register(BaseCoats.AGRO_SOC);
        CoatManager.register(BaseCoats.SHADOWMERE_OBLIVION);
        CoatManager.register(BaseCoats.RAPIDASH_POKEMON);
        CoatManager.register(BaseCoats.SWIFT_WIND_SHE_RA);
        CoatManager.register(BaseCoats.BOB_FREE_REIN);
        CoatManager.register(BaseCoats.FARCAH_ZORSE_TAN_HAUKET);
        CoatManager.register(BaseCoats.SARINE_ZORSE_PAINT_HAUKET);
        CoatManager.register(BaseCoats.CALIHOPE_ZORSE_DARK_HAUKET);
        CoatManager.register(BaseCoats.COURIER_CALICO_HAUKET);
        CoatManager.register(BaseCoats.GUARDIAN_BAY_GRAY_HAUKET);
        CoatManager.register(BaseCoats.ROYAL_BRINDLE_HAUKET);
        CoatManager.register(BaseCoats.RIPTIDE_PEACOCK_HAUKET);
        CoatManager.register(BaseCoats.ARIALS_MALLI);
        CoatManager.register(BaseCoats.EL_CAZADOR_MALLI);
        CoatManager.register(BaseCoats.POLARIS_MALLI);
        CoatManager.register(BaseCoats.DUSTAR_MALLI);
        CoatManager.register(BaseCoats.CALIHAN_MALLI);
        CoatManager.register(BaseCoats.VULCAN_ARISHANT);
        CoatManager.register(BaseCoats.AVALANCHE_ARISHANT);
        CoatManager.register(BaseCoats.ORION_ARISHANT);
        CoatManager.register(BaseCoats.PARIS_ARISHANT);
        CoatManager.register(BaseCoats.ROSITA_ARISHANT);
        CoatManager.register(BaseCoats.IBIS_ARISHANT);
        CoatManager.register(BaseCoats.MONTY_ARISHANT);
        CoatManager.register(BaseCoats.HELIOS_ARISHANT);
        CoatManager.register(BaseCoats.TYRA_CYTRIS);
        CoatManager.register(BaseCoats.PHAROAH_ARISHANT);
        CoatManager.register(BaseCoats.POPPY_ARISHANT);
        CoatManager.register(BaseCoats.PARAMOUNT_CYTRIS);
        CoatManager.register(BaseCoats.SYRACUSE_ARISHANT);
        CoatManager.register(BaseCoats.ABYSS_ARISHANT);
        CoatManager.register(BaseCoats.DOMINO_ARISHANT);
        CoatManager.register(BaseCoats.DAHLIA_ARISHANT);
        CoatManager.register(BaseCoats.HIBISCUS_ARISHANT);
        CoatManager.register(BaseCoats.TITUS_ARISHANT);
        CoatManager.register(BaseCoats.ROMEO_ARISHANT);
        CoatManager.register(BaseCoats.PRIMROSE_ARISHANT);
        CoatManager.register(BaseCoats.LUNAR_ARISHANT);
        CoatManager.register(BaseCoats.NERO_STARDUST);
        CoatManager.register(BaseCoats.FORTUNE_STARDUST);
        CoatManager.register(BaseCoats.MASQUERADE_ARISHANT);
        CoatManager.register(BaseCoats.MIKA_STARDUST);
        CoatManager.register(BaseCoats.PANAMA_MALLI);
        CoatManager.register(BaseCoats.ASTERIA_ARISHANT);
        CoatManager.register(BaseCoats.FREYJA_ARISHANT);
        CoatManager.register(BaseCoats.SYMPHONY_ARISHANT);
        CoatManager.register(BaseCoats.SONATA_ARISHANT);
        CoatManager.register(BaseCoats.HEARTBREAKER_ARISHANT);
        CoatManager.register(BaseCoats.FREIGHTER_MALLI);
        CoatManager.register(BaseCoats.DELTA_MALLI);
        CoatManager.register(BaseCoats.BIRDIE_ARISHANT);
        CoatManager.register(BaseCoats.CARNELIAN_ARISHANT);
        CoatManager.register(BaseCoats.CHAMPION_ARISHANT);
        CoatManager.register(BaseCoats.APHRODITE_ARISHANT);
        CoatManager.register(BaseCoats.INFERNO_ARISHANT);
        CoatManager.register(BaseCoats.MYSTIC_ARISHANT);
        CoatManager.register(BaseCoats.MARZAPA_ARISHANT);
        CoatManager.register(BaseCoats.BANDIT_ARISHANT);
        CoatManager.register(BaseCoats.CAROUSEL_ARISHANT);
        CoatManager.register(BaseCoats.ANTIQUE_ARISHANT);
        CoatManager.register(BaseCoats.WREN_ARISHANT);
        CoatManager.register(BaseCoats.CITRINE_ARISHANT);
        CoatManager.register(BaseCoats.HURRICANE_ARISHANT);
        CoatManager.register(BaseCoats.PHANTOM_ARISHANT);
        CoatManager.register(BaseCoats.RUMBLE_ARISHANT);
        CoatManager.register(BaseCoats.MAPLE_ARISHANT);
        CoatManager.register(BaseCoats.RIVERA_ARISHANT);
        CoatManager.register(BaseCoats.US_MARSHALL);
        CoatManager.register(BaseCoats.FRANK_STEVECV);
        CoatManager.register(BaseCoats.TOOTHBRUSH_BOATY);
        CoatManager.register(BaseCoats.KODIAK_DELPHI);
        CoatManager.register(BaseCoats.ANNIE_LACE);
        CoatManager.register(BaseCoats.LADY_GUINEVERE_ARISHANT);
        CoatManager.register(BaseCoats.RIPPLE_BROOKE);
        CoatManager.register(BaseCoats.MIA_ERIC);
        CoatManager.register(BaseCoats.KHAREMA_CYTRIS);
        CoatManager.register(BaseCoats.ANGEL_RILEY);
        CoatManager.register(BaseCoats.LADY_JENNY);
        CoatManager.register(BaseCoats.LUCY_HANNAH);
        CoatManager.register(BaseCoats.PEGASUS_ARISHANT);
        CoatManager.registerFoal(BaseCoats.FOAL_BLACK_0);
        CoatManager.registerFoal(BaseCoats.FOAL_BLACK_1);
        CoatManager.registerFoal(BaseCoats.FOAL_BLACK);
        CoatManager.registerFoal(BaseCoats.FOAL_BROWN_0);
        CoatManager.registerFoal(BaseCoats.FOAL_BROWN_1);
        CoatManager.registerFoal(BaseCoats.FOAL_BROWN_2);
        CoatManager.registerFoal(BaseCoats.FOAL_CHESTNUT_0);
        CoatManager.registerFoal(BaseCoats.FOAL_CHESTNUT_1);
        CoatManager.registerFoal(BaseCoats.FOAL_CHESTNUT_2);
        CoatManager.registerFoal(BaseCoats.FOAL_CREAMY_0);
        CoatManager.registerFoal(BaseCoats.FOAL_CREAMY_1);
        CoatManager.registerFoal(BaseCoats.FOAL_CREAMY_2);
        CoatManager.registerFoal(BaseCoats.FOAL_DARK_BROWN_0);
        CoatManager.registerFoal(BaseCoats.FOAL_DARK_BROWN_1);
        CoatManager.registerFoal(BaseCoats.FOAL_DARK_BROWN_2);
        CoatManager.registerFoal(BaseCoats.FOAL_GRAY_0);
        CoatManager.registerFoal(BaseCoats.FOAL_GRAY_1);
        CoatManager.registerFoal(BaseCoats.FOAL_GRAY_2);
        CoatManager.registerFoal(BaseCoats.FOAL_WHITE_0);
        CoatManager.registerFoal(BaseCoats.FOAL_WHITE_1);
        CoatManager.registerFoal(BaseCoats.FOAL_WHITE_2);
    }

    public static void loadCommunityCoats() {
        File coatDir = COATS_DIR.toFile();
        if (!coatDir.exists() && !coatDir.mkdirs()) {
            ModRef.LOGGER.error("Failed to create community coats directory.");
            return;
        }
    }

    public static void loadCoats(File directory, String namespace) throws IOException {
        File[] coatFiles = directory.listFiles();
        if (coatFiles == null) {
            return;
        }
        for (File file : coatFiles) {
            if (file.isDirectory() || !file.getPath().endsWith(".json")) continue;
            try (FileReader reader = new FileReader(file);){
                HorseCoat coat = (HorseCoat)GSON.fromJson((Reader)reader, HorseCoat.class);
                String name = file.getName().substring(0, file.getName().length() - 5);
                if (coat == null) {
                    ModRef.LOGGER.warn("Invalid coat json for {}. Skipping.", (Object)file.getName());
                    continue;
                }
                coat.setId(new ResourceLocation(namespace, name));
            }
        }
    }

    public static void registerFoal(HorseCoat coat) {
        CoatManager.register(coat);
        FOAL_COATS.put(coat.id(), coat);
    }

    public static void register(HorseCoat coat) {
        ALL_COATS.put(coat.id(), coat);
        if (coat.lapisCyclable()) {
            COAT_CYCLE.add(coat);
        }
    }

    public static HorseCoat getNextCoat(HorseCoat currentCoat) {
        int currentIndex = COAT_CYCLE.indexOf(currentCoat);
        int nextIndex = (currentIndex + 1) % COAT_CYCLE.size();
        HorseCoat coat = COAT_CYCLE.get(nextIndex);
        while (coat.isBlacklisted()) {
            if (currentIndex == (nextIndex = (nextIndex + 1) % COAT_CYCLE.size())) {
                ModRef.LOGGER.warn("Could not find non-blacklisted coat. Selecting White");
                return BaseCoats.WHITE;
            }
            coat = COAT_CYCLE.get(nextIndex);
        }
        return coat;
    }

    public static HorseCoat getPreviousCoat(HorseCoat currentCoat) {
        int currentIndex = COAT_CYCLE.indexOf(currentCoat);
        int previousIndex = (currentIndex + COAT_CYCLE.size() - 1) % COAT_CYCLE.size();
        HorseCoat coat = COAT_CYCLE.get(previousIndex);
        while (coat.isBlacklisted()) {
            if (currentIndex == (previousIndex = (previousIndex + COAT_CYCLE.size() - 1) % COAT_CYCLE.size())) {
                ModRef.LOGGER.warn("Could not find non-blacklisted coat. Selecting White");
                return BaseCoats.WHITE;
            }
            coat = COAT_CYCLE.get(previousIndex);
        }
        return COAT_CYCLE.get(previousIndex);
    }

    public static HorseCoat get(ResourceLocation id) {
        return ALL_COATS.get(id);
    }

    public static HorseCoat foal(HorseColor color) {
        List foalCoats = FOAL_COATS.values().stream().filter(coat -> coat.baseColors().contains((Object)color)).collect(Collectors.toList());
        if (foalCoats.isEmpty()) {
            ModRef.LOGGER.warn("No foal coats available for {} base. Selecting WHITE", (Object)color.name());
            return BaseCoats.FOAL_WHITE_0;
        }
        Collections.shuffle(foalCoats);
        return (HorseCoat)foalCoats.get(0);
    }

    public static HorseCoat adult(HorseColor color) {
        List availableCoats = ALL_COATS.values().stream().filter(coat -> !coat.isBlacklisted()).filter(HorseCoat::obtainableByBreeding).filter(coat -> coat.baseColors().contains((Object)color)).collect(Collectors.toList());
        if (availableCoats.isEmpty()) {
            ModRef.LOGGER.warn("No breedable coats available for {} base. Selecting WHITE", (Object)color.name());
            return BaseCoats.WHITE;
        }
        Collections.shuffle(availableCoats);
        return (HorseCoat)availableCoats.get(0);
    }

    public static HorseCoat randomLapisCoat() {
        List coats = ALL_COATS.values().stream().filter(HorseCoat::lapisCyclable).filter(coat -> !coat.isBlacklisted()).collect(Collectors.toList());
        if (coats.isEmpty()) {
            return BaseCoats.WHITE;
        }
        Collections.shuffle(coats);
        return (HorseCoat)coats.get(0);
    }

    public static List<String> listCoatNames() {
        return ALL_COATS.keySet().stream().map(ResourceLocation::toString).toList();
    }
}

