/*
 * Decompiled with CFR 0.152.
 */
package com.alaharranhonor.swem.forge.entities.horse.behaviors.impl;

import com.alaharranhonor.swem.forge.ModRef;
import com.alaharranhonor.swem.forge.client.KeyBindSetup;
import com.alaharranhonor.swem.forge.community.TackType;
import com.alaharranhonor.swem.forge.entities.HorseAnimations;
import com.alaharranhonor.swem.forge.entities.horse.SWEMHorseEntityBase;
import com.alaharranhonor.swem.forge.entities.horse.behaviors.AbstractBehavior;
import com.alaharranhonor.swem.forge.network.protocol.SWEMPackets;
import com.alaharranhonor.swem.forge.network.protocol.game.flight.ServerBoundAccelerationFlightPacket;
import com.alaharranhonor.swem.forge.network.protocol.game.flight.ServerBoundHitWallPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FlightBehavior
extends AbstractBehavior {
    public static final ResourceLocation ID = ModRef.res("flight");
    public static final EntityDataAccessor<Boolean> IS_FLYING = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> TURN_STATE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ACCELERATION_STATE = SWEMHorseEntityBase.defineDataId(EntityDataSerializers.f_135028_);
    public static final int MAX_TURN_COUNTER = 50;
    public float speedXZ;
    public float speedY;
    public float rotation;
    public int launchCounter;

    public FlightBehavior(SWEMHorseEntityBase horse) {
        super(ID, horse);
    }

    @Override
    public boolean shouldTick() {
        return this.isFlying() || this.isLaunching();
    }

    @Override
    public void tick() {
        if (!this.horse.canFly()) {
            this.stopFlight(true);
            return;
        }
        if (this.horse.isInFluidType() || !this.isLaunching() && this.horse.m_20096_()) {
            this.stopFlight(false);
            if (this.horse.m_20096_() && (double)this.speedY < -0.75) {
                this.onWallHit();
                return;
            }
            return;
        }
        if (this.launchCounter > 0) {
            --this.launchCounter;
        }
        if ((double)this.speedY > -0.3) {
            this.horse.m_183634_();
        }
    }

    public void launch(Vec3 initialMotion) {
        this.horse.triggerAnim("horse", HorseAnimations.Keys.LAUNCH);
        this.launchCounter = 20;
        this.startFlight(initialMotion);
    }

    public void startFlight(Vec3 initialMotion) {
        if (!this.horse.m_9236_().m_5776_()) {
            this.horse.setGait(SWEMHorseEntityBase.Gait.WALK);
        }
        this.setData(IS_FLYING, true);
        this.speedXZ = (float)initialMotion.m_82542_(1.0, 0.0, 1.0).m_82553_();
        this.speedY = (float)initialMotion.m_82542_(0.0, 1.0, 0.0).m_82553_();
        this.setData(ACCELERATION_STATE, AccelerationState.GLIDE.ordinal());
        this.rotation = 0.0f;
        this.setData(TURN_STATE, TurnState.NONE.ordinal());
    }

    public void stopFlight(boolean force) {
        if (this.isLaunching()) {
            return;
        }
        if (this.horse.m_9236_().m_5776_()) {
            // empty if block
        }
        this.setData(IS_FLYING, false);
        this.launchCounter = 0;
    }

    public Vec2 getRiddenRotation(LivingEntity pEntity) {
        TurnState turnState;
        if (this.isLaunching()) {
            return new Vec2(this.horse.m_146909_(), this.horse.m_146908_());
        }
        float sidewaysMovement = -pEntity.f_20900_;
        TurnState lastTurnState = this.getTurnState();
        if (lastTurnState != (turnState = TurnState.fromMotion(sidewaysMovement))) {
            if (!pEntity.m_9236_().m_5776_()) {
                this.setData(TURN_STATE, turnState.ordinal());
            }
            this.rotation = 0.0f;
        }
        this.rotation = Mth.m_14121_((float)this.rotation, (float)((turnState.limit + (float)Mth.m_14205_((double)turnState.limit)) * (1.0f + this.speedXZ / 16.0f)), (float)1.0f);
        return new Vec2(this.horse.m_146909_(), this.horse.m_146908_() + this.rotation);
    }

    public Vec3 getRiddenInput(Player pPlayer, Vec3 pTravelVector) {
        if (this.isLaunching()) {
            return pTravelVector;
        }
        float forwardMovement = pPlayer.f_20902_;
        AccelerationState accelerationState = AccelerationState.GLIDE;
        if (forwardMovement > 0.0f) {
            accelerationState = AccelerationState.ACCELERATE;
            if (KeyBindSetup.RISE_FLIGHT.m_90857_()) {
                accelerationState = AccelerationState.RISE;
            } else if (KeyBindSetup.DIVE_FLIGHT.m_90857_()) {
                accelerationState = AccelerationState.DIVE;
            }
        } else {
            if (forwardMovement < 0.0f) {
                accelerationState = AccelerationState.FLOAT;
            }
            if (KeyBindSetup.RISE_FLIGHT.m_90857_()) {
                accelerationState = AccelerationState.ELEVATE;
            } else if (KeyBindSetup.DIVE_FLIGHT.m_90857_()) {
                accelerationState = AccelerationState.FLUTTER;
            }
        }
        this.setData(ACCELERATION_STATE, accelerationState.ordinal());
        SWEMPackets.sendToServer(new ServerBoundAccelerationFlightPacket(accelerationState));
        return pTravelVector;
    }

    public void tickRidden(Player pPlayer, Vec3 pTravelVector) {
        if (this.launchCounter > 0) {
            double launchMotion = 0.05;
            if (this.launchCounter >= 19) {
                launchMotion = 0.43;
            } else if (this.launchCounter >= 15) {
                launchMotion = 0.07;
            }
            this.horse.m_20256_(this.horse.m_20184_().m_82520_(0.0, launchMotion, 0.0));
            return;
        }
        float armorSpeedMultiplier = this.horse.hasTack(TackType.HORSE_ARMOR) ? 1.0f : 0.5f;
        AccelerationState accelerationState = this.getAccelerationState();
        this.speedXZ = Mth.m_14121_((float)this.speedXZ, (float)(accelerationState.limitXZ * armorSpeedMultiplier), (float)(accelerationState.stepXZ * armorSpeedMultiplier));
        this.speedY = Mth.m_14121_((float)this.speedY, (float)(accelerationState.limitY * armorSpeedMultiplier), (float)(accelerationState.stepY * armorSpeedMultiplier));
        this.horse.m_20334_(this.horse.m_20154_().f_82479_ * (double)this.speedXZ, this.speedY, this.horse.m_20154_().f_82481_ * (double)this.speedXZ);
        if (this.horse.m_9236_().f_46443_ && this.horse.f_19862_ && (double)this.speedXZ > 0.5) {
            SWEMPackets.sendToServer(new ServerBoundHitWallPacket());
        }
    }

    public void onWallHit() {
        if (!this.horse.m_9236_().m_5776_()) {
            this.horse.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2));
            this.horse.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2));
            Player player = this.horse.getControllingPlayer();
            if (player != null) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 40, 1));
            }
            this.horse.progressionManager.getAffinityLeveling().removeXp(7.0f);
        }
    }

    public AccelerationState getAccelerationState() {
        return AccelerationState.values()[this.getData(ACCELERATION_STATE)];
    }

    public void setAccelerationState(AccelerationState state) {
        this.setData(ACCELERATION_STATE, state.ordinal());
    }

    public TurnState getTurnState() {
        return TurnState.values()[this.getData(TURN_STATE)];
    }

    public boolean isLaunchingOrFlying() {
        return this.isLaunching() || this.isFlying();
    }

    public boolean isFlying() {
        return this.getData(IS_FLYING);
    }

    public boolean isLaunching() {
        return this.launchCounter > 0;
    }

    @Override
    public void defineData(SynchedEntityData dataManager) {
        dataManager.m_135372_(IS_FLYING, (Object)false);
        dataManager.m_135372_(TURN_STATE, (Object)TurnState.NONE.ordinal());
        dataManager.m_135372_(ACCELERATION_STATE, (Object)AccelerationState.GLIDE.ordinal());
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
    }

    public static enum AccelerationState {
        GLIDE("Glide", 0.2f, -0.1f, 0.01f, 0.03f),
        ACCELERATE("Accelerate", 1.5f, 0.0f, 0.015f, 0.02f),
        FLOAT("Float", 0.0f, -0.01f, 0.025f, 0.1f),
        ELEVATE("Elevate", 0.0f, 0.3f, 0.025f, 0.1f),
        FLUTTER("Flutter", 0.0f, -0.3f, 0.025f, 0.1f),
        RISE("Rise", 0.8f, 0.4f, 0.05f, 0.075f),
        DIVE("Dive", 0.5f, -1.5f, 0.025f, 0.02f);

        public final String name;
        private final float limitXZ;
        private final float limitY;
        private final float stepXZ;
        private final float stepY;

        private AccelerationState(String name, float limitXZ, float limitY, float stepXZ, float stepY) {
            this.name = name;
            this.limitXZ = limitXZ;
            this.limitY = limitY;
            this.stepXZ = stepXZ;
            this.stepY = stepY;
        }
    }

    public static enum TurnState {
        NONE("Float", 0),
        LEFT("Bank Left", -3),
        RIGHT("Bank Right", 3);

        public final String name;
        private final float limit;

        private TurnState(String name, int limit) {
            this.name = name;
            this.limit = limit;
        }

        public static TurnState fromMotion(double motion) {
            if (motion == 0.0) {
                return NONE;
            }
            if (motion < 0.0) {
                return LEFT;
            }
            return RIGHT;
        }
    }
}

